/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import org.apache.catalina.Globals;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.FilterUtil;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.res.StringManager;

public final class ApplicationFilterFactory {
    private static final Log log = LogFactory.getLog(ApplicationFilterFactory.class);
    private static final StringManager sm = StringManager.getManager(ApplicationFilterFactory.class);

    private ApplicationFilterFactory() {
    }

    public static ApplicationFilterChain createFilterChain(ServletRequest request, Wrapper wrapper, Servlet servlet) {
        ApplicationFilterConfig filterConfig;
        ApplicationFilterChain filterChain;
        if (servlet == null) {
            return null;
        }
        if (request instanceof Request) {
            Request req = (Request)request;
            if (Globals.IS_SECURITY_ENABLED) {
                filterChain = new ApplicationFilterChain();
            } else {
                filterChain = (ApplicationFilterChain)req.getFilterChain();
                if (filterChain == null) {
                    filterChain = new ApplicationFilterChain();
                    req.setFilterChain(filterChain);
                }
            }
        } else {
            filterChain = new ApplicationFilterChain();
        }
        filterChain.setServlet(servlet);
        filterChain.setServletSupportsAsync(wrapper.isAsyncSupported());
        StandardContext context = (StandardContext)wrapper.getParent();
        FilterMap[] filterMaps = context.findFilterMaps();
        if (filterMaps == null || filterMaps.length == 0) {
            return filterChain;
        }
        DispatcherType dispatcher = (DispatcherType)request.getAttribute("org.apache.catalina.core.DISPATCHER_TYPE");
        String requestPath = FilterUtil.getRequestPath(request);
        String servletName = wrapper.getName();
        for (FilterMap filterMap : filterMaps) {
            if (!ApplicationFilterFactory.matchDispatcher(filterMap, dispatcher) || !FilterUtil.matchFiltersURL(filterMap, requestPath)) continue;
            filterConfig = (ApplicationFilterConfig)context.findFilterConfig(filterMap.getFilterName());
            if (filterConfig == null) {
                log.warn((Object)sm.getString("applicationFilterFactory.noFilterConfig", filterMap.getFilterName()));
                continue;
            }
            filterChain.addFilter(filterConfig);
        }
        for (FilterMap filterMap : filterMaps) {
            if (!ApplicationFilterFactory.matchDispatcher(filterMap, dispatcher) || !ApplicationFilterFactory.matchFiltersServlet(filterMap, servletName)) continue;
            filterConfig = (ApplicationFilterConfig)context.findFilterConfig(filterMap.getFilterName());
            if (filterConfig == null) {
                log.warn((Object)sm.getString("applicationFilterFactory.noFilterConfig", filterMap.getFilterName()));
                continue;
            }
            filterChain.addFilter(filterConfig);
        }
        return filterChain;
    }

    private static boolean matchFiltersServlet(FilterMap filterMap, String servletName) {
        String[] servletNames;
        if (servletName == null) {
            return false;
        }
        if (filterMap.getMatchAllServletNames()) {
            return true;
        }
        for (String name : servletNames = filterMap.getServletNames()) {
            if (!servletName.equals(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchDispatcher(FilterMap filterMap, DispatcherType type) {
        switch (type) {
            case FORWARD: {
                if ((filterMap.getDispatcherMapping() & 2) == 0) break;
                return true;
            }
            case INCLUDE: {
                if ((filterMap.getDispatcherMapping() & 4) == 0) break;
                return true;
            }
            case REQUEST: {
                if ((filterMap.getDispatcherMapping() & 8) == 0) break;
                return true;
            }
            case ERROR: {
                if ((filterMap.getDispatcherMapping() & 1) == 0) break;
                return true;
            }
            case ASYNC: {
                if ((filterMap.getDispatcherMapping() & 0x10) == 0) break;
                return true;
            }
        }
        return false;
    }
}

