/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.util;

import jakarta.servlet.Servlet;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.annotation.WebInitParam;
import jakarta.servlet.annotation.WebServlet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletAnnotationScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ServletAnnotationScanner.class);
    public Boolean scanned = false;
    public String[] urlPatterns;
    public String servletName;
    public Integer loadOnStartup;
    public Boolean asyncSupported;
    public Map<String, String> webInitParams;
    public MultipartConfig multiPartConfigAnnotation;

    public ServletAnnotationScanner(Class<? extends Servlet> clazz) {
        Class<? extends Servlet> c = clazz;
        WebServlet servletAnnotation = null;
        while (servletAnnotation == null && Servlet.class.isAssignableFrom(c)) {
            servletAnnotation = c.getAnnotation(WebServlet.class);
            c = c.getSuperclass();
        }
        if (servletAnnotation == null) {
            return;
        }
        if (servletAnnotation.urlPatterns().length > 0 && servletAnnotation.value().length > 0) {
            LOG.warn(clazz.getName() + " defines both @WebServlet.value and @WebServlet.urlPatterns");
            return;
        }
        this.urlPatterns = servletAnnotation.value();
        if (this.urlPatterns.length == 0) {
            this.urlPatterns = servletAnnotation.urlPatterns();
        }
        if (this.urlPatterns.length == 0) {
            LOG.warn(clazz.getName() + " defines neither @WebServlet.value nor @WebServlet.urlPatterns");
            return;
        }
        this.servletName = servletAnnotation.name().equals("") ? null : servletAnnotation.name();
        WebInitParam[] initParams = servletAnnotation.initParams();
        if (initParams.length > 0) {
            this.webInitParams = new LinkedHashMap<String, String>();
            for (WebInitParam initParam : initParams) {
                this.webInitParams.put(initParam.name(), initParam.value());
            }
        }
        this.asyncSupported = servletAnnotation.asyncSupported();
        this.loadOnStartup = servletAnnotation.loadOnStartup();
        this.multiPartConfigAnnotation = clazz.getAnnotation(MultipartConfig.class);
        this.scanned = true;
    }
}

