/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.util;

import jakarta.servlet.Filter;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.annotation.WebInitParam;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterAnnotationScanner {
    private static final Logger LOG = LoggerFactory.getLogger(FilterAnnotationScanner.class);
    public Boolean scanned = false;
    public String[] urlPatterns;
    public String[] servletNames;
    public String filterName;
    public Boolean asyncSupported;
    public Map<String, String> webInitParams;
    public String[] dispatcherTypes;

    public FilterAnnotationScanner(Class<? extends Filter> clazz) {
        WebFilter filterAnnotation = clazz.getAnnotation(WebFilter.class);
        if (filterAnnotation == null) {
            return;
        }
        if (filterAnnotation.urlPatterns().length > 0 && filterAnnotation.value().length > 0) {
            LOG.warn(clazz.getName() + " defines both @WebFilter.value and @WebFilter.urlPatterns");
            return;
        }
        this.urlPatterns = filterAnnotation.value();
        if (this.urlPatterns.length == 0) {
            this.urlPatterns = filterAnnotation.urlPatterns();
        }
        this.servletNames = filterAnnotation.servletNames();
        if (this.urlPatterns.length == 0 && this.servletNames.length == 0) {
            LOG.warn(clazz.getName() + " doesn't define any of @WebFilter.value, @WebFilter.urlPatterns and @WebFilter.servletNames");
            return;
        }
        this.filterName = filterAnnotation.filterName().equals("") ? null : filterAnnotation.filterName();
        this.dispatcherTypes = (String[])Arrays.stream(filterAnnotation.dispatcherTypes()).map(Enum::name).toArray(String[]::new);
        WebInitParam[] initParams = filterAnnotation.initParams();
        if (initParams.length > 0) {
            this.webInitParams = new LinkedHashMap<String, String>();
            for (WebInitParam initParam : initParams) {
                this.webInitParams.put(initParam.name(), initParam.value());
            }
        }
        this.asyncSupported = filterAnnotation.asyncSupported();
        this.scanned = true;
    }
}

