/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.task;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.task.BatchVisitor;
import org.ops4j.pax.web.service.spi.task.Change;
import org.ops4j.pax.web.service.spi.task.OpCode;

public class ServletModelChange
extends Change {
    private ServletModel servletModel;
    private final Map<ServletModel, Boolean> servletModels = new LinkedHashMap<ServletModel, Boolean>();
    private boolean disabled;
    private final List<OsgiContextModel> newModels = new LinkedList<OsgiContextModel>();
    private String newModelsInfo;
    private boolean dynamic = false;

    public ServletModelChange(OpCode op, ServletModel servletModel, OsgiContextModel ... newModels) {
        this(op, servletModel, false, newModels);
    }

    public ServletModelChange(OpCode op, Map<ServletModel, Boolean> servletModels) {
        this(op, servletModels, false);
    }

    public ServletModelChange(OpCode op, Map<ServletModel, Boolean> servletModels, boolean dynamic) {
        super(op);
        this.servletModels.putAll(servletModels);
        this.dynamic = dynamic;
    }

    public ServletModelChange(OpCode op, ServletModel servletModel, boolean disabled, OsgiContextModel ... newModels) {
        super(op);
        this.servletModel = servletModel;
        this.servletModels.put(servletModel, !disabled);
        this.disabled = disabled;
        this.newModels.addAll(Arrays.asList(newModels));
        if (this.newModels.size() > 0) {
            this.newModelsInfo = this.newModels.stream().map(ocm -> String.format("{%s,%s,%s,%s}", ocm.isWhiteboard() ? "WB" : "HS", ocm.getId(), ocm.getName(), ocm.getContextPath())).collect(Collectors.joining(", ", "[", "]"));
        }
    }

    @Override
    public void uninstall(List<Change> operations) {
        if (this.getKind() == OpCode.ADD) {
            HashMap<ServletModel, Boolean> models = new HashMap<ServletModel, Boolean>();
            models.put(this.servletModel, true);
            operations.add(new ServletModelChange(OpCode.DELETE, models));
        }
    }

    public ServletModel getServletModel() {
        return this.servletModel;
    }

    public Map<ServletModel, Boolean> getServletModels() {
        return this.servletModels;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isDynamic() {
        return this.dynamic || this.servletModel != null && this.servletModel.isDynamic();
    }

    public List<OsgiContextModel> getNewModels() {
        return this.newModels;
    }

    public String getNewModelsInfo() {
        return this.newModelsInfo;
    }

    @Override
    public void accept(BatchVisitor visitor) {
        visitor.visitServletModelChange(this);
    }

    @Override
    public List<OsgiContextModel> getContextModels() {
        return this.newModels.size() > 0 ? this.newModels : this.servletModel.getContextModels();
    }

    public String toString() {
        ServletModel model = this.servletModel;
        if (model == null && this.servletModels.size() == 1) {
            model = this.servletModels.keySet().iterator().next();
        }
        if (model != null) {
            return String.valueOf((Object)this.getKind()) + ": " + String.valueOf(model) + (this.disabled ? " (disabled)" : " (enabled)") + (String)(this.newModelsInfo != null ? " (new contexts: " + this.newModelsInfo : "");
        }
        return String.valueOf((Object)this.getKind()) + ": " + this.servletModels.size() + " servlet models";
    }
}

