/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.task;

import java.util.List;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.ServletContextModel;
import org.ops4j.pax.web.service.spi.task.BatchVisitor;
import org.ops4j.pax.web.service.spi.task.Change;
import org.ops4j.pax.web.service.spi.task.OpCode;

public class OsgiContextModelChange
extends Change {
    private final WebContainerContext context;
    private final OsgiContextModel osgiContextModel;
    private final ServletContextModel servletContextModel;

    public OsgiContextModelChange(OpCode op, WebContainerContext context, OsgiContextModel osgiContextModel, ServletContextModel servletContextModel) {
        super(op);
        this.context = context;
        this.osgiContextModel = osgiContextModel;
        this.servletContextModel = servletContextModel;
    }

    @Override
    public void uninstall(List<Change> operations) {
        if (this.getKind() == OpCode.ADD) {
            operations.addAll(this.osgiContextModel.getUnregistrations());
            this.osgiContextModel.getUnregistrations().clear();
            operations.add(new OsgiContextModelChange(OpCode.DELETE, null, this.osgiContextModel, null));
        } else if (this.getKind() == OpCode.ASSOCIATE) {
            operations.add(new OsgiContextModelChange(OpCode.DISASSOCIATE, this.context, this.osgiContextModel, null));
        }
    }

    public WebContainerContext getContext() {
        return this.context;
    }

    public OsgiContextModel getOsgiContextModel() {
        return this.osgiContextModel;
    }

    public ServletContextModel getServletContextModel() {
        return this.servletContextModel;
    }

    @Override
    public void accept(BatchVisitor visitor) {
        visitor.visitOsgiContextModelChange(this);
    }

    public String toString() {
        return String.valueOf((Object)this.getKind()) + ": " + String.valueOf(this.osgiContextModel);
    }
}

