/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.task;

import jakarta.servlet.DispatcherType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.task.BatchVisitor;
import org.ops4j.pax.web.service.spi.task.Change;
import org.ops4j.pax.web.service.spi.task.OpCode;

public class FilterStateChange
extends Change {
    private final Map<String, TreeMap<FilterModel, List<OsgiContextModel>>> contextFilters;
    private boolean dynamic = false;
    private boolean useWebOrder = false;

    public FilterStateChange(Map<String, TreeMap<FilterModel, List<OsgiContextModel>>> contextFilters, boolean dynamic) {
        super(OpCode.NONE);
        this.contextFilters = contextFilters;
        this.dynamic = dynamic;
        for (TreeMap<FilterModel, List<OsgiContextModel>> map : contextFilters.values()) {
            for (FilterModel fm : map.keySet()) {
                if (fm.isDynamic()) continue;
                for (FilterModel.Mapping mapping : fm.getMappingsPerDispatcherTypes()) {
                    if (mapping.getDispatcherTypes() != null && mapping.getDispatcherTypes().length != 0) continue;
                    mapping.setDispatcherTypes(new DispatcherType[]{DispatcherType.REQUEST});
                }
            }
        }
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public Map<String, TreeMap<FilterModel, List<OsgiContextModel>>> getContextFilters() {
        return this.contextFilters;
    }

    public boolean useWebOrder() {
        return this.useWebOrder;
    }

    public void setUseWebOrder(boolean useWebOrder) {
        this.useWebOrder = useWebOrder;
    }

    @Override
    public void uninstall(List<Change> operations) {
        if (this.getKind() == OpCode.NONE) {
            HashMap<String, TreeMap<FilterModel, List<OsgiContextModel>>> newMap = new HashMap<String, TreeMap<FilterModel, List<OsgiContextModel>>>();
            for (String context : this.contextFilters.keySet()) {
                newMap.put(context, new TreeMap());
            }
            operations.add(new FilterStateChange(newMap, this.dynamic));
        }
    }

    @Override
    public void accept(BatchVisitor visitor) {
        visitor.visitFilterStateChange(this);
    }
}

