/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.servlet.dynamic;

import jakarta.servlet.HttpMethodConstraintElement;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletSecurityElement;
import jakarta.servlet.annotation.ServletSecurity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.ServletContextModel;
import org.ops4j.pax.web.service.spi.model.elements.SecurityConstraintModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.servlet.DynamicRegistrations;

public class DynamicServletRegistration
implements ServletRegistration.Dynamic {
    private final ServletModel model;
    private final OsgiContextModel osgiContextModel;
    private final ServletContextModel servletContextModel;
    private final DynamicRegistrations registrations;

    public DynamicServletRegistration(ServletModel model, OsgiContextModel osgiContextModel, ServletContextModel servletContextModel, DynamicRegistrations regs) {
        this.model = model;
        this.model.getContextModels();
        this.osgiContextModel = osgiContextModel;
        this.servletContextModel = servletContextModel;
        this.registrations = regs;
    }

    public ServletModel getModel() {
        return this.model;
    }

    public void setLoadOnStartup(int loadOnStartup) {
        this.model.setLoadOnStartup(loadOnStartup);
    }

    public Set<String> setServletSecurity(ServletSecurityElement constraint) {
        LinkedHashSet<String> conflicts = new LinkedHashSet<String>();
        ArrayList<SecurityConstraintModel> newConstraints = new ArrayList<SecurityConstraintModel>();
        for (String urlPattern : this.getMappings()) {
            boolean hasConflict = false;
            for (SecurityConstraintModel securityConstraintModel : this.osgiContextModel.getSecurityConfiguration().getSecurityConstraints()) {
                for (SecurityConstraintModel.WebResourceCollection col : securityConstraintModel.getWebResourceCollections()) {
                    if (!col.getPatterns().contains(urlPattern)) continue;
                    conflicts.add(urlPattern);
                    hasConflict = true;
                    break;
                }
                if (!hasConflict) continue;
                break;
            }
            if (hasConflict) continue;
            Collection withMethods = constraint.getHttpMethodConstraints();
            for (HttpMethodConstraintElement c : withMethods) {
                SecurityConstraintModel scm = new SecurityConstraintModel();
                scm.setServletModel(this.model);
                SecurityConstraintModel.WebResourceCollection col = new SecurityConstraintModel.WebResourceCollection();
                scm.getWebResourceCollections().add(col);
                scm.setTransportGuarantee(c.getTransportGuarantee());
                scm.getAuthRoles().addAll(Arrays.asList(c.getRolesAllowed()));
                if (scm.getAuthRoles().isEmpty()) {
                    scm.setAuthRolesSet(c.getEmptyRoleSemantic() == ServletSecurity.EmptyRoleSemantic.DENY);
                } else {
                    scm.setAuthRolesSet(true);
                }
                col.getPatterns().add(urlPattern);
                col.getMethods().add(c.getMethodName());
                newConstraints.add(scm);
            }
            SecurityConstraintModel securityConstraintModel = new SecurityConstraintModel();
            securityConstraintModel.setServletModel(this.model);
            SecurityConstraintModel.WebResourceCollection col = new SecurityConstraintModel.WebResourceCollection();
            securityConstraintModel.getWebResourceCollections().add(col);
            securityConstraintModel.setTransportGuarantee(constraint.getTransportGuarantee());
            securityConstraintModel.getAuthRoles().addAll(Arrays.asList(constraint.getRolesAllowed()));
            if (securityConstraintModel.getAuthRoles().isEmpty()) {
                securityConstraintModel.setAuthRolesSet(constraint.getEmptyRoleSemantic() == ServletSecurity.EmptyRoleSemantic.DENY);
            } else {
                securityConstraintModel.setAuthRolesSet(true);
            }
            col.getPatterns().add(urlPattern);
            col.getOmittedMethods().addAll(constraint.getMethodNames());
            newConstraints.add(securityConstraintModel);
        }
        this.osgiContextModel.getSecurityConfiguration().getSecurityConstraints().addAll(newConstraints);
        if (!newConstraints.isEmpty()) {
            this.model.setServletSecurityPresent(true);
        }
        return conflicts;
    }

    public void setMultipartConfig(MultipartConfigElement multipartConfig) {
        this.model.setMultipartConfigElement(multipartConfig);
    }

    public void setRunAsRole(String roleName) {
        this.model.setRunAs(roleName);
    }

    public void setAsyncSupported(boolean isAsyncSupported) {
        this.model.setAsyncSupported(isAsyncSupported);
    }

    public Set<String> addMapping(String ... urlPatterns) {
        LinkedHashSet<String> conflicts = new LinkedHashSet<String>();
        HashSet<String> existing = new HashSet<String>(this.servletContextModel.getServletUrlPatternMapping().keySet());
        this.registrations.getDynamicServletRegistrations().values().forEach(r -> {
            if (r != this) {
                existing.addAll(r.getMappings());
            }
        });
        for (String p : urlPatterns) {
            if (!existing.contains(p)) continue;
            conflicts.add(p);
        }
        if (conflicts.isEmpty()) {
            existing.clear();
            if (this.model.getUrlPatterns() != null) {
                existing.addAll(Arrays.asList(this.model.getUrlPatterns()));
            }
            existing.addAll(Arrays.asList(urlPatterns));
            this.model.setUrlPatterns(existing.toArray(new String[existing.toArray().length]));
            return Collections.emptySet();
        }
        return conflicts;
    }

    public Collection<String> getMappings() {
        return this.model.getUrlPatterns() == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(this.model.getUrlPatterns()));
    }

    public String getRunAsRole() {
        return this.model.getRunAs();
    }

    public String getName() {
        return this.model.getName();
    }

    public String getClassName() {
        return this.model.getActualClass().getName();
    }

    public boolean setInitParameter(String name, String value) {
        if (this.model.getInitParams().containsKey(name)) {
            return false;
        }
        this.model.getInitParams().put(name, value);
        return true;
    }

    public String getInitParameter(String name) {
        return this.model.getInitParams().get(name);
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        LinkedHashSet<String> existingKeys = new LinkedHashSet<String>(this.model.getInitParams().keySet());
        existingKeys.retainAll(initParameters.keySet());
        this.model.getInitParams().putAll(initParameters);
        return existingKeys;
    }

    public Map<String, String> getInitParameters() {
        return this.model.getInitParams();
    }
}

