/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.servlet.OsgiScopedServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;

public class ScopedFilter
implements Filter {
    private final Filter filter;
    private final FilterModel model;

    public ScopedFilter(Filter filter, FilterModel model) {
        this.filter = filter;
        this.model = model;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filter.init(filterConfig);
    }

    public void destroy() {
        this.filter.destroy();
    }

    public Filter getDelegate() {
        return this.filter;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ServletContext context = request.getServletContext();
        boolean skip = false;
        if (context instanceof OsgiScopedServletContext) {
            if (!this.model.getContextModels().contains(((OsgiScopedServletContext)context).getOsgiContextModel())) {
                skip = true;
            }
        } else if (context instanceof OsgiServletContext && !this.model.getContextModels().contains(((OsgiServletContext)context).getOsgiContextModel())) {
            skip = true;
        }
        if (!skip) {
            this.filter.doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }
}

