/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class OsgiScopedServletContext
implements ServletContext {
    private final OsgiServletContext osgiContext;
    private final Bundle bundle;
    private final WebContainerContext webContainerContext;
    private Supplier<ServletContext> contextSupplier;

    public OsgiScopedServletContext(OsgiServletContext osgiContext, Bundle bundle) {
        this.osgiContext = osgiContext;
        this.bundle = bundle;
        this.webContainerContext = osgiContext.getOsgiContextModel().resolveHttpContext(bundle);
    }

    public WebContainerContext getResolvedWebContainerContext() {
        return this.webContainerContext;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setContextSupplier(Supplier<ServletContext> contextSupplier) {
        this.contextSupplier = contextSupplier;
    }

    public void releaseWebContainerContext(Bundle bundle) {
        this.osgiContext.getOsgiContextModel().releaseHttpContext(bundle);
    }

    public OsgiServletContext getOsgiContext() {
        return this.osgiContext;
    }

    public OsgiContextModel getOsgiContextModel() {
        return this.osgiContext.getOsgiContextModel();
    }

    public ServletContext getContainerServletContext() {
        return this.osgiContext.getContainerServletContext();
    }

    public ClassLoader getOsgiContextClassLoader() {
        return this.osgiContext.getClassLoader();
    }

    public String[] getWelcomeFiles() {
        return this.osgiContext.getWelcomeFiles();
    }

    public boolean isWelcomeFilesRedirect() {
        return this.osgiContext.isWelcomeFilesRedirect();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return this.contextSupplier.get().addFilter(filterName, className);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return this.contextSupplier.get().addFilter(filterName, filter);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return this.contextSupplier.get().addFilter(filterName, filterClass);
    }

    public void addListener(String className) {
        this.contextSupplier.get().addListener(className);
    }

    public <T extends EventListener> void addListener(T t) {
        this.contextSupplier.get().addListener(t);
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        this.contextSupplier.get().addListener(listenerClass);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return this.contextSupplier.get().addServlet(servletName, className);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return this.contextSupplier.get().addServlet(servletName, servlet);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return this.contextSupplier.get().addServlet(servletName, servletClass);
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        return (T)this.contextSupplier.get().createFilter(clazz);
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        return (T)this.contextSupplier.get().createListener(clazz);
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        return (T)this.contextSupplier.get().createServlet(clazz);
    }

    public void declareRoles(String ... roleNames) {
        this.contextSupplier.get().declareRoles(roleNames);
    }

    public boolean setInitParameter(String name, String value) {
        return this.contextSupplier.get().setInitParameter(name, value);
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.contextSupplier.get().setSessionTrackingModes(sessionTrackingModes);
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        return this.contextSupplier.get().addJspFile(servletName, jspFile);
    }

    public Object getAttribute(String name) {
        return this.osgiContext.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.osgiContext.getAttributeNames();
    }

    public void setAttribute(String name, Object object) {
        this.osgiContext.setAttribute(name, object);
    }

    public void removeAttribute(String name) {
        this.osgiContext.removeAttribute(name);
    }

    public String getContextPath() {
        return this.osgiContext.getContextPath();
    }

    public ServletContext getContext(String uripath) {
        return this.osgiContext.getContext(uripath);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.osgiContext.getDefaultSessionTrackingModes();
    }

    public int getEffectiveMajorVersion() {
        return this.osgiContext.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.osgiContext.getEffectiveMinorVersion();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.osgiContext.getEffectiveSessionTrackingModes();
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return this.osgiContext.getFilterRegistration(filterName);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.osgiContext.getFilterRegistrations();
    }

    public int getMajorVersion() {
        return this.osgiContext.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.osgiContext.getMinorVersion();
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return this.osgiContext.getServletRegistration(servletName);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.osgiContext.getServletRegistrations();
    }

    public String getVirtualServerName() {
        return this.osgiContext.getVirtualServerName();
    }

    public String getServerInfo() {
        return this.osgiContext.getServerInfo();
    }

    public void log(String msg) {
        this.osgiContext.log(msg);
    }

    public void log(String message, Throwable throwable) {
        this.osgiContext.log(message, throwable);
    }

    public SessionCookieConfig getSessionCookieConfig() {
        SessionCookieConfig scc = this.osgiContext.getSessionCookieConfig();
        if (this.getOsgiContextModel().isWhiteboard()) {
            return new ReadOnlySessionCookieConfig(scc);
        }
        return scc;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.osgiContext.getJspConfigDescriptor();
    }

    public int getSessionTimeout() {
        return this.osgiContext.getSessionTimeout();
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.osgiContext.setSessionTimeout(sessionTimeout);
    }

    public String getRequestCharacterEncoding() {
        return this.osgiContext.getRequestCharacterEncoding();
    }

    public void setRequestCharacterEncoding(String encoding) {
        this.osgiContext.setRequestCharacterEncoding(encoding);
    }

    public String getResponseCharacterEncoding() {
        return this.osgiContext.getResponseCharacterEncoding();
    }

    public void setResponseCharacterEncoding(String encoding) {
        this.osgiContext.setResponseCharacterEncoding(encoding);
    }

    public String getMimeType(String file) {
        return this.osgiContext.getMimeType(this.webContainerContext, file);
    }

    public String getRealPath(String path) {
        return this.osgiContext.getRealPath(this.webContainerContext, path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.osgiContext.getResource(this.webContainerContext, path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.osgiContext.getResourceAsStream(this.webContainerContext, path);
    }

    public Set<String> getResourcePaths(String path) {
        return this.osgiContext.getResourcePaths(this.webContainerContext, path);
    }

    public String getInitParameter(String name) {
        return this.osgiContext.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.osgiContext.getInitParameterNames();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.osgiContext.getRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.osgiContext.getNamedDispatcher(name);
    }

    public String getServletContextName() {
        return this.osgiContext.getServletContextName();
    }

    public ClassLoader getClassLoader() {
        if (this.getOsgiContextModel().isWab()) {
            return this.getOsgiContextModel().getClassLoader();
        }
        return ((BundleWiring)this.bundle.adapt(BundleWiring.class)).getClassLoader();
    }

    private static class ReadOnlySessionCookieConfig
    implements SessionCookieConfig {
        private final SessionCookieConfig delegate;

        private ReadOnlySessionCookieConfig(SessionCookieConfig delegate) {
            this.delegate = delegate;
        }

        public Map<String, String> getAttributes() {
            return this.delegate.getAttributes();
        }

        public String getAttribute(String name) {
            return this.delegate.getAttribute(name);
        }

        public void setAttribute(String name, String value) {
            this.delegate.setAttribute(name, value);
        }

        public int getMaxAge() {
            return this.delegate.getMaxAge();
        }

        public void setMaxAge(int maxAge) {
            throw new IllegalStateException("Operation not supported");
        }

        public boolean isSecure() {
            return this.delegate.isSecure();
        }

        public void setSecure(boolean secure) {
            throw new IllegalStateException("Operation not supported");
        }

        public boolean isHttpOnly() {
            return this.delegate.isHttpOnly();
        }

        public void setHttpOnly(boolean httpOnly) {
            throw new IllegalStateException("Operation not supported");
        }

        public String getComment() {
            return this.delegate.getComment();
        }

        public void setComment(String comment) {
            throw new IllegalStateException("Operation not supported");
        }

        public String getPath() {
            return this.delegate.getPath();
        }

        public void setPath(String path) {
            throw new IllegalStateException("Operation not supported");
        }

        public String getDomain() {
            return this.delegate.getDomain();
        }

        public void setDomain(String domain) {
            throw new IllegalStateException("Operation not supported");
        }

        public String getName() {
            return this.delegate.getName();
        }

        public void setName(String name) {
            throw new IllegalStateException("Operation not supported");
        }
    }
}

