/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.function.Supplier;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerModel;
import org.ops4j.pax.web.service.spi.servlet.OsgiScopedServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class OsgiScopedListener
implements ServletContextListener {
    private final ServletContextListener listener;
    private final ServletContext context;

    public OsgiScopedListener(ServletContextListener listener, ServletContext context) {
        this.listener = listener;
        this.context = context;
    }

    public void contextInitialized(ServletContextEvent sce) {
        this.listener.contextInitialized(new ServletContextEvent(this.context));
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.listener.contextDestroyed(new ServletContextEvent(this.context));
    }

    public static EventListener proxyListener(OsgiServletContext context, Supplier<ServletContext> contextSupplier, EventListener listener, EventListenerModel eventListenerModel) {
        int implemented = 0;
        ArrayList interfaces = new ArrayList();
        for (Class<?> c : EventListenerModel.SUPPORTED_LISTENER_CLASSES) {
            if (!c.isAssignableFrom(listener.getClass())) continue;
            ++implemented;
            interfaces.add(c);
        }
        if (implemented == 0) {
            return listener;
        }
        if (ServletContextListener.class.isAssignableFrom(listener.getClass())) {
            Bundle bundle = eventListenerModel.getRegisteringBundle();
            if (bundle == null || bundle.getBundleContext() == null || bundle.adapt(BundleWiring.class) == null) {
                return listener;
            }
            OsgiScopedServletContext scopedContext = new OsgiScopedServletContext(context, bundle);
            scopedContext.setContextSupplier(contextSupplier);
            if (implemented == 1) {
                return new OsgiScopedListener((ServletContextListener)listener, scopedContext);
            }
            ClassLoader loader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
            return (EventListener)Proxy.newProxyInstance(loader, interfaces.toArray(new Class[0]), (InvocationHandler)new Handler(listener, scopedContext));
        }
        return listener;
    }

    public ServletContextListener getDelegate() {
        return this.listener;
    }

    public static class Handler
    implements InvocationHandler {
        private final EventListener listener;
        private final OsgiScopedServletContext scopedContext;

        public Handler(EventListener listener, OsgiScopedServletContext scopedContext) {
            this.listener = listener;
            this.scopedContext = scopedContext;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("contextInitialized".equals(method.getName()) || "contextDestroyed".equals(method.getName())) {
                return method.invoke(proxy, new ServletContextEvent((ServletContext)this.scopedContext));
            }
            return method.invoke(proxy, args);
        }

        public EventListener getDelegate() {
            return this.listener;
        }
    }
}

