/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.servlet.OsgiScopedServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiInitializedFilter
implements Filter {
    public static final Logger LOG = LoggerFactory.getLogger(OsgiInitializedFilter.class);
    private final Filter filter;
    private final FilterModel filterModel;
    private final ServletContext servletContext;
    private Pattern[] filterPatterns = null;
    private final boolean whiteboardTCCL;

    public OsgiInitializedFilter(Filter filter, FilterModel model, ServletContext servletSpecificContext, boolean whiteboardTCCL) {
        String[] regexPatterns;
        this.filter = filter;
        this.filterModel = model;
        this.servletContext = servletSpecificContext;
        this.whiteboardTCCL = whiteboardTCCL;
        if (model != null && model.getMappingsPerDispatcherTypes().size() == 1 && (regexPatterns = model.getMappingsPerDispatcherTypes().get(0).getRegexPatterns()) != null && regexPatterns.length > 0) {
            LOG.debug("Preparing RegEx based filter for {}", (Object)model);
            this.filterPatterns = new Pattern[regexPatterns.length];
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (String pattern : regexPatterns) {
                try {
                    patterns.add(Pattern.compile(pattern));
                }
                catch (PatternSyntaxException e) {
                    LOG.warn("Problem compiling filter RegEx pattern \"{}\". Skipping", (Object)pattern);
                }
            }
            if (patterns.size() > 0) {
                this.filterPatterns = patterns.toArray(new Pattern[0]);
            } else {
                LOG.warn("No RegEx pattern can be compiled. Filter will match all the requests");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(final FilterConfig config) throws ServletException {
        if (this.filter == null) {
            return;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader newCl = null;
            if (this.servletContext != null && (newCl = this.servletContext.getClassLoader()) == null) {
                BundleWiring wiring;
                Bundle bundle = null;
                if (this.filterModel != null) {
                    bundle = this.filterModel.getRegisteringBundle();
                }
                if (bundle == null && this.servletContext instanceof OsgiScopedServletContext) {
                    bundle = ((OsgiScopedServletContext)this.servletContext).getBundle();
                }
                BundleWiring bundleWiring = wiring = bundle == null ? null : (BundleWiring)bundle.adapt(BundleWiring.class);
                if (wiring != null) {
                    newCl = wiring.getClassLoader();
                }
            }
            if (newCl != null) {
                Thread.currentThread().setContextClassLoader(newCl);
            }
            this.filter.init(new FilterConfig(){

                public String getFilterName() {
                    return config.getFilterName();
                }

                public ServletContext getServletContext() {
                    return OsgiInitializedFilter.this.servletContext;
                }

                public String getInitParameter(String name) {
                    return config.getInitParameter(name);
                }

                public Enumeration<String> getInitParameterNames() {
                    return config.getInitParameterNames();
                }
            });
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block15: {
            ClassLoader tccl = null;
            try {
                if (this.whiteboardTCCL) {
                    tccl = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(request.getServletContext().getClassLoader());
                }
                if (this.filterPatterns != null) {
                    boolean match = false;
                    if (request instanceof HttpServletRequest) {
                        Object uri = ((HttpServletRequest)request).getRequestURI();
                        if (((HttpServletRequest)request).getQueryString() != null) {
                            uri = (String)uri + "?" + ((HttpServletRequest)request).getQueryString();
                        }
                        for (Pattern p : this.filterPatterns) {
                            if (!p.matcher((CharSequence)uri).matches()) continue;
                            match = true;
                            break;
                        }
                    } else {
                        match = true;
                    }
                    if (match) {
                        this.filter.doFilter(request, response, chain);
                    } else {
                        chain.doFilter(request, response);
                    }
                    break block15;
                }
                if (this.filter == null) {
                    chain.doFilter(request, response);
                } else {
                    this.filter.doFilter(request, response, chain);
                }
            }
            finally {
                if (this.whiteboardTCCL) {
                    Thread.currentThread().setContextClassLoader(tccl);
                }
            }
        }
    }

    public void destroy() {
        this.filter.destroy();
    }

    public Filter getDelegate() {
        return this.filter;
    }
}

