/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.servlet.DynamicRegistrations;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiDynamicServletContext
implements ServletContext {
    public static final Logger LOG = LoggerFactory.getLogger(OsgiDynamicServletContext.class);
    private final OsgiServletContext osgiContext;
    private final DynamicRegistrations registration;
    private final Set<String> attributesToClearBeforeRestart = new HashSet<String>();

    public OsgiDynamicServletContext(OsgiServletContext osgiContext, DynamicRegistrations registration) {
        this.osgiContext = osgiContext;
        this.registration = registration;
    }

    public void rememberAttributesFromSCIs() {
        this.osgiContext.getAttributesToClearBeforeRestart().addAll(this.attributesToClearBeforeRestart);
    }

    public OsgiContextModel getOsgiContextModel() {
        return this.osgiContext.getOsgiContextModel();
    }

    public ServletContext getContainerServletContext() {
        return this.osgiContext.getContainerServletContext();
    }

    public OsgiServletContext getOsgiContext() {
        return this.osgiContext;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return this.registration.addFilter(this.osgiContext, filterName, className);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return this.registration.addFilter(this.osgiContext, filterName, filter);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return this.registration.addFilter(this.osgiContext, filterName, filterClass);
    }

    public void addListener(String className) {
        this.registration.addListener(this.osgiContext, className);
    }

    public <T extends EventListener> void addListener(T t) {
        this.registration.addListener(this.osgiContext, t);
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        this.registration.addListener(this.osgiContext, listenerClass);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return this.registration.addServlet(this.osgiContext, servletName, className);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return this.registration.addServlet(this.osgiContext, servletName, servlet);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return this.registration.addServlet(this.osgiContext, servletName, servletClass);
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        try {
            return (T)((Filter)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            return (T)((EventListener)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        try {
            return (T)((Servlet)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    public void declareRoles(String ... roleNames) {
        throw new UnsupportedOperationException("declareRoles() is not supported.");
    }

    public boolean setInitParameter(String name, String value) {
        return this.osgiContext.getOsgiContextModel().getContextParams().putIfAbsent(name, value) == null;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        throw new UnsupportedOperationException("setSessionTrackingModes() is not supported.");
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        throw new UnsupportedOperationException("addJspFile() is not supported.");
    }

    public Object getAttribute(String name) {
        return this.osgiContext.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.osgiContext.getAttributeNames();
    }

    public void setAttribute(String name, Object object) {
        this.attributesToClearBeforeRestart.add(name);
        this.osgiContext.setAttribute(name, object);
    }

    public void removeAttribute(String name) {
        this.osgiContext.removeAttribute(name);
    }

    public String getContextPath() {
        return this.osgiContext.getContextPath();
    }

    public ServletContext getContext(String uripath) {
        return this.osgiContext.getContext(uripath);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.osgiContext.getDefaultSessionTrackingModes();
    }

    public int getEffectiveMajorVersion() {
        return this.osgiContext.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.osgiContext.getEffectiveMinorVersion();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.osgiContext.getEffectiveSessionTrackingModes();
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return this.osgiContext.getFilterRegistration(filterName);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.osgiContext.getFilterRegistrations();
    }

    public int getMajorVersion() {
        return this.osgiContext.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.osgiContext.getMinorVersion();
    }

    public ServletRegistration getServletRegistration(String servletName) {
        if (this.registration.getDynamicServletRegistrations().containsKey(servletName)) {
            return (ServletRegistration)this.registration.getDynamicServletRegistrations().get(servletName);
        }
        return this.osgiContext.getServletRegistration(servletName);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        HashMap<String, Object> regs = new HashMap<String, Object>();
        regs.putAll(this.osgiContext.getServletRegistrations());
        regs.putAll(this.registration.getDynamicServletRegistrations());
        return regs;
    }

    public String getVirtualServerName() {
        return this.osgiContext.getVirtualServerName();
    }

    public String getServerInfo() {
        return this.osgiContext.getServerInfo();
    }

    public void log(String msg) {
        this.osgiContext.log(msg);
    }

    public void log(String message, Throwable throwable) {
        this.osgiContext.log(message, throwable);
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.osgiContext.getSessionCookieConfig();
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.osgiContext.getJspConfigDescriptor();
    }

    public int getSessionTimeout() {
        return this.osgiContext.getSessionTimeout();
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.osgiContext.setSessionTimeout(sessionTimeout);
    }

    public String getRequestCharacterEncoding() {
        return this.osgiContext.getRequestCharacterEncoding();
    }

    public void setRequestCharacterEncoding(String encoding) {
        this.osgiContext.setRequestCharacterEncoding(encoding);
    }

    public String getResponseCharacterEncoding() {
        return this.osgiContext.getResponseCharacterEncoding();
    }

    public void setResponseCharacterEncoding(String encoding) {
        this.osgiContext.setResponseCharacterEncoding(encoding);
    }

    public String getMimeType(String file) {
        return this.osgiContext.getMimeType(file);
    }

    public String getRealPath(String path) {
        return this.osgiContext.getRealPath(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.osgiContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.osgiContext.getResourceAsStream(path);
    }

    public Set<String> getResourcePaths(String path) {
        return this.osgiContext.getResourcePaths(path);
    }

    public String getInitParameter(String name) {
        return this.osgiContext.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.osgiContext.getInitParameterNames();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.osgiContext.getRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.osgiContext.getNamedDispatcher(name);
    }

    public String getServletContextName() {
        return this.osgiContext.getServletContextName();
    }

    public ClassLoader getClassLoader() {
        return this.osgiContext.getClassLoader();
    }
}

