/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRegistration;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.ServletContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.model.views.DynamicJEEWebContainerView;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.ops4j.pax.web.service.spi.servlet.dynamic.DynamicEventListenerRegistration;
import org.ops4j.pax.web.service.spi.servlet.dynamic.DynamicFilterRegistration;
import org.ops4j.pax.web.service.spi.servlet.dynamic.DynamicServletRegistration;
import org.ops4j.pax.web.service.spi.task.Change;
import org.ops4j.pax.web.service.spi.task.EventListenerModelChange;
import org.ops4j.pax.web.service.spi.task.FilterModelChange;
import org.ops4j.pax.web.service.spi.task.OpCode;
import org.ops4j.pax.web.service.spi.task.ServletModelChange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class DynamicRegistrations {
    private final Map<String, DynamicServletRegistration> dynamicServletRegistrations = new HashMap<String, DynamicServletRegistration>();
    private final Map<String, DynamicFilterRegistration> dynamicFilterRegistrations = new HashMap<String, DynamicFilterRegistration>();
    private final Map<Integer, DynamicEventListenerRegistration> dynamicListenerRegistrations = new HashMap<Integer, DynamicEventListenerRegistration>();
    private final Map<EventListener, EventListenerModel> dynamicListenerModels = new IdentityHashMap<EventListener, EventListenerModel>();

    public Map<String, DynamicServletRegistration> getDynamicServletRegistrations() {
        return this.dynamicServletRegistrations;
    }

    public Collection<DynamicFilterRegistration> getDynamicFilterRegistrations() {
        return this.dynamicFilterRegistrations.values();
    }

    public Collection<DynamicEventListenerRegistration> getDynamicListenerRegistrations() {
        return this.dynamicListenerRegistrations.values();
    }

    public Map<EventListener, EventListenerModel> getDynamicListenerModels() {
        return this.dynamicListenerModels;
    }

    public FilterRegistration.Dynamic addFilter(OsgiServletContext context, String filterName, String className) {
        OsgiContextModel osgiContextModel = context.getOsgiContextModel();
        try {
            Class filterClass = osgiContextModel.getOwnerBundle().loadClass(className);
            FilterModel.Builder builder = new FilterModel.Builder().withFilterName(filterName).withFilterClass(filterClass).withOsgiContextModel(osgiContextModel);
            return this.register(context, new DynamicFilterRegistration(builder.build(), osgiContextModel, this));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Can't load filter class using bundle " + String.valueOf(osgiContextModel.getOwnerBundle()), e);
        }
    }

    public FilterRegistration.Dynamic addFilter(OsgiServletContext context, String filterName, Filter filter) {
        OsgiContextModel osgiContextModel = context.getOsgiContextModel();
        FilterModel.Builder builder = new FilterModel.Builder().withFilterName(filterName).withFilter(filter).withOsgiContextModel(osgiContextModel);
        return this.register(context, new DynamicFilterRegistration(builder.build(), osgiContextModel, this));
    }

    public FilterRegistration.Dynamic addFilter(OsgiServletContext context, String filterName, Class<? extends Filter> filterClass) {
        OsgiContextModel osgiContextModel = context.getOsgiContextModel();
        FilterModel.Builder builder = new FilterModel.Builder().withFilterName(filterName).withFilterClass(filterClass).withOsgiContextModel(osgiContextModel);
        return this.register(context, new DynamicFilterRegistration(builder.build(), osgiContextModel, this));
    }

    private FilterRegistration.Dynamic register(OsgiServletContext context, DynamicFilterRegistration reg) {
        ServletContextModel scModel = context.getServletContextModel();
        if (scModel.getFilterNameMapping().containsKey(reg.getName())) {
            return null;
        }
        FilterModel model = reg.getModel();
        model.setServiceRank(Integer.MAX_VALUE);
        model.setDynamic(true);
        this.configureBundle(context, model, reg.getModel().getActualClass());
        this.configureUnregistration(context.getOsgiContextModel(), new FilterModelChange(OpCode.DELETE, model, new OsgiContextModel[0]));
        this.dynamicFilterRegistrations.put(reg.getName(), reg);
        return reg;
    }

    public ServletRegistration.Dynamic addServlet(OsgiServletContext context, String servletName, String className) {
        OsgiContextModel osgiContextModel = context.getOsgiContextModel();
        try {
            Class servletClass = osgiContextModel.getOwnerBundle().loadClass(className);
            ServletModel.Builder builder = new ServletModel.Builder().withServletName(servletName).withServletClass(servletClass).withOsgiContextModel(osgiContextModel);
            return this.register(context, new DynamicServletRegistration(builder.build(), osgiContextModel, context.getServletContextModel(), this));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Can't load servlet class using bundle " + String.valueOf(osgiContextModel.getOwnerBundle()), e);
        }
    }

    public ServletRegistration.Dynamic addServlet(OsgiServletContext context, String servletName, Servlet servlet) {
        OsgiContextModel osgiContextModel = context.getOsgiContextModel();
        ServletModel.Builder builder = new ServletModel.Builder().withServletName(servletName).withServlet(servlet).withOsgiContextModel(osgiContextModel);
        return this.register(context, new DynamicServletRegistration(builder.build(), osgiContextModel, context.getServletContextModel(), this));
    }

    public ServletRegistration.Dynamic addServlet(OsgiServletContext context, String servletName, Class<? extends Servlet> servletClass) {
        OsgiContextModel osgiContextModel = context.getOsgiContextModel();
        ServletModel.Builder builder = new ServletModel.Builder().withServletName(servletName).withServletClass(servletClass).withOsgiContextModel(osgiContextModel);
        return this.register(context, new DynamicServletRegistration(builder.build(), osgiContextModel, context.getServletContextModel(), this));
    }

    private ServletRegistration.Dynamic register(OsgiServletContext context, DynamicServletRegistration reg) {
        ServletContextModel scModel = context.getServletContextModel();
        if (scModel.getServletNameMapping().containsKey(reg.getName())) {
            return null;
        }
        ServletModel model = reg.getModel();
        model.setServiceRank(Integer.MAX_VALUE);
        model.setDynamic(true);
        this.configureBundle(context, model, reg.getModel().getActualClass());
        this.configureUnregistration(context.getOsgiContextModel(), new ServletModelChange(OpCode.DELETE, model, new OsgiContextModel[0]));
        this.dynamicServletRegistrations.put(reg.getName(), reg);
        return reg;
    }

    public void addListener(OsgiServletContext context, String className) {
        OsgiContextModel osgiContextModel = context.getOsgiContextModel();
        try {
            Class filterClass = osgiContextModel.getOwnerBundle().loadClass(className);
            EventListenerModel model = new EventListenerModel((EventListener)filterClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            model.addContextModel(osgiContextModel);
            this.register(context, new DynamicEventListenerRegistration(model, osgiContextModel));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Can't load event listener class using bundle " + String.valueOf(osgiContextModel.getOwnerBundle()), e);
        }
    }

    public <T extends EventListener> void addListener(OsgiServletContext context, T t) {
        OsgiContextModel osgiContextModel = context.getOsgiContextModel();
        EventListenerModel model = new EventListenerModel(t);
        model.addContextModel(osgiContextModel);
        this.register(context, new DynamicEventListenerRegistration(model, osgiContextModel));
    }

    public void addListener(OsgiServletContext context, Class<? extends EventListener> listenerClass) {
        OsgiContextModel osgiContextModel = context.getOsgiContextModel();
        try {
            EventListenerModel model = new EventListenerModel(listenerClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            model.addContextModel(osgiContextModel);
            this.register(context, new DynamicEventListenerRegistration(model, osgiContextModel));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Can't instantiate event listener of class " + String.valueOf(listenerClass), e);
        }
    }

    private void register(OsgiServletContext context, DynamicEventListenerRegistration reg) {
        EventListenerModel model = reg.getModel();
        if (!context.acceptsServletContextListeners() && model.getEventListener() instanceof ServletContextListener) {
            String message = "Section 4.4.3 of the Servlets specification allows ServletContextListeners to be added only by ServletContainerInitializers, declared in web.xml or web-fragment.xml or by discovery of @WebListener annotated classes";
            throw new UnsupportedOperationException(message);
        }
        model.setServiceRank(0);
        model.setDynamic(true);
        this.configureBundle(context, model, reg.getModel().getEventListener().getClass());
        this.configureUnregistration(context.getOsgiContextModel(), new EventListenerModelChange(OpCode.DELETE, model, new OsgiContextModel[0]));
        this.dynamicListenerRegistrations.put(System.identityHashCode(model.getEventListener()), reg);
        this.dynamicListenerModels.put(model.getEventListener(), model);
    }

    private void configureBundle(OsgiServletContext context, ElementModel<?, ?> model, Class<?> aClass) {
        Bundle bundle = FrameworkUtil.getBundle(aClass);
        if (bundle == null || bundle.getBundleContext() == null) {
            bundle = context.getOsgiContextModel().getOwnerBundle();
        }
        model.setRegisteringBundle(bundle);
    }

    private void configureUnregistration(OsgiContextModel osgiContextModel, Change unregistration) {
        osgiContextModel.addUnregistrationChange(unregistration);
    }

    public DynamicJEEWebContainerView getContainer(OsgiContextModel osgiContextModel, Class<?> clazz) {
        Bundle bundle;
        Bundle bundle2 = bundle = clazz == null ? null : FrameworkUtil.getBundle(clazz);
        if (bundle == null) {
            bundle = osgiContextModel.getOwnerBundle();
        }
        if (bundle == null) {
            throw new IllegalStateException("Can't obtain WebContainer instance. Dynamic registration not possible.");
        }
        return this.getContainer(bundle);
    }

    public DynamicJEEWebContainerView getContainer(Bundle bundle) {
        if (bundle == null || bundle.getBundleContext() == null) {
            return null;
        }
        BundleContext bc = bundle.getBundleContext();
        ServiceReference ref = bc.getServiceReference(WebContainer.class);
        if (ref == null) {
            return null;
        }
        WebContainer container = (WebContainer)bc.getService(ref);
        if (container == null) {
            throw new IllegalStateException("Can't obtain WebContainer instance from " + String.valueOf(ref) + " reference. Dynamic registration not possible.");
        }
        return (DynamicJEEWebContainerView)container.adapt(DynamicJEEWebContainerView.class);
    }
}

