/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model.info;

import jakarta.servlet.Servlet;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ServletInfo
implements Comparable<ServletInfo> {
    private final String servletName;
    private String servletClass;
    private final String[] mapping;
    private final String[] contexts;
    private final String type;
    private final String contextFilter;
    private final boolean resourceServlet;
    private final String rawResourcePath;
    private final boolean jspServlet;
    private final Bundle bundle;
    private final String id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServletInfo(ServletModel model) {
        this.servletName = model.getName();
        this.mapping = model.getUrlPatterns();
        this.resourceServlet = model.isResourceServlet();
        this.jspServlet = model.isJspServlet();
        this.rawResourcePath = model.getRawPath();
        boolean hs = false;
        boolean whiteboard = false;
        boolean wab = false;
        for (OsgiContextModel ocm : model.getContextModels()) {
            hs |= !ocm.isWab() && !ocm.isWhiteboard();
            whiteboard |= ocm.isWhiteboard();
            wab |= ocm.isWab();
        }
        this.type = whiteboard ? "Whiteboard" : (wab ? "WAB" : "HttpService");
        this.contexts = (String[])model.getContextModels().stream().map(OsgiContextModel::getContextPath).distinct().toArray(String[]::new);
        this.contextFilter = model.getContextFilter() == null ? "-" : model.getContextFilter().toString();
        this.id = model.getId();
        this.bundle = model.getRegisteringBundle();
        String string = this.servletClass = model.getActualClass() == null ? "?" : model.getActualClass().getName();
        if (this.servletClass.equals(Servlet.class.getName()) && model.getElementReference() != null) {
            BundleContext ctx;
            BundleContext bundleContext = ctx = this.bundle == null ? null : this.bundle.getBundleContext();
            if (ctx != null) {
                try {
                    Servlet s = (Servlet)ctx.getService(model.getElementReference());
                    if (s != null) {
                        this.servletClass = s.getClass().getName();
                    }
                }
                finally {
                    try {
                        ctx.ungetService(model.getElementReference());
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
        }
    }

    public String getServletName() {
        return this.servletName;
    }

    public String getServletClass() {
        return this.servletClass;
    }

    public String[] getMapping() {
        return this.mapping;
    }

    public String[] getContexts() {
        return this.contexts;
    }

    public String getType() {
        return this.type;
    }

    public String getContextFilter() {
        return this.contextFilter;
    }

    public boolean isResourceServlet() {
        return this.resourceServlet;
    }

    public String getRawResourcePath() {
        return this.rawResourcePath;
    }

    public boolean isJspServlet() {
        return this.jspServlet;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public int compareTo(ServletInfo other) {
        if (!this.bundle.equals(other.bundle)) {
            return this.bundle.getBundleId() < other.bundle.getBundleId() ? -1 : 1;
        }
        if (!this.servletName.equals(other.servletName)) {
            return this.servletName.compareTo(other.servletName);
        }
        return this.id.compareTo(other.id);
    }
}

