/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model.events;

import java.util.Collection;
import org.ops4j.pax.web.service.http.HttpContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class WebApplicationEvent {
    private static Bundle extenderBundle;
    private static long extenderBundleId;
    private static String extenderBundleName;
    private static Version extenderBundleVersion;
    private final State type;
    private final Bundle bundle;
    private final long bundleId;
    private final String bundleName;
    private final Version bundleVersion;
    private final String contextPath;
    private final long timestamp;
    private final Throwable throwable;
    private final HttpContext context;
    private boolean awaitingAllocation = false;
    private Collection<Long> collisionIds;

    public WebApplicationEvent(State type, Bundle bundle, String contextPath, HttpContext context) {
        this(type, bundle, contextPath, context, null);
    }

    public WebApplicationEvent(State type, Bundle bundle, String contextPath, HttpContext context, Throwable throwable) {
        this.type = type;
        this.bundle = bundle;
        this.contextPath = contextPath;
        this.bundleId = bundle.getBundleId();
        this.bundleName = bundle.getSymbolicName();
        this.bundleVersion = bundle.getVersion() == null ? Version.emptyVersion : bundle.getVersion();
        this.timestamp = System.currentTimeMillis();
        this.throwable = throwable;
        this.context = context;
    }

    public static void setExtenderBundle(Bundle bundle) {
        extenderBundle = bundle;
        extenderBundleId = bundle.getBundleId();
        extenderBundleName = bundle.getSymbolicName();
        extenderBundleVersion = bundle.getVersion();
    }

    public String toString() {
        return String.format("%s (%s/%s)%s", new Object[]{this.type, this.bundleName, this.bundleVersion, this.throwable == null ? "" : ": " + this.throwable.getMessage()});
    }

    public State getType() {
        return this.type;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public Version getBundleVersion() {
        return this.bundleVersion;
    }

    public Bundle getExtenderBundle() {
        return extenderBundle;
    }

    public long getExtenderBundleId() {
        return extenderBundleId;
    }

    public String getExtenderBundleName() {
        return extenderBundleName;
    }

    public Version getExtenderBundleVersion() {
        return extenderBundleVersion;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Throwable getException() {
        return this.throwable;
    }

    public HttpContext getContext() {
        return this.context;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public boolean isAwaitingAllocation() {
        return this.awaitingAllocation;
    }

    public void setAwaitingAllocation(boolean awaitingAllocation) {
        this.awaitingAllocation = awaitingAllocation;
    }

    public Collection<Long> getCollisionIds() {
        return this.collisionIds;
    }

    public void setCollisionIds(Collection<Long> collisionIds) {
        this.collisionIds = collisionIds;
    }

    public static enum State {
        DEPLOYING("org/osgi/service/web/DEPLOYING"),
        DEPLOYED("org/osgi/service/web/DEPLOYED"),
        UNDEPLOYING("org/osgi/service/web/UNDEPLOYING"),
        UNDEPLOYED("org/osgi/service/web/UNDEPLOYED"),
        FAILED("org/osgi/service/web/FAILED"),
        WAITING("org/osgi/service/web/WAITING");

        private final String topic;

        private State(String topic) {
            this.topic = topic;
        }

        public String getTopic() {
            return this.topic;
        }
    }
}

