/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model.elements;

import jakarta.websocket.Decoder;
import jakarta.websocket.Encoder;
import jakarta.websocket.server.ServerEndpoint;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.ops4j.pax.web.service.spi.model.events.WebSocketEventData;
import org.ops4j.pax.web.service.spi.whiteboard.WhiteboardWebContainerView;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketModel
extends ElementModel<Object, WebSocketEventData> {
    public static final Logger LOG = LoggerFactory.getLogger(WebSocketModel.class);
    private final Object webSocketEndpoint;
    private final Class<?> webSocketEndpointClass;
    private Class<?> webSocketEndpointClassResolved;
    private String mappedPath;
    private Class<? extends Decoder>[] decoderClasses = new Class[0];
    private Class<? extends Encoder>[] encoderClasses = new Class[0];
    private String[] subprotocols = new String[0];

    public WebSocketModel() {
        this.webSocketEndpoint = null;
        this.webSocketEndpointClass = null;
    }

    public WebSocketModel(Object webSocketEndpoint, Class<?> webSocketEndpointClass) {
        this.webSocketEndpoint = webSocketEndpoint;
        this.webSocketEndpointClass = webSocketEndpointClass;
    }

    public Object getWebSocketEndpoint() {
        return this.webSocketEndpoint;
    }

    public Class<?> getWebSocketEndpointClass() {
        return this.webSocketEndpointClass;
    }

    public Class<?> getWebSocketEndpointClassResolved() {
        return this.webSocketEndpointClassResolved;
    }

    public String getMappedPath() {
        return this.mappedPath;
    }

    public Class<? extends Decoder>[] getDecoderClasses() {
        return this.decoderClasses;
    }

    public Class<? extends Encoder>[] getEncoderClasses() {
        return this.encoderClasses;
    }

    public String[] getSubprotocols() {
        return this.subprotocols;
    }

    @Override
    public void register(WhiteboardWebContainerView view) {
        view.registerWebSocket(this);
    }

    @Override
    public void unregister(WhiteboardWebContainerView view) {
        view.unregisterWebSocket(this);
    }

    @Override
    public WebSocketEventData asEventData() {
        WebSocketEventData data = new WebSocketEventData(this.webSocketEndpoint, this.webSocketEndpointClassResolved);
        this.setCommonEventProperties(data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean performValidation() {
        int sources = 0;
        sources += this.webSocketEndpoint != null ? 1 : 0;
        sources += this.webSocketEndpointClass != null ? 1 : 0;
        sources += this.getElementReference() != null ? 1 : 0;
        if ((sources += this.getElementSupplier() != null ? 1 : 0) == 0) {
            throw new IllegalArgumentException("WebSocket Model must specify one of: web socket instance, web socket class or service reference");
        }
        if (sources != 1) {
            throw new IllegalArgumentException("WebSocket Model should specify a web socket uniquely as instance, class or service reference");
        }
        Class<?> c = null;
        if (this.webSocketEndpoint != null) {
            c = this.webSocketEndpoint.getClass();
        } else if (this.webSocketEndpointClass != null) {
            c = this.webSocketEndpointClass;
        } else if (this.getElementSupplier() != null) {
            ws = this.getElementSupplier().get();
            if (ws == null) throw new IllegalArgumentException("Can't determine the Web Socket endpoint path. Element supplier returned null.");
            c = ws.getClass();
        } else if (this.getElementReference() != null) {
            ws = null;
            BundleContext context = this.getRegisteringBundle().getBundleContext();
            try {
                Object t = ws = context == null ? null : context.getService(this.getElementReference());
                if (ws == null) throw new IllegalArgumentException("Can't determine the Web Socket endpoint path. Service reference returned null.");
                c = ws.getClass();
            }
            finally {
                if (ws != null) {
                    context.ungetService(this.getElementReference());
                }
            }
        }
        if (c == null) {
            throw new IllegalArgumentException("Can't determine the Web Socket endpoint path.");
        }
        if (c.isAnnotationPresent(ServerEndpoint.class)) {
            ServerEndpoint endpoint = c.getAnnotation(ServerEndpoint.class);
            this.decoderClasses = endpoint.decoders();
            this.encoderClasses = endpoint.encoders();
            this.subprotocols = endpoint.subprotocols();
            if (endpoint.value() != null) {
                this.mappedPath = endpoint.value().trim();
                this.webSocketEndpointClassResolved = c;
                return Boolean.TRUE;
            }
        }
        LOG.warn("Can't determine the Web Socket endpoint path - is @ServerEndpoint annotation present?");
        return Boolean.FALSE;
    }

    @Override
    public String toString() {
        return "WebSocketModel{id=" + this.getId() + (String)(this.webSocketEndpoint == null ? "" : ",endpoint=" + String.valueOf(this.webSocketEndpoint)) + (String)(this.webSocketEndpointClassResolved == null ? "" : ",endpoint class=" + String.valueOf(this.webSocketEndpointClassResolved)) + ",contexts=" + this.getContextModelsInfo() + "}";
    }
}

