/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model.elements;

import java.util.Arrays;
import java.util.Map;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.model.events.JspEventData;
import org.ops4j.pax.web.service.spi.whiteboard.WhiteboardWebContainerView;
import org.ops4j.pax.web.service.whiteboard.JspMapping;

public class JspModel
extends ElementModel<JspMapping, JspEventData> {
    private final String[] mappings;
    private final String jspFile;
    private Map<String, String> initParams;
    private ServletModel servletModel;

    public JspModel(String[] mappings, String jspFile) {
        this.mappings = mappings;
        this.jspFile = jspFile;
    }

    public void setServletModel(ServletModel model) {
        this.servletModel = model;
    }

    public ServletModel getServletModel() {
        return this.servletModel;
    }

    @Override
    public void register(WhiteboardWebContainerView view) {
        view.registerJsp(this);
    }

    @Override
    public void unregister(WhiteboardWebContainerView view) {
        view.unregisterJsp(this);
    }

    @Override
    public JspEventData asEventData() {
        JspEventData data = new JspEventData(this.mappings, this.jspFile);
        this.setCommonEventProperties(data);
        return data;
    }

    public String[] getMappings() {
        return this.mappings;
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    public void setInitParams(Map<String, String> initParams) {
        this.initParams = initParams;
    }

    @Override
    public String toString() {
        return "JspModel{id=" + this.getId() + ",mappings=" + String.valueOf(Arrays.asList(this.mappings)) + ",jspFile=" + this.jspFile + "}";
    }

    @Override
    public Boolean performValidation() {
        return Boolean.TRUE;
    }
}

