/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model.elements;

import jakarta.servlet.AsyncListener;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpSessionActivationListener;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionBindingListener;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import java.util.Arrays;
import java.util.EventListener;
import java.util.LinkedHashSet;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.ops4j.pax.web.service.spi.model.events.EventListenerEventData;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.ops4j.pax.web.service.spi.whiteboard.WhiteboardWebContainerView;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;
import org.osgi.service.servlet.runtime.dto.FailedListenerDTO;
import org.osgi.service.servlet.runtime.dto.ListenerDTO;

public class EventListenerModel
extends ElementModel<EventListener, EventListenerEventData> {
    public static final Class<?>[] SUPPORTED_LISTENER_CLASSES = new Class[]{ServletContextListener.class, ServletContextAttributeListener.class, ServletRequestListener.class, ServletRequestAttributeListener.class, HttpSessionAttributeListener.class, HttpSessionIdListener.class, HttpSessionListener.class, HttpSessionActivationListener.class, HttpSessionBindingListener.class, AsyncListener.class, ReadListener.class, WriteListener.class};
    private EventListener eventListener;
    private EventListener resolvedListener;
    private boolean dynamic = false;
    private boolean notMatched;

    public EventListenerModel() {
    }

    public EventListenerModel(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Override
    public void register(WhiteboardWebContainerView view) {
        view.registerListener(this);
    }

    @Override
    public void unregister(WhiteboardWebContainerView view) {
        view.unregisterListener(this);
    }

    @Override
    public EventListenerEventData asEventData() {
        EventListenerEventData eventListenerEventData = new EventListenerEventData(this.eventListener);
        this.setCommonEventProperties(eventListenerEventData);
        return eventListenerEventData;
    }

    public EventListener getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventListener resolveEventListener() {
        if (this.resolvedListener != null) {
            if (!this.isPrototype()) {
                return this.resolvedListener;
            }
            this.getRegisteringBundle().getBundleContext().ungetService(this.getElementReference());
            this.resolvedListener = null;
        }
        EventListenerModel eventListenerModel = this;
        synchronized (eventListenerModel) {
            BundleContext context;
            if (this.resolvedListener != null) {
                return this.resolvedListener;
            }
            if (this.eventListener != null) {
                this.resolvedListener = this.eventListener;
            } else if (this.getElementSupplier() != null) {
                this.resolvedListener = (EventListener)this.getElementSupplier().get();
            }
            if (this.getElementReference() != null && (context = this.getRegisteringBundle().getBundleContext()) != null) {
                if (!this.isPrototype()) {
                    this.resolvedListener = (EventListener)context.getService(this.getElementReference());
                } else {
                    Bundle b = this.getRegisteringBundle();
                    ServiceObjects so = b.getBundleContext().getServiceObjects(this.getElementReference());
                    this.resolvedListener = (EventListener)so.getService();
                }
            }
            this.dtoFailureCode = this.resolvedListener == null ? 5 : -1;
            return this.resolvedListener;
        }
    }

    public void releaseEventListener() {
        BundleContext context;
        if (this.getElementReference() != null && (context = this.getRegisteringBundle().getBundleContext()) != null) {
            context.ungetService(this.getElementReference());
        }
        this.resolvedListener = null;
    }

    public EventListener getResolvedListener() {
        return this.resolvedListener;
    }

    @Override
    public Boolean performValidation() {
        if (this.dtoFailureCode != -1) {
            throw new IllegalArgumentException("Event Listener Model is registered with invalid properties");
        }
        int sources = this.eventListener != null ? 1 : 0;
        sources += this.getElementReference() != null ? 1 : 0;
        if ((sources += this.getElementSupplier() != null ? 1 : 0) == 0) {
            this.dtoFailureCode = 6;
            throw new IllegalArgumentException("Event Listener Model must specify one of: listener instance, listener supplier or listener reference");
        }
        if (sources != 1) {
            this.dtoFailureCode = 6;
            throw new IllegalArgumentException("Event Listener Model should specify a listener uniquely as instance, supplier or service reference");
        }
        this.dtoFailureCode = -1;
        return Boolean.TRUE;
    }

    public void setNotMatched() {
        this.notMatched = true;
    }

    public boolean isNotMatched() {
        return this.notMatched;
    }

    public ListenerDTO toDTO() {
        ListenerDTO dto = new ListenerDTO();
        dto.servletContextId = 0L;
        dto.serviceId = this.getServiceId();
        Class<?> c = null;
        if (this.eventListener != null) {
            c = this.eventListener.getClass();
        } else if (this.getElementSupplier() != null) {
            c = ((EventListener)this.getElementSupplier().get()).getClass();
        } else if (this.getElementReference() != null) {
            dto.types = Utils.getObjectClasses(this.getElementReference());
        }
        if (c != null) {
            LinkedHashSet interfaces = new LinkedHashSet();
            while (c != Object.class) {
                interfaces.addAll(Arrays.asList(c.getInterfaces()));
                c = c.getSuperclass();
            }
            dto.types = (String[])interfaces.stream().map(Class::getName).distinct().toArray(String[]::new);
        }
        return dto;
    }

    public FailedListenerDTO toFailedDTO(int dtoFailureCode) {
        FailedListenerDTO dto = new FailedListenerDTO();
        dto.servletContextId = 0L;
        dto.serviceId = this.getServiceId();
        Class<?> c = null;
        if (this.eventListener != null) {
            c = this.eventListener.getClass();
        } else if (this.getElementSupplier() != null) {
            c = ((EventListener)this.getElementSupplier().get()).getClass();
        } else if (this.getElementReference() != null) {
            dto.types = Utils.getObjectClasses(this.getElementReference());
        }
        if (c != null) {
            LinkedHashSet interfaces = new LinkedHashSet();
            while (c != Object.class) {
                interfaces.addAll(Arrays.asList(c.getInterfaces()));
                c = c.getSuperclass();
            }
            dto.types = (String[])interfaces.stream().map(Class::getName).distinct().toArray(String[]::new);
        }
        dto.failureReason = dtoFailureCode;
        return dto;
    }

    @Override
    public String toString() {
        return "EventListenerModel{id=" + this.getId() + (String)(this.eventListener != null ? ",listener='" + String.valueOf(this.eventListener) + "'" : "") + (String)(this.getElementSupplier() != null ? ",supplier='" + String.valueOf(this.getElementSupplier()) + "'" : "") + (String)(this.getElementReference() != null ? ",reference='" + String.valueOf(this.getElementReference()) + "'" : "") + ",contexts=" + this.getContextModelsInfo() + "}";
    }
}

