/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.model.events.ErrorPageEventData;
import org.ops4j.pax.web.service.spi.whiteboard.WhiteboardWebContainerView;
import org.ops4j.pax.web.service.whiteboard.ErrorPageMapping;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.servlet.runtime.dto.ErrorPageDTO;
import org.osgi.service.servlet.runtime.dto.FailedErrorPageDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorPageModel
extends ElementModel<ErrorPageMapping, ErrorPageEventData> {
    public static final Logger LOG = LoggerFactory.getLogger(ErrorPageModel.class);
    private static final Pattern ERROR_CODE = Pattern.compile("^\\d{3}$");
    private final String[] errorPages;
    private String location;
    private boolean xx4 = false;
    private boolean xx5 = false;
    private final List<Integer> errorCodes = new ArrayList<Integer>();
    private final List<String> exceptionClassNames = new ArrayList<String>();
    private String name;

    public ErrorPageModel(String[] errorPages) {
        this.errorPages = errorPages;
    }

    public ErrorPageModel(String[] errorPages, String location) {
        if (!location.startsWith("/")) {
            throw new IllegalArgumentException("Location must start with a slash (/)");
        }
        this.errorPages = errorPages;
        this.location = location;
    }

    @Override
    public void register(WhiteboardWebContainerView view) {
        view.registerErrorPages(this);
    }

    @Override
    public void unregister(WhiteboardWebContainerView view) {
        view.unregisterErrorPages(this);
    }

    @Override
    public ErrorPageEventData asEventData() {
        ErrorPageEventData data = new ErrorPageEventData(Arrays.copyOf(this.errorPages, this.errorPages.length), this.location);
        this.setCommonEventProperties(data);
        return data;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getErrorPages() {
        return this.errorPages;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public FailedErrorPageDTO toFailedDTO(ServletModel sm, int dtoFailureCode) {
        FailedErrorPageDTO dto = new FailedErrorPageDTO();
        if (sm != null) {
            dto.name = sm.getName();
            dto.asyncSupported = sm.getAsyncSupported() != null && sm.getAsyncSupported() != false;
            dto.initParams = new HashMap<String, String>(sm.getInitParams());
            dto.serviceId = sm.getServiceId();
        } else {
            dto.name = this.name;
            dto.asyncSupported = false;
            dto.initParams = new HashMap();
            dto.serviceId = this.getServiceId();
        }
        dto.servletContextId = 0L;
        dto.servletInfo = null;
        Set codes = this.errorCodes.stream().map(Integer::longValue).collect(Collectors.toCollection(TreeSet::new));
        for (String ep : this.errorPages) {
            int c;
            if ("4xx".equals(ep)) {
                for (c = 400; c <= 426; ++c) {
                    codes.add(Long.valueOf(c));
                }
            }
            if (!"5xx".equals(ep)) continue;
            for (c = 500; c <= 505; ++c) {
                codes.add(Long.valueOf(c));
            }
        }
        dto.errorCodes = codes.stream().mapToLong(Long::longValue).toArray();
        dto.exceptions = this.exceptionClassNames.toArray(new String[0]);
        dto.failureReason = dtoFailureCode;
        return dto;
    }

    public ErrorPageDTO toDTO(ServletModel sm) {
        ErrorPageDTO dto = new ErrorPageDTO();
        if (sm != null) {
            dto.name = sm.getName();
            dto.asyncSupported = sm.getAsyncSupported() != null && sm.getAsyncSupported() != false;
            dto.initParams = new HashMap<String, String>(sm.getInitParams());
            dto.serviceId = sm.getServiceId();
        } else {
            dto.name = this.getId();
            dto.asyncSupported = false;
            dto.initParams = new HashMap();
            dto.serviceId = this.getServiceId();
        }
        dto.servletContextId = 0L;
        dto.servletInfo = null;
        Set codes = this.errorCodes.stream().map(Integer::longValue).collect(Collectors.toCollection(TreeSet::new));
        for (String ep : this.errorPages) {
            int c;
            if ("4xx".equals(ep)) {
                for (c = 400; c <= 426; ++c) {
                    codes.add(Long.valueOf(c));
                }
            }
            if (!"5xx".equals(ep)) continue;
            for (c = 500; c <= 505; ++c) {
                codes.add(Long.valueOf(c));
            }
        }
        dto.errorCodes = codes.stream().mapToLong(Long::longValue).toArray();
        dto.exceptions = this.exceptionClassNames.toArray(new String[0]);
        return dto;
    }

    @Override
    public String toString() {
        return "ErrorPageModel{id=" + this.getId() + ",errorPages=" + String.valueOf(Arrays.asList(this.errorPages)) + ",location=" + this.location + "}";
    }

    @Override
    public Boolean performValidation() {
        for (String page : this.errorPages) {
            if ("4xx".equals(page)) {
                this.xx4 = true;
                continue;
            }
            if ("5xx".equals(page)) {
                this.xx5 = true;
                continue;
            }
            if (ERROR_CODE.matcher(page).matches()) {
                int code = Integer.parseInt(page);
                if (code < 400 || code > 599) {
                    this.dtoFailureCode = 6;
                    throw new IllegalArgumentException("HTTP error code should be between 400 and 599");
                }
                this.errorCodes.add(code);
                continue;
            }
            ClassLoader loader = null;
            try {
                ClassLoader classLoader = loader = this.getRegisteringBundle() == null ? null : ((BundleWiring)this.getRegisteringBundle().adapt(BundleWiring.class)).getClassLoader();
                if (loader == null) {
                    this.dtoFailureCode = 6;
                    throw new IllegalArgumentException("Can't verify class name of error page \"" + page + "\" - no bundle associated with error pages");
                }
                Class<?> exClass = loader.loadClass(page);
                if (!Throwable.class.isAssignableFrom(exClass)) {
                    this.dtoFailureCode = 6;
                    throw new IllegalArgumentException("Can't use \"" + page + "\" as error page - this class doesn't inherit from java.lang.Throwable");
                }
                this.exceptionClassNames.add(exClass.getName());
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Can't load \"" + page + "\" class using " + String.valueOf(loader) + ".This exception class will still be used for this error page, but may result in classloading problems later.");
                this.exceptionClassNames.add(page);
            }
        }
        this.dtoFailureCode = -1;
        return Boolean.TRUE;
    }

    public boolean isXx4() {
        return this.xx4;
    }

    public boolean isXx5() {
        return this.xx5;
    }

    public List<Integer> getErrorCodes() {
        return this.errorCodes;
    }

    public List<String> getExceptionClassNames() {
        return this.exceptionClassNames;
    }
}

