/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.ops4j.pax.web.service.spi.model.Identity;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.events.WebElementEventData;
import org.ops4j.pax.web.service.spi.whiteboard.WhiteboardWebContainerView;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;

public abstract class ElementModel<T, D extends WebElementEventData>
extends Identity
implements Comparable<ElementModel<T, D>> {
    protected List<OsgiContextModel> contextModels = new ArrayList<OsgiContextModel>();
    protected String contextModelsInfo;
    protected Boolean isValid;
    protected int dtoFailureCode = -1;
    private volatile boolean closed = false;
    private int serviceRank = 0;
    private long serviceId = 0L;
    private long timestamp = 0L;
    private ServiceReference<T> elementReference;
    private boolean prototype = false;
    private Supplier<? extends T> elementSupplier;
    private Bundle registeringBundle;
    private Filter contextFilter;
    private String contextSelector;
    private boolean async;

    public boolean isValid() {
        if (this.isValid == null) {
            try {
                this.isValid = this.performValidation();
            }
            catch (Exception ignored) {
                this.isValid = false;
            }
        }
        return this.isValid;
    }

    public abstract Boolean performValidation() throws Exception;

    public List<OsgiContextModel> getContextModels() {
        if (!this.closed) {
            Collections.sort(this.contextModels);
            this.contextModels = Collections.unmodifiableList(this.contextModels);
            this.contextModelsInfo = this.contextModels.stream().map(ocm -> String.format("{%s,%s,%s,%s}", ocm.isWhiteboard() ? "WB" : (ocm.isWab() ? "WAB" : "HS"), ocm.getId(), ocm.getName(), ocm.getContextPath())).collect(Collectors.joining(", ", "[", "]"));
            this.closed = true;
        }
        return this.contextModels;
    }

    public String getContextModelsInfo() {
        return this.contextModelsInfo;
    }

    public void addContextModel(OsgiContextModel model) {
        if (this.closed) {
            throw new IllegalStateException("Can't add new context models to " + String.valueOf(this));
        }
        this.contextModels.add(model);
    }

    public void changeContextModels(List<OsgiContextModel> models) {
        ArrayList<OsgiContextModel> newModels = new ArrayList<OsgiContextModel>(models);
        Collections.sort(newModels);
        this.contextModels = Collections.unmodifiableList(newModels);
        this.contextModelsInfo = this.contextModels.stream().map(ocm -> String.format("{%s,%s,%s,%s}", ocm.isWhiteboard() ? "WB" : (ocm.isWab() ? "WAB" : "HS"), ocm.getId(), ocm.getName(), ocm.getContextPath())).collect(Collectors.joining(", ", "[", "]"));
    }

    public void resetContextModels() {
        this.closed = false;
        this.contextModels = new ArrayList<OsgiContextModel>();
    }

    public abstract void register(WhiteboardWebContainerView var1);

    public abstract void unregister(WhiteboardWebContainerView var1);

    public abstract D asEventData();

    protected void setCommonEventProperties(WebElementEventData data) {
        data.setServiceRank(this.serviceRank);
        data.setServiceId(this.serviceId);
        data.setElementReference(this.elementReference);
        data.setOriginBundle(this.registeringBundle);
        this.contextModels.forEach(cm -> data.getContextNames().add(cm.getName()));
        if (this.contextModels.size() == 1 && this.contextModels.get(0).hasDirectHttpContextInstance()) {
            data.setHttpContext(this.contextModels.get(0).getDirectHttpContextInstance());
        }
    }

    public boolean hasContextModels() {
        return this.contextModels.size() > 0;
    }

    public int getServiceRank() {
        return this.serviceRank;
    }

    public void setServiceRank(int serviceRank) {
        this.serviceRank = serviceRank;
    }

    public long getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(long serviceId) {
        this.serviceId = serviceId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public ServiceReference<T> getElementReference() {
        return this.elementReference;
    }

    public void setElementReference(ServiceReference<T> elementReference) {
        this.elementReference = elementReference;
        if (elementReference != null) {
            this.prototype = "prototype".equals(elementReference.getProperty("service.scope"));
        }
    }

    public boolean isPrototype() {
        return this.prototype;
    }

    public Supplier<? extends T> getElementSupplier() {
        return this.elementSupplier;
    }

    public void setElementSupplier(Supplier<? extends T> elementSupplier) {
        this.elementSupplier = elementSupplier;
    }

    public Bundle getRegisteringBundle() {
        return this.registeringBundle;
    }

    public void setRegisteringBundle(Bundle registeringBundle) {
        this.registeringBundle = registeringBundle;
    }

    public void setContextSelector(String mappingSelector) {
        this.contextSelector = mappingSelector;
    }

    public String getContextSelector() {
        return this.contextSelector;
    }

    public void setContextSelectFilter(Filter contextFilter) {
        this.contextFilter = contextFilter;
    }

    public Filter getContextFilter() {
        return this.contextFilter;
    }

    public int getDtoFailureCode() {
        return this.dtoFailureCode;
    }

    public void setDtoFailureCode(int dtoFailureCode) {
        this.dtoFailureCode = dtoFailureCode;
        this.isValid = dtoFailureCode == -1;
    }

    public void setAsynchronusRegistration(boolean async) {
        this.async = async;
    }

    public boolean isAsynchronusRegistration() {
        return this.async;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{id=" + this.getId() + ",contexts=" + String.valueOf(this.contextModels) + "}";
    }

    @Override
    public int compareTo(ElementModel<T, D> o) {
        int c1 = Integer.compare(this.serviceRank, o.serviceRank);
        if (c1 != 0) {
            return -c1;
        }
        int c2 = Long.compare(this.serviceId, o.serviceId);
        if (c2 != 0) {
            return c2;
        }
        return Integer.compare(this.getNumericId(), o.getNumericId());
    }

    @Override
    public final boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    public void alterWithNewModel(ElementModel<T, D> webElement) {
    }
}

