/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model.elements;

import jakarta.servlet.ServletContainerInitializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.model.elements.WebSocketModel;
import org.ops4j.pax.web.service.spi.model.events.ContainerInitializerEventData;
import org.ops4j.pax.web.service.spi.whiteboard.WhiteboardWebContainerView;

public class ContainerInitializerModel
extends ElementModel<ServletContainerInitializer, ContainerInitializerEventData> {
    private final ServletContainerInitializer containerInitializer;
    private final Set<Class<?>> classes = new LinkedHashSet();
    private final List<ServletModel> relatedServletModels = new ArrayList<ServletModel>();
    private final List<WebSocketModel> relatedWebSocketModels = new ArrayList<WebSocketModel>();
    private boolean forJetty = false;
    private boolean forTomcat = false;
    private boolean forUndertow = false;
    private boolean forAnyRuntime = true;

    public ContainerInitializerModel(ServletContainerInitializer containerInitializer, Class<?>[] classes) {
        this.containerInitializer = containerInitializer;
        if (classes != null) {
            this.classes.addAll(Arrays.asList(classes));
        }
    }

    @Override
    protected String getIdPrefix() {
        return "CIM";
    }

    @Override
    public void register(WhiteboardWebContainerView view) {
    }

    @Override
    public void unregister(WhiteboardWebContainerView view) {
    }

    @Override
    public ContainerInitializerEventData asEventData() {
        ContainerInitializerEventData data = new ContainerInitializerEventData(this.containerInitializer);
        this.setCommonEventProperties(data);
        return data;
    }

    public ServletContainerInitializer getContainerInitializer() {
        return this.containerInitializer;
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    @Override
    public Boolean performValidation() {
        if (this.containerInitializer == null) {
            throw new IllegalArgumentException("No ServletContainerInitializer is specified");
        }
        return Boolean.TRUE;
    }

    public List<WebSocketModel> getRelatedWebSocketModels() {
        return this.relatedWebSocketModels;
    }

    public List<ServletModel> getRelatedServletModels() {
        return this.relatedServletModels;
    }

    public boolean isForJetty() {
        return this.forJetty;
    }

    public void setForJetty(boolean forJetty) {
        this.forJetty = forJetty;
        if (forJetty) {
            this.forAnyRuntime = false;
        }
    }

    public boolean isForTomcat() {
        return this.forTomcat;
    }

    public void setForTomcat(boolean forTomcat) {
        this.forTomcat = forTomcat;
        if (forTomcat) {
            this.forAnyRuntime = false;
        }
    }

    public boolean isForUndertow() {
        return this.forUndertow;
    }

    public void setForUndertow(boolean forUndertow) {
        this.forUndertow = forUndertow;
        if (forUndertow) {
            this.forAnyRuntime = false;
        }
    }

    public boolean isForAnyRuntime() {
        return this.forAnyRuntime;
    }

    public void setForAnyRuntime(boolean forAnyRuntime) {
        this.forAnyRuntime = forAnyRuntime;
    }

    @Override
    public String toString() {
        return "ContainerInitializerModel{id=" + this.getId() + (String)(this.containerInitializer == null ? "" : ",SCI=" + String.valueOf(this.containerInitializer)) + (!this.forJetty ? "" : ",Jetty only") + (!this.forTomcat ? "" : ",Tomcat only") + (!this.forUndertow ? "" : ",Undertow only") + ",contexts=" + this.getContextModelsInfo() + "}";
    }
}

