/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.ops4j.pax.web.service.MultiBundleWebContainerContext;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.context.DefaultHttpContext;
import org.ops4j.pax.web.service.spi.model.ContextKey;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.ops4j.pax.web.service.spi.model.elements.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.ops4j.pax.web.service.spi.model.elements.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.model.elements.WebSocketModel;
import org.ops4j.pax.web.service.spi.model.elements.WelcomeFileModel;
import org.ops4j.pax.web.service.spi.model.events.WebElementEvent;
import org.ops4j.pax.web.service.spi.model.events.WebElementEventData;
import org.ops4j.pax.web.service.spi.model.events.WebElementEventListener;
import org.ops4j.pax.web.service.spi.task.Batch;
import org.ops4j.pax.web.service.spi.task.BatchVisitor;
import org.ops4j.pax.web.service.spi.task.ClearDynamicRegistrationsChange;
import org.ops4j.pax.web.service.spi.task.ContainerInitializerModelChange;
import org.ops4j.pax.web.service.spi.task.ErrorPageModelChange;
import org.ops4j.pax.web.service.spi.task.ErrorPageStateChange;
import org.ops4j.pax.web.service.spi.task.EventListenerModelChange;
import org.ops4j.pax.web.service.spi.task.FilterModelChange;
import org.ops4j.pax.web.service.spi.task.FilterStateChange;
import org.ops4j.pax.web.service.spi.task.OpCode;
import org.ops4j.pax.web.service.spi.task.OsgiContextModelChange;
import org.ops4j.pax.web.service.spi.task.ServletContextModelChange;
import org.ops4j.pax.web.service.spi.task.ServletModelChange;
import org.ops4j.pax.web.service.spi.task.WebSocketModelChange;
import org.ops4j.pax.web.service.spi.task.WelcomeFileModelChange;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceModel
implements BatchVisitor {
    public static final Logger LOG = LoggerFactory.getLogger(ServiceModel.class);
    private final ServerModel serverModel;
    private final ServerController serverController;
    private final Bundle serviceBundle;
    private final Map<String, Map<String, ServletModel>> aliasMapping = new HashMap<String, Map<String, ServletModel>>();
    private final Set<ServletModel> servletModels = new HashSet<ServletModel>();
    private final Set<FilterModel> filterModels = new HashSet<FilterModel>();
    private final Set<EventListenerModel> eventListenerModels = new HashSet<EventListenerModel>();
    private final Set<ContainerInitializerModel> containerInitializerModels = new HashSet<ContainerInitializerModel>();
    private final Map<ContextKey, Set<String>> welcomeFiles = new LinkedHashMap<ContextKey, Set<String>>();
    private final Set<WelcomeFileModel> welcomeFileModels = new HashSet<WelcomeFileModel>();
    private final Set<ErrorPageModel> errorPageModels = new HashSet<ErrorPageModel>();
    private final Set<WebSocketModel> webSocketModels = new HashSet<WebSocketModel>();
    private final WebElementEventListener eventDispatcher;

    public ServiceModel(ServerModel serverModel, ServerController serverController, Bundle serviceBundle, WebElementEventListener eventDispatcher) {
        this.serverModel = serverModel;
        this.serviceBundle = serviceBundle;
        this.serverController = serverController;
        this.eventDispatcher = eventDispatcher;
    }

    public WebContainerContext getOrCreateDefaultHttpContext(String contextId) {
        return this.serverModel.runSilently(() -> {
            OsgiContextModel ctx = this.serverModel.getContextModel(contextId, this.serviceBundle);
            if (ctx == null) {
                ctx = this.createDefaultHttpContext(contextId);
            }
            return ctx.getDirectHttpContextInstance();
        }, false);
    }

    public OsgiContextModel createDefaultHttpContext(String contextId) {
        return this.serverModel.runSilently(() -> {
            Batch batch = new Batch("Initialization of HttpContext \"" + contextId + "\" for " + String.valueOf(this.serviceBundle));
            DefaultHttpContext wcc = new DefaultHttpContext(this.serviceBundle, contextId);
            OsgiContextModel model = this.serverModel.getOrCreateOsgiContextModel(wcc, this.serviceBundle, "/", batch);
            batch.accept(this);
            this.serverController.sendBatch(batch);
            return model;
        }, false);
    }

    public MultiBundleWebContainerContext getOrCreateDefaultSharedHttpContext(String contextId) {
        return this.serverModel.runSilently(() -> {
            OsgiContextModel ctx = this.serverModel.getSharedContextModel(contextId);
            if (ctx == null) {
                ctx = this.serverModel.createDefaultSharedtHttpContext(contextId, this.serverController);
            }
            return (MultiBundleWebContainerContext)ctx.getDirectHttpContextInstance();
        }, false);
    }

    public Map<String, Map<String, ServletModel>> getAliasMapping() {
        return this.aliasMapping;
    }

    public Set<ServletModel> getServletModels() {
        return this.servletModels;
    }

    public Set<FilterModel> getFilterModels() {
        return this.filterModels;
    }

    public Set<EventListenerModel> getEventListenerModels() {
        return this.eventListenerModels;
    }

    public Set<WelcomeFileModel> getWelcomeFileModels() {
        return this.welcomeFileModels;
    }

    public Set<ErrorPageModel> getErrorPageModels() {
        return this.errorPageModels;
    }

    public Set<ContainerInitializerModel> getContainerInitializerModels() {
        return this.containerInitializerModels;
    }

    public Set<WebSocketModel> getWebSocketModels() {
        return this.webSocketModels;
    }

    @Override
    public void visitServletContextModelChange(ServletContextModelChange change) {
        this.serverModel.visitServletContextModelChange(change);
    }

    @Override
    public void visitOsgiContextModelChange(OsgiContextModelChange change) {
        switch (change.getKind()) {
            case ASSOCIATE: {
                this.serverModel.associateHttpContext(change.getContext(), change.getOsgiContextModel());
                break;
            }
            case DISASSOCIATE: {
                this.serverModel.disassociateHttpContext(change.getContext(), change.getOsgiContextModel());
                break;
            }
            case ADD: 
            case DELETE: {
                this.serverModel.visitOsgiContextModelChange(change);
                break;
            }
        }
    }

    @Override
    public void visitServletModelChange(ServletModelChange change) {
        if (change.isDynamic()) {
            return;
        }
        if (change.getKind() == OpCode.ADD) {
            ServletModel model = change.getServletModel();
            if (change.getNewModels().size() > 0) {
                model.changeContextModels(change.getNewModels());
            }
            if (model.getAlias() != null) {
                Map contexts = this.aliasMapping.computeIfAbsent(model.getAlias(), alias -> new HashMap());
                for (OsgiContextModel context : change.getServletModel().getContextModels()) {
                    String contextPath = context.getContextPath();
                    contexts.put(contextPath, model);
                }
            }
            this.servletModels.add(model);
            if (model.getErrorPageModel() != null && model.getErrorPageModel().isValid()) {
                this.errorPageModels.add(model.getErrorPageModel());
            }
            this.serverModel.visitServletModelChange(change);
            return;
        }
        if (change.getKind() == OpCode.DELETE) {
            Set<ServletModel> modelsToRemove = change.getServletModels().keySet();
            for (ServletModel model : modelsToRemove) {
                if (model.getAlias() != null) {
                    this.aliasMapping.remove(model.getAlias());
                }
                this.servletModels.remove(model);
                if (model.getErrorPageModel() == null) continue;
                this.errorPageModels.remove(model.getErrorPageModel());
            }
            this.serverModel.visitServletModelChange(change);
            return;
        }
        if (change.getKind() == OpCode.ENABLE || change.getKind() == OpCode.DISABLE) {
            this.serverModel.visitServletModelChange(change);
        }
    }

    @Override
    public void visitFilterModelChange(FilterModelChange change) {
        if (change.isDynamic()) {
            return;
        }
        if (change.getKind() == OpCode.ADD) {
            FilterModel model = change.getFilterModel();
            if (change.getNewModels().size() > 0) {
                model.changeContextModels(change.getNewModels());
            }
            this.filterModels.add(model);
            this.serverModel.visitFilterModelChange(change);
            return;
        }
        if (change.getKind() == OpCode.DELETE) {
            List<FilterModel> modelsToRemove = change.getFilterModels();
            for (FilterModel model : modelsToRemove) {
                this.filterModels.remove(model);
            }
            this.serverModel.visitFilterModelChange(change);
            return;
        }
        if (change.getKind() == OpCode.ENABLE || change.getKind() == OpCode.DISABLE) {
            this.serverModel.visitFilterModelChange(change);
        }
    }

    @Override
    public void visitFilterStateChange(FilterStateChange change) {
    }

    @Override
    public void visitEventListenerModelChange(EventListenerModelChange change) {
        if (change.isDynamic()) {
            return;
        }
        if (change.getKind() == OpCode.ADD) {
            EventListenerModel model = change.getEventListenerModel();
            if (change.getNewModels().size() > 0) {
                model.changeContextModels(change.getNewModels());
            }
            this.eventListenerModels.add(model);
        } else if (change.getKind() == OpCode.DELETE) {
            change.getEventListenerModels().forEach(this.eventListenerModels::remove);
        }
        this.serverModel.visitEventListenerModelChange(change);
    }

    @Override
    public void visitContainerInitializerModelChange(ContainerInitializerModelChange change) {
        if (change.getKind() == OpCode.ADD) {
            ContainerInitializerModel model = change.getContainerInitializerModel();
            if (change.getNewModels().size() > 0) {
                model.changeContextModels(change.getNewModels());
            }
            this.containerInitializerModels.add(model);
        } else if (change.getKind() == OpCode.DELETE) {
            change.getContainerInitializerModels().forEach(this.containerInitializerModels::remove);
        }
        this.serverModel.visitContainerInitializerModelChange(change);
    }

    @Override
    public void visitWelcomeFileModelChange(WelcomeFileModelChange change) {
        WelcomeFileModel model = change.getWelcomeFileModel();
        if (change.getKind() == OpCode.ADD) {
            if (change.getNewModels().size() > 0) {
                model.changeContextModels(change.getNewModels());
            }
            this.welcomeFileModels.add(model);
        } else if (change.getKind() == OpCode.DELETE) {
            this.welcomeFileModels.remove(model);
        }
        for (OsgiContextModel context : model.getContextModels()) {
            ContextKey key = ContextKey.of(context);
            Set welcomes = this.welcomeFiles.computeIfAbsent(key, k -> new LinkedHashSet());
            if (change.getKind() == OpCode.ADD) {
                welcomes.addAll(Arrays.asList(model.getWelcomeFiles()));
                continue;
            }
            if (change.getKind() != OpCode.DELETE) continue;
            Arrays.asList(model.getWelcomeFiles()).forEach(welcomes::remove);
            if (!welcomes.isEmpty()) continue;
            this.welcomeFiles.remove(key);
        }
        this.serverModel.visitWelcomeFileModelChange(change);
    }

    @Override
    public void visitErrorPageModelChange(ErrorPageModelChange change) {
        if (change.getKind() == OpCode.ADD) {
            ErrorPageModel model = change.getErrorPageModel();
            if (change.getNewModels().size() > 0) {
                model.changeContextModels(change.getNewModels());
            }
            this.errorPageModels.add(model);
        }
        if (change.getKind() == OpCode.DELETE) {
            for (ErrorPageModel model : change.getErrorPageModels()) {
                this.errorPageModels.remove(model);
            }
        }
        this.serverModel.visitErrorPageModelChange(change);
    }

    @Override
    public void visitErrorPageStateChange(ErrorPageStateChange change) {
    }

    @Override
    public void visitWebSocketModelChange(WebSocketModelChange change) {
        if (change.getKind() == OpCode.ADD) {
            WebSocketModel model = change.getWebSocketModel();
            if (change.getNewModels().size() > 0) {
                model.changeContextModels(change.getNewModels());
            }
            this.webSocketModels.add(model);
            this.serverModel.visitWebSocketModelChange(change);
            return;
        }
        if (change.getKind() == OpCode.DELETE) {
            Set<WebSocketModel> modelsToRemove = change.getWebSocketModels().keySet();
            for (WebSocketModel model : modelsToRemove) {
                this.webSocketModels.remove(model);
            }
            this.serverModel.visitWebSocketModelChange(change);
            return;
        }
        if (change.getKind() == OpCode.ENABLE || change.getKind() == OpCode.DISABLE) {
            this.serverModel.visitWebSocketModelChange(change);
        }
    }

    @Override
    public void visitClearDynamicRegistrationsChange(ClearDynamicRegistrationsChange change) {
        Iterator<ServletModel> iterator = this.servletModels.iterator();
        while (iterator.hasNext()) {
            ServletModel model = iterator.next();
            if (!model.isDynamic()) continue;
            if (model.getAlias() != null && this.aliasMapping.containsKey(model.getAlias())) {
                for (OsgiContextModel ocm : model.getContextModels()) {
                    this.aliasMapping.get(model.getAlias()).remove(ocm.getContextPath(), model);
                }
                if (this.aliasMapping.get(model.getAlias()).isEmpty()) {
                    this.aliasMapping.remove(model.getAlias());
                }
            }
            if (model.getErrorPageModel() != null && model.getErrorPageModel().isValid()) {
                this.errorPageModels.remove(model.getErrorPageModel());
            }
            iterator.remove();
        }
        this.filterModels.removeIf(FilterModel::isDynamic);
        this.eventListenerModels.removeIf(EventListenerModel::isDynamic);
        this.serverModel.visitClearDynamicRegistrationsChange(change);
    }

    public void reRegisterWebElementsIfNeeded(OsgiContextModel oldContext, OsgiContextModel newContext, Batch batch) {
        OsgiContextModel target = newContext;
        if (target == null) {
            if (oldContext.isShared()) {
                target = this.serverModel.getSharedContextModel(oldContext.getName(), oldContext);
                if (target == null) {
                    target = this.serverModel.getSharedDefaultContextModel(oldContext.getName());
                }
            } else {
                target = this.serverModel.getBundleContextModel(oldContext.getDirectHttpContextInstance(), oldContext);
                if (target == null) {
                    target = this.serverModel.getBundleDefaultContextModel(ContextKey.of(oldContext));
                }
            }
        }
        if (target == null) {
            if (oldContext.isShared()) {
                context = this.getOrCreateDefaultSharedHttpContext(oldContext.getName());
                target = this.serverModel.getSharedContextModel(context.getContextId());
            } else {
                context = this.getOrCreateDefaultHttpContext(oldContext.getName());
                target = this.serverModel.getBundleContextModel((WebContainerContext)context);
            }
        }
        boolean force = newContext == null;
        LOG.info("Re-registering web elements from {} to {}", (Object)oldContext, (Object)target);
        for (ContainerInitializerModel containerInitializerModel : this.containerInitializerModels) {
            if (!this.needsReRegistration(containerInitializerModel, oldContext, target, force)) continue;
            this.event(WebElementEvent.State.UNDEPLOYING, containerInitializerModel);
            batch.removeContainerInitializerModels(Collections.singletonList(containerInitializerModel));
            batch.addContainerInitializerModel(containerInitializerModel, target);
        }
        for (EventListenerModel eventListenerModel : this.eventListenerModels) {
            if (!this.needsReRegistration(eventListenerModel, oldContext, target, force)) continue;
            this.event(WebElementEvent.State.UNDEPLOYING, eventListenerModel);
            batch.removeEventListenerModels(Collections.singletonList(eventListenerModel));
            batch.addEventListenerModel(eventListenerModel, target);
        }
        for (ServletModel servletModel : this.servletModels) {
            if (!this.needsReRegistration(servletModel, oldContext, target, force)) continue;
            LinkedHashMap<ServletModel, Boolean> modelsAndStates = new LinkedHashMap<ServletModel, Boolean>();
            modelsAndStates.put(servletModel, !this.serverModel.getDisabledServletModels().contains(servletModel));
            this.event(WebElementEvent.State.UNDEPLOYING, servletModel);
            batch.removeServletModels(modelsAndStates);
            batch.addServletModel(servletModel, target);
        }
        for (WelcomeFileModel welcomeFileModel : this.welcomeFileModels) {
            if (!this.needsReRegistration(welcomeFileModel, oldContext, target, force)) continue;
            this.event(WebElementEvent.State.UNDEPLOYING, welcomeFileModel);
            batch.removeWelcomeFileModel(welcomeFileModel);
            batch.addWelcomeFileModel(welcomeFileModel, target);
        }
        TreeSet<ErrorPageModel> affectedErrorPageModels = new TreeSet<ErrorPageModel>();
        for (ErrorPageModel epm : this.errorPageModels) {
            if (!this.needsReRegistration(epm, oldContext, target, force)) continue;
            this.event(WebElementEvent.State.UNDEPLOYING, epm);
            batch.removeErrorPageModels(Collections.singletonList(epm));
            batch.addErrorPageModel(epm, target);
            affectedErrorPageModels.add(epm);
        }
        if (affectedErrorPageModels.size() > 0) {
            HashMap<String, TreeMap<ErrorPageModel, List<OsgiContextModel>>> hashMap = new HashMap<String, TreeMap<ErrorPageModel, List<OsgiContextModel>>>();
            String path1 = oldContext.getContextPath();
            String path2 = target.getContextPath();
            HashMap<String, TreeMap<ErrorPageModel, List<OsgiContextModel>>> currentlyEnabledByPath = new HashMap<String, TreeMap<ErrorPageModel, List<OsgiContextModel>>>();
            this.serverModel.prepareErrorPageSnapshot(currentlyEnabledByPath, new TreeSet<ErrorPageModel>(), null, new HashSet<ErrorPageModel>());
            if (!path1.equals(path2)) {
                Map epModels2;
                TreeMap<ErrorPageModel, Object> p1 = new TreeMap<ErrorPageModel, Object>();
                TreeMap<ErrorPageModel, List<OsgiContextModel>> p2 = new TreeMap<ErrorPageModel, List<OsgiContextModel>>();
                Map epModels1 = (Map)currentlyEnabledByPath.get(path1);
                if (epModels1 != null && epModels1.size() > 0) {
                    for (Object fm : epModels1.keySet()) {
                        if (!affectedErrorPageModels.contains(fm)) {
                            p1.put((ErrorPageModel)fm, null);
                            continue;
                        }
                        p2.put((ErrorPageModel)fm, Collections.singletonList(target));
                    }
                    if (!p2.isEmpty()) {
                        hashMap.put(path1, p1);
                    }
                }
                if ((epModels2 = (Map)currentlyEnabledByPath.get(path2)) != null) {
                    p2.putAll(epModels2);
                }
                hashMap.put(path2, p2);
            }
            batch.updateErrorPages(hashMap);
        }
        TreeSet<FilterModel> treeSet = new TreeSet<FilterModel>();
        for (FilterModel fm : this.filterModels) {
            if (!this.needsReRegistration(fm, oldContext, target, force)) continue;
            this.event(WebElementEvent.State.UNDEPLOYING, fm);
            batch.removeFilterModels(Collections.singletonList(fm));
            batch.addFilterModel(fm, target);
            treeSet.add(fm);
        }
        if (treeSet.size() > 0) {
            HashMap<String, TreeMap<FilterModel, List<OsgiContextModel>>> state = new HashMap<String, TreeMap<FilterModel, List<OsgiContextModel>>>();
            String path1 = oldContext.getContextPath();
            String path2 = target.getContextPath();
            HashMap<String, TreeMap<FilterModel, List<OsgiContextModel>>> currentlyEnabledByPath = new HashMap<String, TreeMap<FilterModel, List<OsgiContextModel>>>();
            this.serverModel.prepareFiltersSnapshot(currentlyEnabledByPath, new TreeSet<FilterModel>(), null, new HashSet<FilterModel>());
            if (!path1.equals(path2)) {
                Map filterModels2;
                TreeMap<FilterModel, Object> p1 = new TreeMap<FilterModel, Object>();
                TreeMap<FilterModel, List<OsgiContextModel>> p2 = new TreeMap<FilterModel, List<OsgiContextModel>>();
                Map filterModels1 = (Map)currentlyEnabledByPath.get(path1);
                if (filterModels1 != null && filterModels1.size() > 0) {
                    for (FilterModel fm : filterModels1.keySet()) {
                        if (!treeSet.contains(fm)) {
                            p1.put(fm, null);
                            continue;
                        }
                        p2.put(fm, Collections.singletonList(target));
                    }
                    if (!p2.isEmpty()) {
                        state.put(path1, p1);
                    }
                }
                if ((filterModels2 = (Map)currentlyEnabledByPath.get(path2)) != null) {
                    p2.putAll(filterModels2);
                }
                state.put(path2, p2);
            } else {
                TreeMap<Object, List<OsgiContextModel>> newState = new TreeMap<Object, List<OsgiContextModel>>();
                Map filterModels1 = (Map)currentlyEnabledByPath.get(path1);
                if (filterModels1 != null && filterModels1.size() > 0) {
                    for (Object fm : filterModels1.keySet()) {
                        if (!treeSet.contains(fm)) {
                            newState.put(fm, null);
                            continue;
                        }
                        newState.put(fm, Collections.singletonList(target));
                    }
                }
                state.put(path1, newState);
            }
            batch.updateFilters(state, false);
        }
    }

    private boolean needsReRegistration(ElementModel<?, ?> model, OsgiContextModel oldContext, OsgiContextModel newContext, boolean force) {
        if (model.getContextModels().size() != 1) {
            return false;
        }
        OsgiContextModel currentContext = model.getContextModels().get(0);
        return currentContext == oldContext && (force || !oldContext.isWhiteboard() || newContext.compareTo(oldContext) < 0);
    }

    private void event(WebElementEvent.State type, ElementModel<?, ?> model) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.registrationEvent(new WebElementEvent(type, (WebElementEventData)model.asEventData()));
        }
    }
}

