/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.http.NamespaceException;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.config.JspConfiguration;
import org.ops4j.pax.web.service.spi.context.DefaultMultiBundleWebContainerContext;
import org.ops4j.pax.web.service.spi.context.WebContainerContextWrapper;
import org.ops4j.pax.web.service.spi.model.ContextKey;
import org.ops4j.pax.web.service.spi.model.ModelRegistrationException;
import org.ops4j.pax.web.service.spi.model.ModelRegistrationTask;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.ServiceModel;
import org.ops4j.pax.web.service.spi.model.ServletContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.ops4j.pax.web.service.spi.model.elements.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.model.elements.SecurityConfigurationModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.model.elements.WebSocketModel;
import org.ops4j.pax.web.service.spi.model.elements.WelcomeFileModel;
import org.ops4j.pax.web.service.spi.model.events.WebContextEventListener;
import org.ops4j.pax.web.service.spi.model.events.WebElementEventData;
import org.ops4j.pax.web.service.spi.model.info.ServletInfo;
import org.ops4j.pax.web.service.spi.model.info.WebApplicationInfo;
import org.ops4j.pax.web.service.spi.model.views.ReportViewPlugin;
import org.ops4j.pax.web.service.spi.task.Batch;
import org.ops4j.pax.web.service.spi.task.BatchVisitor;
import org.ops4j.pax.web.service.spi.task.ClearDynamicRegistrationsChange;
import org.ops4j.pax.web.service.spi.task.ContainerInitializerModelChange;
import org.ops4j.pax.web.service.spi.task.ContextStartChange;
import org.ops4j.pax.web.service.spi.task.ContextStopChange;
import org.ops4j.pax.web.service.spi.task.ErrorPageModelChange;
import org.ops4j.pax.web.service.spi.task.ErrorPageStateChange;
import org.ops4j.pax.web.service.spi.task.EventListenerModelChange;
import org.ops4j.pax.web.service.spi.task.FilterModelChange;
import org.ops4j.pax.web.service.spi.task.FilterStateChange;
import org.ops4j.pax.web.service.spi.task.OpCode;
import org.ops4j.pax.web.service.spi.task.OsgiContextModelChange;
import org.ops4j.pax.web.service.spi.task.SecurityConfigChange;
import org.ops4j.pax.web.service.spi.task.ServletContextModelChange;
import org.ops4j.pax.web.service.spi.task.ServletModelChange;
import org.ops4j.pax.web.service.spi.task.WebSocketModelChange;
import org.ops4j.pax.web.service.spi.task.WelcomeFileModelChange;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.osgi.dto.DTO;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.servlet.runtime.HttpServiceRuntime;
import org.osgi.service.servlet.runtime.dto.ErrorPageDTO;
import org.osgi.service.servlet.runtime.dto.FailedErrorPageDTO;
import org.osgi.service.servlet.runtime.dto.FailedFilterDTO;
import org.osgi.service.servlet.runtime.dto.FailedListenerDTO;
import org.osgi.service.servlet.runtime.dto.FailedPreprocessorDTO;
import org.osgi.service.servlet.runtime.dto.FailedResourceDTO;
import org.osgi.service.servlet.runtime.dto.FailedServletContextDTO;
import org.osgi.service.servlet.runtime.dto.FailedServletDTO;
import org.osgi.service.servlet.runtime.dto.FilterDTO;
import org.osgi.service.servlet.runtime.dto.ListenerDTO;
import org.osgi.service.servlet.runtime.dto.PreprocessorDTO;
import org.osgi.service.servlet.runtime.dto.RequestInfoDTO;
import org.osgi.service.servlet.runtime.dto.ResourceDTO;
import org.osgi.service.servlet.runtime.dto.RuntimeDTO;
import org.osgi.service.servlet.runtime.dto.ServletContextDTO;
import org.osgi.service.servlet.runtime.dto.ServletDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerModel
implements BatchVisitor,
HttpServiceRuntime,
ReportViewPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ServerModel.class);
    private static final String DEFAULT_VIRTUAL_HOST = "default";
    private final Executor executor;
    private final long registrationThreadId;
    private final Map<String, ServletContextModel> servletContexts = new HashMap<String, ServletContextModel>();
    private final Map<ContextKey, TreeSet<OsgiContextModel>> bundleContexts = new ConcurrentHashMap<ContextKey, TreeSet<OsgiContextModel>>();
    private final Map<ContextKey, OsgiContextModel> bundleDefaultContexts = new HashMap<ContextKey, OsgiContextModel>();
    private final Map<String, OsgiContextModel> bundleWabAllocatedContexts = new HashMap<String, OsgiContextModel>();
    private final Map<String, TreeSet<OsgiContextModel>> sharedContexts = new HashMap<String, TreeSet<OsgiContextModel>>();
    private final Map<String, OsgiContextModel> sharedDefaultContexts = new HashMap<String, OsgiContextModel>();
    private final Map<String, TreeSet<OsgiContextModel>> whiteboardContexts = new HashMap<String, TreeSet<OsgiContextModel>>();
    private final Map<Servlet, ServletModel> servlets = new IdentityHashMap<Servlet, ServletModel>();
    private final Set<ServletModel> servletsForDTO = new HashSet<ServletModel>();
    private final Set<ServletModel> disabledServletModels = new TreeSet<ServletModel>();
    private final Map<jakarta.servlet.Filter, FilterModel> filters = new IdentityHashMap<jakarta.servlet.Filter, FilterModel>();
    private final Set<FilterModel> filtersForDTO = new HashSet<FilterModel>();
    private final Set<FilterModel> disabledFilterModels = new TreeSet<FilterModel>();
    private final Set<ErrorPageModel> disabledErrorPageModels = new TreeSet<ErrorPageModel>();
    private final Map<EventListener, EventListenerModel> eventListeners = new IdentityHashMap<EventListener, EventListenerModel>();
    private final Set<EventListenerModel> eventListenersForDTO = new HashSet<EventListenerModel>();
    private final Map<ServletContainerInitializer, ContainerInitializerModel> containerInitializers = new IdentityHashMap<ServletContainerInitializer, ContainerInitializerModel>();
    private final Map<Object, WebSocketModel> webSockets = new IdentityHashMap<Object, WebSocketModel>();
    private final Set<WebSocketModel> disabledWebSocketModels = new TreeSet<WebSocketModel>();
    private final Set<ElementModel<?, ?>> failedWhiteboardElements = new HashSet();
    private BundleContext context;
    private WebContextEventListener wabOsgiContextListener;
    private ServiceReferenceDTO httpServiceRuntimeDTO;
    private ServiceRegistration<HttpServiceRuntime> httpServiceRuntimeReg;
    private final AtomicLong changeCount = new AtomicLong(0L);
    private final List<ReportViewPlugin> plugins = new CopyOnWriteArrayList<ReportViewPlugin>();
    private final AtomicBoolean stopping = new AtomicBoolean(false);

    public ServerModel(Executor executor) {
        this(executor, ServerModel.getThreadIdFromSingleThreadPool(executor));
    }

    public ServerModel(Executor executor, long threadId) {
        this.executor = executor;
        this.registrationThreadId = threadId;
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        this.context = bundle == null ? null : bundle.getBundleContext();
    }

    public static long getThreadIdFromSingleThreadPool(Executor executor) {
        try {
            return CompletableFuture.supplyAsync(() -> Thread.currentThread().getId(), executor).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause().getMessage(), e.getCause());
        }
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public OsgiContextModel createDefaultSharedtHttpContext(String contextId, ServerController controller) {
        return this.runSilently(() -> {
            Batch batch = new Batch("Initialization of shared HttpContext \"" + contextId + "\"");
            Object wcc = OsgiContextModel.DEFAULT_CONTEXT_MODEL.getContextSupplier().apply(null, contextId);
            wcc = new DefaultMultiBundleWebContainerContext((WebContainerContextWrapper)wcc);
            OsgiContextModel model = this.getOrCreateOsgiContextModel((WebContainerContext)wcc, null, "/", batch);
            batch.accept(this);
            controller.sendBatch(batch);
            return model;
        }, false);
    }

    public <T> T run(ModelRegistrationTask<T> task, boolean asynchronous) throws ServletException, NamespaceException {
        this.incrementChangeCounter();
        if (!asynchronous && Thread.currentThread().getId() == this.registrationThreadId) {
            return task.run();
        }
        Throwable originalTrace = new Throwable();
        try {
            try {
                CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> {
                    try {
                        return task.run();
                    }
                    catch (ServletException e) {
                        throw new ModelRegistrationException(e);
                    }
                    catch (NamespaceException e) {
                        throw new ModelRegistrationException(e);
                    }
                }, this.executor);
                if (asynchronous) {
                    return null;
                }
                return (T)future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof ModelRegistrationException)) {
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e.getCause();
                    }
                    throw new RuntimeException(e.getCause().getMessage(), e.getCause());
                }
                ((ModelRegistrationException)e.getCause()).throwTheCause();
            }
        }
        catch (RejectedExecutionException e) {
            return null;
        }
        catch (RuntimeException e) {
            e.addSuppressed(originalTrace);
            throw e;
        }
        return null;
    }

    public <T> void runAsync(ModelRegistrationTask<T> task) {
        this.incrementChangeCounter();
        if (Thread.currentThread().getId() == this.registrationThreadId) {
            // empty if block
        }
        Throwable originalTrace = new Throwable();
        try {
            CompletableFuture.supplyAsync(() -> {
                try {
                    return task.run();
                }
                catch (ServletException e) {
                    throw new ModelRegistrationException(e);
                }
                catch (NamespaceException e) {
                    throw new ModelRegistrationException(e);
                }
            }, this.executor);
        }
        catch (RuntimeException e) {
            e.addSuppressed(originalTrace);
            throw e;
        }
    }

    public void setStopping() {
        this.stopping.set(true);
    }

    private void incrementChangeCounter() {
        if (this.stopping.get()) {
            return;
        }
        this.changeCount.incrementAndGet();
        try {
            if (this.httpServiceRuntimeReg == null || this.httpServiceRuntimeReg.getReference() == null) {
                return;
            }
            String[] props = this.httpServiceRuntimeReg.getReference().getPropertyKeys();
            Hashtable<String, Object> newProps = new Hashtable<String, Object>();
            for (String key : props) {
                ((Dictionary)newProps).put(key, this.httpServiceRuntimeReg.getReference().getProperty(key));
            }
            ((Dictionary)newProps).put("service.changecount", this.changeCount.get());
            this.httpServiceRuntimeReg.setProperties(newProps);
        }
        catch (IllegalStateException e) {
            LOG.debug("Problem incrementing the change counter: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOG.warn("Problem incrementing the change counter: {}", (Object)e.getMessage());
        }
    }

    public <T> T runSilently(ModelRegistrationTask<T> task, boolean asynchronous) {
        try {
            return this.run(task, asynchronous);
        }
        catch (Exception e) {
            if (asynchronous) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public ServletContextModel getOrCreateServletContextModel(String contextPath, Batch batch) {
        ServletContextModel existing = this.servletContexts.get(contextPath);
        if (existing != null) {
            return existing;
        }
        ServletContextModel servletContextModel = new ServletContextModel(contextPath);
        batch.addServletContextModel(servletContextModel);
        LOG.info("Created new {}", (Object)servletContextModel);
        return servletContextModel;
    }

    public OsgiContextModel getOrCreateOsgiContextModel(WebContainerContext context, Bundle serviceBundle, String contextPath, Batch batch) throws IllegalStateException {
        OsgiContextModel existing = this.verifyExistingAssociation(context, serviceBundle);
        if (existing != null) {
            return existing;
        }
        ServletContextModel servletContextModel = this.getOrCreateServletContextModel(contextPath, batch);
        OsgiContextModel osgiContextModel = this.createNewContextModel(context, serviceBundle, contextPath);
        batch.addOsgiContextModel(osgiContextModel, servletContextModel);
        batch.associateOsgiContextModel(context, osgiContextModel);
        return osgiContextModel;
    }

    public void registerOsgiContextModelIfNeeded(OsgiContextModel contextModel, ServiceModel serviceModel, Batch batch) {
        ServletContextModel scm = this.getOrCreateServletContextModel(contextModel.getContextPath(), batch);
        batch.addOsgiContextModel(contextModel, scm);
        if (contextModel.hasDirectHttpContextInstance()) {
            batch.associateOsgiContextModel(contextModel.getDirectHttpContextInstance(), contextModel);
            ContextKey key = ContextKey.of(contextModel);
            TreeSet<OsgiContextModel> models = contextModel.isShared() ? this.sharedContexts.get(key.contextId) : this.bundleContexts.get(key);
            if (models == null && !contextModel.isShared()) {
                OsgiContextModel model = null;
                block0: for (Map.Entry<ContextKey, TreeSet<OsgiContextModel>> entry : this.bundleContexts.entrySet()) {
                    ContextKey ck = entry.getKey();
                    TreeSet<OsgiContextModel> ocms = entry.getValue();
                    if (ck.bundle != contextModel.getOwnerBundle()) continue;
                    for (OsgiContextModel ocm : ocms) {
                        if (!ocm.hasDirectHttpContextInstance() || !ocm.getDirectHttpContextInstance().equals(contextModel.getDirectHttpContextInstance())) continue;
                        model = ocm;
                        continue block0;
                    }
                }
                if (model != null) {
                    models = new TreeSet<Object>(Collections.singletonList(model));
                }
            }
            if (models != null) {
                for (OsgiContextModel m : models) {
                    if (!m.hasDirectHttpContextInstance() || !contextModel.getDirectHttpContextInstance().equals(m.getDirectHttpContextInstance())) continue;
                    serviceModel.reRegisterWebElementsIfNeeded(m, contextModel, batch);
                }
            }
        } else {
            this.whiteboardContexts.computeIfAbsent(contextModel.getName(), n -> new TreeSet()).add(contextModel);
        }
    }

    public void unregisterOsgiContextModel(OsgiContextModel contextModel, ServiceModel serviceModel, Batch batch) {
        if (contextModel.hasDirectHttpContextInstance()) {
            batch.disassociateOsgiContextModel(contextModel.getDirectHttpContextInstance(), contextModel);
            ContextKey key = ContextKey.of(contextModel);
            TreeSet<OsgiContextModel> models = contextModel.isShared() ? this.sharedContexts.get(key.contextId) : this.bundleContexts.get(key);
            if (models != null) {
                for (OsgiContextModel m : models) {
                    if (m != contextModel || !m.hasDirectHttpContextInstance()) continue;
                    serviceModel.reRegisterWebElementsIfNeeded(m, null, batch);
                }
            }
        } else {
            TreeSet<OsgiContextModel> models = this.whiteboardContexts.get(contextModel.getName());
            if (models != null) {
                models.remove(contextModel);
                if (models.isEmpty()) {
                    this.whiteboardContexts.remove(contextModel.getName());
                }
            }
        }
        batch.removeOsgiContextModel(contextModel);
        SecurityConfigurationModel scm = contextModel.getSecurityConfiguration();
        if (!(scm == null || scm.getLoginConfig() == null && scm.getSecurityConstraints().isEmpty() && scm.getSecurityRoles().isEmpty())) {
            batch.getOperations().add(0, new ContextStopChange(OpCode.MODIFY, contextModel));
            batch.getOperations().add(new SecurityConfigChange(OpCode.DELETE, contextModel, scm.getLoginConfig(), scm.getSecurityConstraints(), new ArrayList<String>(scm.getSecurityRoles())));
            batch.getOperations().add(new ContextStartChange(OpCode.MODIFY, contextModel));
        }
    }

    public OsgiContextModel verifyExistingAssociation(WebContainerContext context, Bundle bundle) throws IllegalStateException {
        OsgiContextModel contextModel;
        OsgiContextModel osgiContextModel = contextModel = context.isShared() ? Utils.getHighestRankedModel((Set<OsgiContextModel>)this.sharedContexts.get(context.getContextId())) : Utils.getHighestRankedModel((Set<OsgiContextModel>)this.bundleContexts.get(ContextKey.of(context)));
        if (contextModel == null && !context.isShared()) {
            WebContainerContext ctx = context instanceof WebContainerContextWrapper ? ((WebContainerContextWrapper)context).getHttpContext() : context;
            for (ContextKey ck : this.bundleContexts.keySet()) {
                if (ck.httpContext != ctx) continue;
                contextModel = Utils.getHighestRankedModel((Set<OsgiContextModel>)this.bundleContexts.get(ck));
            }
        }
        if (contextModel == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.valueOf(context) + " is not yet associated with any context model");
            }
            return null;
        }
        if (!context.isShared()) {
            if (!contextModel.hasDirectHttpContextInstance()) {
                throw new IllegalStateException("Existing " + String.valueOf(contextModel) + " doesn't have any HttpContext associated");
            }
            if (!bundle.equals(contextModel.getOwnerBundle())) {
                if (contextModel.getOwnerBundle() != null) {
                    throw new IllegalStateException("Existing " + String.valueOf(contextModel) + " is not shared and can't be used by bundle " + String.valueOf(bundle));
                }
                throw new IllegalStateException("Existing " + String.valueOf(contextModel) + " is shared, but registration is perfomed using non-shared " + String.valueOf(context));
            }
        }
        if (context.isShared() && !contextModel.isWhiteboard() && contextModel.getOwnerBundle() != null) {
            throw new IllegalStateException("Existing " + String.valueOf(contextModel) + " is owned by " + String.valueOf(contextModel.getOwnerBundle()) + ", but registration is perfomed using shared " + String.valueOf(context));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.valueOf(context) + " can be associated with " + String.valueOf(contextModel) + " in the scope of " + String.valueOf(bundle));
        }
        return contextModel;
    }

    public OsgiContextModel createNewContextModel(WebContainerContext webContext, Bundle serviceBundle, String contextPath) {
        OsgiContextModel osgiContextModel = new OsgiContextModel(webContext, serviceBundle, contextPath, false);
        osgiContextModel.setName(webContext.getContextId());
        osgiContextModel.setShared(serviceBundle == null);
        osgiContextModel.getContextParams().clear();
        osgiContextModel.getVirtualHosts().clear();
        osgiContextModel.getConnectors().clear();
        Hashtable<String, Object> registration = osgiContextModel.getContextRegistrationProperties();
        registration.clear();
        registration.remove("osgi.http.whiteboard.context.name");
        registration.put("osgi.http.whiteboard.context.httpservice", webContext.getContextId());
        registration.put("httpContext.id", webContext.getContextId());
        registration.put("osgi.http.whiteboard.context.path", contextPath);
        registration.put("httpContext.path", contextPath);
        registration.put("service.ranking", Integer.MAX_VALUE);
        osgiContextModel.setServiceRank(Integer.MAX_VALUE);
        registration.put("service.id", 0L);
        osgiContextModel.setServiceId(0L);
        LOG.trace("Created new {}", (Object)osgiContextModel);
        return osgiContextModel;
    }

    public void associateHttpContext(WebContainerContext context, OsgiContextModel osgiContextModel) {
        if (context.isShared()) {
            if (this.sharedContexts.computeIfAbsent(context.getContextId(), c -> new TreeSet()).add(osgiContextModel)) {
                LOG.debug("Configured shared context {} -> {}", (Object)context, (Object)osgiContextModel);
                if (osgiContextModel.isWhiteboard() || osgiContextModel.isWab()) {
                    TreeSet<OsgiContextModel> models = this.sharedContexts.get(context.getContextId());
                    Iterator<OsgiContextModel> it = models.iterator();
                    while (it.hasNext()) {
                        OsgiContextModel model = it.next();
                        if (model.isWhiteboard() || model.isWab() || !osgiContextModel.hasDirectHttpContextInstance() || !model.hasDirectHttpContextInstance() || !model.getDirectHttpContextInstance().equals(osgiContextModel.getDirectHttpContextInstance())) continue;
                        this.sharedDefaultContexts.put(context.getContextId(), model);
                        it.remove();
                    }
                }
            }
        } else {
            ContextKey key = ContextKey.of(context);
            if (this.bundleContexts.computeIfAbsent(key, c -> new TreeSet()).add(osgiContextModel)) {
                LOG.debug("Created association {} -> {}", (Object)context, (Object)osgiContextModel);
                if (osgiContextModel.isWhiteboard() || osgiContextModel.isWab()) {
                    TreeSet<OsgiContextModel> models = this.bundleContexts.get(key);
                    Iterator<OsgiContextModel> it = models.iterator();
                    while (it.hasNext()) {
                        OsgiContextModel model = it.next();
                        if (model.isWhiteboard() || model.isWab() || !osgiContextModel.hasDirectHttpContextInstance() || !model.hasDirectHttpContextInstance() || !model.getDirectHttpContextInstance().equals(osgiContextModel.getDirectHttpContextInstance())) continue;
                        this.bundleDefaultContexts.put(key, model);
                        it.remove();
                    }
                }
                if (this.wabOsgiContextListener != null && osgiContextModel.isWab()) {
                    this.executor.execute(() -> this.wabOsgiContextListener.wabContextRegistered(osgiContextModel));
                }
            }
        }
    }

    public void disassociateHttpContext(WebContainerContext context, OsgiContextModel osgiContextModel) {
        if (context.isShared()) {
            String key = context.getContextId();
            TreeSet<OsgiContextModel> models = this.sharedContexts.get(key);
            models.remove(osgiContextModel);
            if (models.isEmpty()) {
                OsgiContextModel defaultSharedOsgiContextModel = this.sharedDefaultContexts.remove(key);
                if (defaultSharedOsgiContextModel != null) {
                    models.add(defaultSharedOsgiContextModel);
                } else {
                    this.sharedContexts.remove(key);
                }
            }
            LOG.debug("Removed shared context {} -> {}", (Object)context, (Object)osgiContextModel);
        } else {
            ContextKey key = ContextKey.of(context);
            TreeSet<OsgiContextModel> models = this.bundleContexts.get(key);
            models.remove(osgiContextModel);
            if (models.isEmpty()) {
                OsgiContextModel defaultBundleOsgiContextModel = this.bundleDefaultContexts.remove(key);
                if (defaultBundleOsgiContextModel != null) {
                    models.add(defaultBundleOsgiContextModel);
                } else {
                    this.bundleContexts.remove(key);
                }
            }
            if (this.wabOsgiContextListener != null && osgiContextModel.isWab()) {
                this.wabOsgiContextListener.wabContextUnregistered(osgiContextModel);
            }
            LOG.debug("Removed association {} -> {}", (Object)context, (Object)osgiContextModel);
        }
    }

    public OsgiContextModel getContextModel(String name, Bundle ownerBundle) {
        OsgiContextModel model;
        if (ownerBundle == null) {
            TreeSet<OsgiContextModel> models;
            model = Utils.getHighestRankedModel((Set<OsgiContextModel>)this.sharedContexts.get(name));
            if (model == null && !(models = this.whiteboardContexts.get(name)).isEmpty()) {
                model = models.first();
            }
        } else {
            model = Utils.getHighestRankedModel((Set<OsgiContextModel>)this.bundleContexts.get(ContextKey.with(name, ownerBundle)));
        }
        return model;
    }

    public OsgiContextModel getBundleContextModel(WebContainerContext context) {
        return Utils.getHighestRankedModel((Set<OsgiContextModel>)this.bundleContexts.get(ContextKey.of(context)));
    }

    public OsgiContextModel getBundleContextModel(WebContainerContext context, OsgiContextModel skip) {
        TreeSet<OsgiContextModel> set = this.bundleContexts.get(ContextKey.of(context));
        if (set != null) {
            for (OsgiContextModel model : set) {
                if (model.equals(skip)) continue;
                return model;
            }
        }
        return null;
    }

    public OsgiContextModel getBundleDefaultContextModel(ContextKey key) {
        return this.bundleDefaultContexts.get(key);
    }

    public OsgiContextModel getSharedContextModel(String name) {
        return Utils.getHighestRankedModel((Set<OsgiContextModel>)this.sharedContexts.get(name));
    }

    public OsgiContextModel getSharedContextModel(String name, OsgiContextModel skip) {
        TreeSet<OsgiContextModel> set = this.sharedContexts.get(name);
        if (set != null) {
            for (OsgiContextModel model : set) {
                if (model.equals(skip)) continue;
                return model;
            }
        }
        return null;
    }

    public OsgiContextModel getSharedDefaultContextModel(String name) {
        return this.sharedDefaultContexts.get(name);
    }

    public List<OsgiContextModel> getOsgiContextModels(Bundle bundle) {
        LinkedList<OsgiContextModel> contexts = new LinkedList<OsgiContextModel>();
        this.bundleContexts.forEach((context, set) -> {
            if (bundle.equals(context.bundle)) {
                contexts.add(Utils.getHighestRankedModel(set));
            }
        });
        contexts.addAll(this.sharedContexts.values().stream().map(Utils::getHighestRankedModel).collect(Collectors.toSet()));
        contexts.addAll(this.bundleWabAllocatedContexts.values());
        return contexts;
    }

    public List<OsgiContextModel> getAllBundleOsgiContextModels(Bundle bundle) {
        LinkedList<OsgiContextModel> contexts = new LinkedList<OsgiContextModel>();
        this.bundleContexts.forEach((context, set) -> {
            if (bundle.equals(context.bundle)) {
                contexts.addAll((Collection<OsgiContextModel>)set);
            }
        });
        return contexts;
    }

    public void deassociateContexts(Bundle bundle, ServerController controller) {
        this.runSilently(() -> {
            Batch batch = new Batch("Deassociation of contexts for " + String.valueOf(bundle));
            this.bundleContexts.forEach((context, set) -> {
                if (bundle.equals(context.bundle)) {
                    set.forEach(ocm -> {
                        if (!ocm.isWhiteboard()) {
                            batch.disassociateOsgiContextModel(ocm.getDirectHttpContextInstance(), (OsgiContextModel)ocm);
                            batch.removeOsgiContextModel((OsgiContextModel)ocm);
                        }
                    });
                }
            });
            if (batch.getOperations().size() > 0) {
                controller.sendBatch(batch);
                batch.accept(this);
            }
            return null;
        }, false);
    }

    private Set<ServletContextModel> getServletContextModels(ElementModel<?, ?> model) {
        return model.getContextModels().stream().map(ocm -> this.servletContexts.get(ocm.getContextPath())).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public OsgiContextModel getWabContext(String contextPath, Bundle wab, boolean create) {
        if (!create) {
            return this.bundleWabAllocatedContexts.get(contextPath);
        }
        OsgiContextModel ocm = this.bundleWabAllocatedContexts.get(contextPath);
        if (ocm != null) {
            return ocm.getOwnerBundle().equals(wab) ? ocm : null;
        }
        ocm = new OsgiContextModel(null, wab, contextPath, false);
        ocm.setWab(true);
        ocm.setName(contextPath);
        this.bundleWabAllocatedContexts.put(contextPath, ocm);
        if (!this.servletContexts.containsKey(contextPath)) {
            this.servletContexts.put(contextPath, new ServletContextModel(contextPath));
        }
        return ocm;
    }

    public void releaseWabContext(String contextPath, Bundle wab) {
        this.bundleWabAllocatedContexts.entrySet().removeIf(e -> contextPath.equals(e.getKey()) && ((OsgiContextModel)e.getValue()).getOwnerBundle().equals(wab));
    }

    public ServletContextModel getServletContextModel(String contextPath) {
        return this.servletContexts.get(contextPath);
    }

    public void registerWabOsgiContextListener(WebContextEventListener listener) {
        this.wabOsgiContextListener = listener;
    }

    public void addServletModel(ServletModel model, Batch batch) throws NamespaceException, ServletException {
        if (model.getContextModels().isEmpty()) {
            throw new IllegalArgumentException("Can't register " + String.valueOf(model) + ", it is not associated with any context");
        }
        if (model.getServlet() != null && this.servlets.containsKey(model.getServlet())) {
            throw new ServletException("Can't register servlet " + String.valueOf(model.getServlet()) + ", it has already been registered using " + String.valueOf(this.servlets.get(model.getServlet())));
        }
        Set<ServletContextModel> targetServletContexts = this.getServletContextModels(model);
        HashMap<ServletContextModel, ServletModel> contextsWithNameConflicts = new HashMap<ServletContextModel, ServletModel>();
        for (ServletContextModel sc : targetServletContexts) {
            if (!sc.getServletNameMapping().containsKey(model.getName())) continue;
            contextsWithNameConflicts.put(sc, sc.getServletNameMapping().get(model.getName()));
        }
        if (model.getAlias() != null) {
            for (ServletContextModel sc : targetServletContexts) {
                if (!sc.getAliasMapping().containsKey(model.getAlias())) continue;
                String msg = String.format("%s can't be registered. Context %s already contains servlet mapping for alias %s: %s", model, sc.getContextPath(), model.getAlias(), sc.getAliasMapping().get(model.getAlias()));
                throw new NamespaceException(msg);
            }
            Iterator<Object> iterator = contextsWithNameConflicts.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String msg = String.format("%s can't be registered. %s already contains servlet named %s: %s", model, entry.getKey(), model.getName(), entry.getValue());
                throw new NamespaceException(msg);
            }
        }
        boolean register = true;
        HashSet<ServletModel> newlyDisabled = new HashSet<ServletModel>();
        for (ServletContextModel sc : targetServletContexts) {
            for (String pattern : model.getUrlPatterns()) {
                ServletModel existing = sc.getServletUrlPatternMapping().get(pattern);
                if (existing == null) continue;
                if (model.compareTo(existing) < 0 || existing.getDtoFailureCode() >= 0) {
                    newlyDisabled.add(existing);
                    continue;
                }
                List<OsgiContextModel> ours = model.getContextModels();
                List<OsgiContextModel> theirs = existing.getContextModels();
                if (ours.size() == 1 && theirs.size() == 1) {
                    if (ours.get(0).compareTo(theirs.get(0)) < 0) {
                        newlyDisabled.add(existing);
                    } else {
                        register = false;
                    }
                } else {
                    register = false;
                }
                if (register) break;
                LOG.warn("{} can't be registered now in context {} under \"{}\" mapping. Conflict with {}.", new Object[]{model, sc.getContextPath(), pattern, existing});
                break;
            }
            if (register) continue;
            break;
        }
        if (!register) {
            LOG.warn("Skipped registration of {} because of existing mappings. Servlet will be added as \"awaiting registration\".", (Object)model);
            batch.addDisabledServletModel(model);
            return;
        }
        for (ServletModel existing : newlyDisabled) {
            batch.disableServletModel(existing);
            contextsWithNameConflicts.entrySet().removeIf(e -> {
                boolean nameMatches = ((ServletModel)e.getValue()).getName().equals(existing.getName());
                boolean[] contextMatches = new boolean[]{false};
                this.getServletContextModels(existing).forEach(scm -> {
                    contextMatches[0] = contextMatches[0] | ((ServletContextModel)e.getKey()).equals(scm);
                });
                return nameMatches && contextMatches[0];
            });
        }
        if (!contextsWithNameConflicts.isEmpty()) {
            LOG.warn("Skipped registration of {} because of existing servlets with name {}. Servlet will be added as \"awaiting registration\".", (Object)model, (Object)model.getName());
            batch.addDisabledServletModel(model);
            return;
        }
        if (newlyDisabled.isEmpty()) {
            batch.addServletModel(model, new OsgiContextModel[0]);
            return;
        }
        HashMap<String, Map<String, ServletModel>> currentlyEnabledByName = new HashMap<String, Map<String, ServletModel>>();
        HashMap<String, Map<String, ServletModel>> currentlyEnabledByPattern = new HashMap<String, Map<String, ServletModel>>();
        TreeSet<ServletModel> currentlyDisabled = new TreeSet<ServletModel>();
        this.prepareServletsSnapshot(currentlyEnabledByName, currentlyEnabledByPattern, currentlyDisabled, model, newlyDisabled);
        this.reEnableServletModels(currentlyDisabled, currentlyEnabledByName, currentlyEnabledByPattern, model, batch);
        if (currentlyDisabled.contains(model)) {
            batch.addDisabledServletModel(model);
        }
    }

    public void removeServletModels(List<ServletModel> models, Batch batch) {
        LinkedHashMap<ServletModel, Boolean> modelsAndStates = new LinkedHashMap<ServletModel, Boolean>();
        models.forEach(m -> modelsAndStates.put((ServletModel)m, !this.disabledServletModels.contains(m)));
        batch.removeServletModels(modelsAndStates);
        HashMap<String, Map<String, ServletModel>> currentlyEnabledByName = new HashMap<String, Map<String, ServletModel>>();
        HashMap<String, Map<String, ServletModel>> currentlyEnabledByPattern = new HashMap<String, Map<String, ServletModel>>();
        TreeSet<ServletModel> currentlyDisabled = new TreeSet<ServletModel>();
        this.prepareServletsSnapshot(currentlyEnabledByName, currentlyEnabledByPattern, currentlyDisabled, null, new HashSet<ServletModel>(models));
        models.forEach(currentlyDisabled::remove);
        this.reEnableServletModels(currentlyDisabled, currentlyEnabledByName, currentlyEnabledByPattern, null, batch);
    }

    private void prepareServletsSnapshot(Map<String, Map<String, ServletModel>> currentlyEnabledByName, Map<String, Map<String, ServletModel>> currentlyEnabledByPattern, Set<ServletModel> currentlyDisabled, ServletModel newlyAdded, Set<ServletModel> newlyDisabled) {
        currentlyDisabled.addAll(this.disabledServletModels);
        this.servletContexts.values().forEach(scm -> {
            String path = scm.getContextPath();
            HashMap<String, ServletModel> enabledByName = new HashMap<String, ServletModel>(scm.getServletNameMapping());
            HashMap<String, ServletModel> enabledByPattern = new HashMap<String, ServletModel>(scm.getServletUrlPatternMapping());
            currentlyEnabledByName.put(path, enabledByName);
            currentlyEnabledByPattern.put(path, enabledByPattern);
            if (newlyDisabled != null) {
                newlyDisabled.forEach(sm -> this.getServletContextModels((ElementModel<?, ?>)sm).forEach(scm2 -> {
                    if (scm.equals(scm2)) {
                        enabledByName.remove(sm.getName(), sm);
                        Arrays.stream(sm.getUrlPatterns()).forEach(pattern -> enabledByPattern.remove(pattern, sm));
                    }
                }));
            }
        });
        if (newlyAdded != null) {
            currentlyDisabled.add(newlyAdded);
        }
    }

    private void reEnableServletModels(Set<ServletModel> currentlyDisabled, Map<String, Map<String, ServletModel>> currentlyEnabledByName, Map<String, Map<String, ServletModel>> currentlyEnabledByPattern, ServletModel modelToEnable, Batch batch) {
        LinkedHashSet<ServletModel> newlyDisabled = new LinkedHashSet<ServletModel>();
        boolean change = false;
        Iterator<ServletModel> iterator = currentlyDisabled.iterator();
        while (iterator.hasNext()) {
            ServletModel disabled = iterator.next();
            boolean canBeEnabled = true;
            newlyDisabled.clear();
            Set<ServletContextModel> contextsOfDisabledModel = this.getServletContextModels(disabled);
            for (ServletContextModel sc : contextsOfDisabledModel) {
                String cp = sc.getContextPath();
                for (Map.Entry<String, ServletModel> entry : currentlyEnabledByName.get(cp).entrySet()) {
                    ServletModel enabled = entry.getValue();
                    boolean nameConflict = this.haveAnyNameConflict(disabled.getName(), enabled.getName(), disabled, enabled);
                    if (!nameConflict) continue;
                    if (disabled.compareTo(enabled) < 0) {
                        newlyDisabled.add(enabled);
                        continue;
                    }
                    canBeEnabled = false;
                    break;
                }
                if (!canBeEnabled) break;
                for (String pattern : disabled.getUrlPatterns()) {
                    ServletModel existingMapping = currentlyEnabledByPattern.get(cp).get(pattern);
                    if (existingMapping == null) continue;
                    if (disabled.compareTo(existingMapping) < 0) {
                        newlyDisabled.add(existingMapping);
                        continue;
                    }
                    canBeEnabled = false;
                    break;
                }
                if (canBeEnabled) continue;
                break;
            }
            if (canBeEnabled) {
                newlyDisabled.forEach(model -> {
                    batch.disableServletModel((ServletModel)model);
                    this.getServletContextModels((ElementModel<?, ?>)model).forEach(scm -> {
                        ((Map)currentlyEnabledByName.get(scm.getContextPath())).remove(model.getName(), model);
                        Arrays.stream(model.getUrlPatterns()).forEach(p -> ((Map)currentlyEnabledByPattern.get(scm.getContextPath())).remove(p, model));
                    });
                });
                for (ServletContextModel sc : contextsOfDisabledModel) {
                    currentlyEnabledByName.get(sc.getContextPath()).put(disabled.getName(), disabled);
                    Arrays.stream(disabled.getUrlPatterns()).forEach(p -> ((Map)currentlyEnabledByPattern.get(sc.getContextPath())).put(p, disabled));
                }
                if (modelToEnable != null && modelToEnable.equals(disabled)) {
                    batch.addServletModel(disabled, new OsgiContextModel[0]);
                } else {
                    batch.enableServletModel(disabled);
                }
                iterator.remove();
                change = true;
            }
            if (!change) continue;
            break;
        }
        if (change) {
            this.reEnableServletModels(currentlyDisabled, currentlyEnabledByName, currentlyEnabledByPattern, modelToEnable, batch);
        }
    }

    public Set<ServletModel> getDisabledServletModels() {
        return this.disabledServletModels;
    }

    public Collection<ContainerInitializerModel> getContainerInitializerModels() {
        return this.containerInitializers.values();
    }

    public Set<WebSocketModel> getDisabledWebSocketModels() {
        return this.disabledWebSocketModels;
    }

    public void addFilterModel(FilterModel model, Batch batch) throws ServletException {
        if (model.getContextModels().isEmpty()) {
            throw new IllegalArgumentException("Can't register " + String.valueOf(model) + ", it is not associated with any context");
        }
        if (model.getFilter() != null && this.filters.containsKey(model.getFilter())) {
            throw new ServletException("Can't register filter " + String.valueOf(model.getFilter()) + ", it has already been registered using " + String.valueOf(this.filters.get(model.getFilter())));
        }
        Set<ServletContextModel> targetServletContexts = this.getServletContextModels(model);
        boolean register = true;
        HashSet<FilterModel> newlyDisabled = new HashSet<FilterModel>();
        if (!model.isPreprocessor()) {
            for (ServletContextModel sc : targetServletContexts) {
                FilterModel existing = sc.getFilterNameMapping().get(model.getName());
                if (existing == null) continue;
                if (model.compareTo(existing) < 0) {
                    newlyDisabled.add(existing);
                    continue;
                }
                LOG.warn("{} can't be registered now in context {}. Name conflict with {}.", new Object[]{model, sc.getContextPath(), existing});
                register = false;
                break;
            }
        }
        if (!register) {
            LOG.warn("Skipped registration of {} because of name conflict. Filter will be registered as \"awaiting registration\".", (Object)model);
            batch.addDisabledFilterModel(model);
            return;
        }
        for (FilterModel existing : newlyDisabled) {
            batch.disableFilterModel(existing);
        }
        HashMap<String, TreeMap<FilterModel, List<OsgiContextModel>>> currentlyEnabledByPath = new HashMap<String, TreeMap<FilterModel, List<OsgiContextModel>>>();
        TreeSet<FilterModel> currentlyDisabled = new TreeSet<FilterModel>();
        this.prepareFiltersSnapshot(currentlyEnabledByPath, currentlyDisabled, model, newlyDisabled);
        this.reEnableFilterModels(currentlyDisabled, currentlyEnabledByPath, model, batch);
        batch.updateFilters(currentlyEnabledByPath, model.isDynamic());
    }

    public void removeFilterModels(List<FilterModel> models, Batch batch) {
        batch.removeFilterModels(models);
        HashMap<String, TreeMap<FilterModel, List<OsgiContextModel>>> currentlyEnabledByPath = new HashMap<String, TreeMap<FilterModel, List<OsgiContextModel>>>();
        TreeSet<FilterModel> currentlyDisabled = new TreeSet<FilterModel>();
        this.prepareFiltersSnapshot(currentlyEnabledByPath, currentlyDisabled, null, new HashSet<FilterModel>(models));
        models.forEach(currentlyDisabled::remove);
        this.reEnableFilterModels(currentlyDisabled, currentlyEnabledByPath, null, batch);
        batch.updateFilters(currentlyEnabledByPath, false);
    }

    public void prepareFiltersSnapshot(Map<String, TreeMap<FilterModel, List<OsgiContextModel>>> currentlyEnabledByPath, Set<FilterModel> currentlyDisabled, FilterModel newlyAdded, Set<FilterModel> newlyDisabled) {
        currentlyDisabled.addAll(this.disabledFilterModels);
        this.servletContexts.values().forEach(scm -> {
            String path = scm.getContextPath();
            TreeMap<FilterModel, Object> enabledFilters = new TreeMap<FilterModel, Object>();
            for (FilterModel fm2 : scm.getFilterNameMapping().values()) {
                enabledFilters.put(fm2, null);
            }
            currentlyEnabledByPath.put(path, enabledFilters);
            if (newlyDisabled != null) {
                newlyDisabled.forEach(fm -> this.getServletContextModels((ElementModel<?, ?>)fm).forEach(scm2 -> {
                    if (scm.equals(scm2)) {
                        enabledFilters.remove(fm);
                    }
                }));
            }
        });
        if (newlyAdded != null) {
            currentlyDisabled.add(newlyAdded);
        }
    }

    private void reEnableFilterModels(Set<FilterModel> currentlyDisabled, Map<String, TreeMap<FilterModel, List<OsgiContextModel>>> currentlyEnabledByPath, FilterModel modelToEnable, Batch batch) {
        LinkedHashSet<FilterModel> newlyDisabled = new LinkedHashSet<FilterModel>();
        boolean change = false;
        Iterator<FilterModel> iterator = currentlyDisabled.iterator();
        while (iterator.hasNext()) {
            FilterModel disabled = iterator.next();
            boolean canBeEnabled = true;
            newlyDisabled.clear();
            Set<ServletContextModel> contextsOfDisabledModel = this.getServletContextModels(disabled);
            if (!disabled.isPreprocessor()) {
                for (ServletContextModel sc : contextsOfDisabledModel) {
                    String cp = sc.getContextPath();
                    for (FilterModel enabled : currentlyEnabledByPath.get(cp).keySet()) {
                        boolean nameConflict = this.haveAnyNameConflict(disabled.getName(), enabled.getName(), disabled, enabled);
                        if (!nameConflict) continue;
                        if (disabled.compareTo(enabled) < 0) {
                            newlyDisabled.add(enabled);
                            continue;
                        }
                        canBeEnabled = false;
                        break;
                    }
                    if (canBeEnabled) continue;
                    break;
                }
            }
            if (canBeEnabled) {
                newlyDisabled.forEach(model -> {
                    batch.disableFilterModel((FilterModel)model);
                    this.getServletContextModels((ElementModel<?, ?>)model).forEach(scm -> ((TreeMap)currentlyEnabledByPath.get(scm.getContextPath())).remove(model));
                });
                for (ServletContextModel sc : contextsOfDisabledModel) {
                    currentlyEnabledByPath.get(sc.getContextPath()).put(disabled, null);
                }
                if (modelToEnable != null && modelToEnable.equals(disabled)) {
                    batch.addFilterModel(disabled, new OsgiContextModel[0]);
                } else {
                    batch.enableFilterModel(disabled);
                }
                iterator.remove();
                change = true;
            }
            if (!change) continue;
            break;
        }
        if (change) {
            this.reEnableFilterModels(currentlyDisabled, currentlyEnabledByPath, modelToEnable, batch);
        }
    }

    private <T, D extends WebElementEventData> boolean haveAnyNameConflict(String name1, String name2, ElementModel<T, D> model1, ElementModel<T, D> model2) {
        if (name1.equals(name2)) {
            for (ServletContextModel sc1 : this.getServletContextModels(model1)) {
                for (ServletContextModel sc2 : this.getServletContextModels(model2)) {
                    if (!sc1.equals(sc2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void addEventListenerModel(EventListenerModel model, Batch batch) {
        if (model.getContextModels().isEmpty()) {
            throw new IllegalArgumentException("Can't register " + String.valueOf(model) + ", it is not associated with any context");
        }
        if (model.getEventListener() != null && this.eventListeners.containsKey(model.getEventListener())) {
            throw new IllegalArgumentException("Can't register EventLister " + String.valueOf(model.getEventListener()) + ", it is already registered");
        }
        batch.addEventListenerModel(model, new OsgiContextModel[0]);
    }

    public void removeEventListenerModels(List<EventListenerModel> models, Batch batch) {
        batch.removeEventListenerModels(models);
    }

    public void addContainerInitializerModel(ContainerInitializerModel model, Batch batch) {
        if (model.getContextModels().isEmpty()) {
            throw new IllegalArgumentException("Can't register " + String.valueOf(model) + ", it is not associated with any context");
        }
        if (model.getContainerInitializer() != null && this.containerInitializers.containsKey(model.getContainerInitializer())) {
            throw new IllegalArgumentException("Can't register ContainerInitializer " + String.valueOf(model.getContainerInitializer()) + ", it is already registered");
        }
        batch.addContainerInitializerModel(model, new OsgiContextModel[0]);
    }

    public void addWelcomeFileModel(WelcomeFileModel model, Batch batch) {
        if (model.getContextModels().isEmpty()) {
            throw new IllegalArgumentException("Can't register " + String.valueOf(model) + ", it is not associated with any context");
        }
        batch.addWelcomeFileModel(model, new OsgiContextModel[0]);
    }

    public void removeWelcomeFileModel(WelcomeFileModel model, Batch batch) {
        batch.removeWelcomeFileModel(model);
    }

    public void addErrorPageModel(ErrorPageModel model, Batch batch) {
        if (model.getContextModels().isEmpty()) {
            throw new IllegalArgumentException("Can't register " + String.valueOf(model) + ", it is not associated with any context");
        }
        Set<ServletContextModel> targetServletContexts = this.getServletContextModels(model);
        HashMap<String, TreeMap<ErrorPageModel, List<OsgiContextModel>>> currentlyEnabledByPath = new HashMap<String, TreeMap<ErrorPageModel, List<OsgiContextModel>>>();
        TreeSet<ErrorPageModel> currentlyDisabled = new TreeSet<ErrorPageModel>();
        HashSet<ErrorPageModel> newlyDisabled = new HashSet<ErrorPageModel>();
        this.prepareErrorPageSnapshot(currentlyEnabledByPath, currentlyDisabled, model, newlyDisabled);
        this.reEnableErrorPageModels(currentlyDisabled, currentlyEnabledByPath, model, batch);
        batch.updateErrorPages(currentlyEnabledByPath);
    }

    public void removeErrorPageModels(List<ErrorPageModel> models, Batch batch) {
        batch.removeErrorPageModels(models);
        HashMap<String, TreeMap<ErrorPageModel, List<OsgiContextModel>>> currentlyEnabledByPath = new HashMap<String, TreeMap<ErrorPageModel, List<OsgiContextModel>>>();
        TreeSet<ErrorPageModel> currentlyDisabled = new TreeSet<ErrorPageModel>();
        this.prepareErrorPageSnapshot(currentlyEnabledByPath, currentlyDisabled, null, new HashSet<ErrorPageModel>(models));
        this.reEnableErrorPageModels(currentlyDisabled, currentlyEnabledByPath, null, batch);
        batch.updateErrorPages(currentlyEnabledByPath);
    }

    public void prepareErrorPageSnapshot(Map<String, TreeMap<ErrorPageModel, List<OsgiContextModel>>> currentlyEnabledByPath, Set<ErrorPageModel> currentlyDisabled, ErrorPageModel newlyAdded, Set<ErrorPageModel> newlyDisabled) {
        currentlyDisabled.addAll(this.disabledErrorPageModels);
        this.servletContexts.values().forEach(scm -> {
            String path = scm.getContextPath();
            TreeMap<ErrorPageModel, Object> enabledErrorPages = new TreeMap<ErrorPageModel, Object>();
            for (ErrorPageModel epm2 : scm.getErrorPageMapping().values()) {
                enabledErrorPages.put(epm2, null);
            }
            for (ServletModel sm : scm.getServletNameMapping().values()) {
                if (sm.getErrorPageModel() == null || !sm.getErrorPageModel().isValid()) continue;
                enabledErrorPages.put(sm.getErrorPageModel(), null);
            }
            currentlyEnabledByPath.put(path, enabledErrorPages);
            if (newlyDisabled != null) {
                newlyDisabled.forEach(epm -> this.getServletContextModels((ElementModel<?, ?>)epm).forEach(scm2 -> {
                    if (scm.equals(scm2)) {
                        enabledErrorPages.remove(epm);
                    }
                }));
            }
        });
        if (newlyAdded != null) {
            currentlyDisabled.add(newlyAdded);
        }
    }

    private void reEnableErrorPageModels(Set<ErrorPageModel> currentlyDisabled, Map<String, TreeMap<ErrorPageModel, List<OsgiContextModel>>> currentlyEnabledByPath, ErrorPageModel modelToEnable, Batch batch) {
        LinkedHashSet<ErrorPageModel> newlyDisabled = new LinkedHashSet<ErrorPageModel>();
        boolean change = false;
        Iterator<ErrorPageModel> iterator = currentlyDisabled.iterator();
        while (iterator.hasNext()) {
            ErrorPageModel disabled = iterator.next();
            boolean canBeEnabled = true;
            newlyDisabled.clear();
            Set<ServletContextModel> contextsOfDisabledModel = this.getServletContextModels(disabled);
            for (ServletContextModel sc : contextsOfDisabledModel) {
                String cp = sc.getContextPath();
                for (ErrorPageModel enabled : currentlyEnabledByPath.get(cp).keySet()) {
                    boolean conflict = false;
                    for (String page1 : disabled.getErrorPages()) {
                        for (String page2 : enabled.getErrorPages()) {
                            if (!page1.equals(page2)) continue;
                            conflict = true;
                            break;
                        }
                        if (conflict) break;
                    }
                    if (!conflict) continue;
                    if (disabled.compareTo(enabled) < 0) {
                        newlyDisabled.add(enabled);
                        continue;
                    }
                    canBeEnabled = false;
                    break;
                }
                if (canBeEnabled) continue;
                break;
            }
            if (canBeEnabled) {
                newlyDisabled.forEach(model -> {
                    batch.disableErrorPageModel((ErrorPageModel)model);
                    this.getServletContextModels((ElementModel<?, ?>)model).forEach(scm -> ((TreeMap)currentlyEnabledByPath.get(scm.getContextPath())).remove(model));
                });
                for (ServletContextModel sc : contextsOfDisabledModel) {
                    currentlyEnabledByPath.get(sc.getContextPath()).put(disabled, null);
                }
                if (modelToEnable != null && modelToEnable.equals(disabled)) {
                    batch.addErrorPageModel(disabled, new OsgiContextModel[0]);
                } else {
                    batch.enableErrorPageModel(disabled);
                }
                iterator.remove();
                change = true;
            }
            if (modelToEnable != null && currentlyDisabled.contains(modelToEnable)) {
                batch.addDisabledErrorPageModel(modelToEnable);
            }
            if (!change) continue;
            break;
        }
        if (change) {
            this.reEnableErrorPageModels(currentlyDisabled, currentlyEnabledByPath, modelToEnable, batch);
        }
    }

    public ServletModel createJspServletModel(Bundle serviceBundle, String name, String jspFile, String[] urlPatterns, Map<String, String> initParams, JspConfiguration config) {
        Class jspServletClass;
        Bundle paxWebJsp = Utils.getPaxWebJspBundle(serviceBundle.getBundleContext());
        if (paxWebJsp == null) {
            throw new IllegalStateException("pax-web-jsp bundle is not installed. Can't register JSP servlet.");
        }
        try {
            jspServletClass = paxWebJsp.loadClass("org.ops4j.pax.web.jsp.JspServlet");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Can't load JSP servlet class org.ops4j.pax.web.jsp.JspServlet from bundle " + String.valueOf(paxWebJsp));
        }
        if (jspFile == null && (urlPatterns == null || urlPatterns.length == 0)) {
            urlPatterns = new String[]{"*.jsp"};
        }
        return new ServletModel.Builder().withServletName(name).withServletClass(jspServletClass).withServletJspFile(jspFile).withLoadOnStartup(1).withAsyncSupported(true).withUrlPatterns(urlPatterns).withInitParams(initParams).jspServlet(true).build();
    }

    public ContainerInitializerModel createJSPServletContainerInitializerModel(Bundle serviceBundle) {
        ServletContainerInitializer sci;
        Bundle paxWebJsp = Utils.getPaxWebJspBundle(serviceBundle.getBundleContext());
        if (paxWebJsp == null) {
            throw new IllegalStateException("pax-web-jsp bundle is not installed. Can't register JSP servlet.");
        }
        try {
            Class jspSCIClass = paxWebJsp.loadClass("org.ops4j.pax.web.jsp.JasperInitializer");
            sci = (ServletContainerInitializer)jspSCIClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Can't create JSP SCI org.ops4j.pax.web.jsp.JasperInitializer using bundle " + String.valueOf(paxWebJsp));
        }
        return new ContainerInitializerModel(sci, null);
    }

    public void addWebSocketModel(WebSocketModel model, Batch batch) {
        if (model.getContextModels().isEmpty()) {
            throw new IllegalArgumentException("Can't register " + String.valueOf(model) + ", it is not associated with any context");
        }
        Object wsInstance = model.getWebSocketEndpoint();
        if (wsInstance != null && this.webSockets.containsKey(wsInstance)) {
            throw new IllegalArgumentException("Can't register web socket " + String.valueOf(wsInstance) + ", it has already been registered using " + String.valueOf(this.webSockets.get(wsInstance)));
        }
        Class<?> wsClass = model.getWebSocketEndpointClass();
        if (wsClass != null && this.webSockets.containsKey(wsClass)) {
            throw new IllegalArgumentException("Can't register web socket by class " + String.valueOf(wsClass) + ", it has already been registered using " + String.valueOf(this.webSockets.get(wsClass)));
        }
        Set<ServletContextModel> targetServletContexts = this.getServletContextModels(model);
        boolean register = true;
        HashSet<WebSocketModel> newlyDisabled = new HashSet<WebSocketModel>();
        for (ServletContextModel sc : targetServletContexts) {
            WebSocketModel existing = sc.getWebSocketUrlPathMapping().get(model.getMappedPath());
            if (existing == null) continue;
            if (model.compareTo(existing) < 0) {
                newlyDisabled.add(existing);
                continue;
            }
            LOG.warn("{} can't be registered now in context {} under \"{}\" mapping. Conflict with {}.", new Object[]{model, sc.getContextPath(), model.getMappedPath(), existing});
            register = false;
            break;
        }
        if (!register) {
            LOG.warn("Skipped registration of {} because of existing mappings. WebSocket will be added as \"awaiting registration\".", (Object)model);
            batch.addDisabledWebSocketModel(model);
            return;
        }
        for (WebSocketModel existing : newlyDisabled) {
            batch.disableWebSocketModel(existing);
        }
        if (newlyDisabled.isEmpty()) {
            batch.addWebSocketModel(model);
            return;
        }
        HashMap<String, Map<String, WebSocketModel>> currentlyEnabledByPath = new HashMap<String, Map<String, WebSocketModel>>();
        TreeSet<WebSocketModel> currentlyDisabled = new TreeSet<WebSocketModel>();
        this.prepareWebSocketsSnapshot(currentlyEnabledByPath, currentlyDisabled, model, newlyDisabled);
        this.reEnableWebSocketModels(currentlyDisabled, currentlyEnabledByPath, model, batch);
        if (currentlyDisabled.contains(model)) {
            batch.addDisabledWebSocketModel(model);
        }
    }

    public void removeWebSocketModels(List<WebSocketModel> models, Batch batch) {
        LinkedHashMap<WebSocketModel, Boolean> modelsAndStates = new LinkedHashMap<WebSocketModel, Boolean>();
        models.forEach(m -> modelsAndStates.put((WebSocketModel)m, !this.disabledWebSocketModels.contains(m)));
        batch.removeWebSocketModels(modelsAndStates);
        HashMap<String, Map<String, WebSocketModel>> currentlyEnabledByPath = new HashMap<String, Map<String, WebSocketModel>>();
        TreeSet<WebSocketModel> currentlyDisabled = new TreeSet<WebSocketModel>();
        this.prepareWebSocketsSnapshot(currentlyEnabledByPath, currentlyDisabled, null, new HashSet<WebSocketModel>(models));
        this.reEnableWebSocketModels(currentlyDisabled, currentlyEnabledByPath, null, batch);
    }

    public void prepareWebSocketsSnapshot(Map<String, Map<String, WebSocketModel>> currentlyEnabledByPath, Set<WebSocketModel> currentlyDisabled, WebSocketModel newlyAdded, Set<WebSocketModel> newlyDisabled) {
        currentlyDisabled.addAll(this.disabledWebSocketModels);
        this.servletContexts.values().forEach(scm -> {
            String path = scm.getContextPath();
            HashMap<String, WebSocketModel> enabledByPath = new HashMap<String, WebSocketModel>(scm.getWebSocketUrlPathMapping());
            currentlyEnabledByPath.put(path, enabledByPath);
            if (newlyDisabled != null) {
                newlyDisabled.forEach(wsm -> this.getServletContextModels((ElementModel<?, ?>)wsm).forEach(scm2 -> {
                    if (scm.equals(scm2)) {
                        enabledByPath.remove(wsm.getMappedPath(), wsm);
                    }
                }));
            }
        });
        if (newlyAdded != null) {
            currentlyDisabled.add(newlyAdded);
        }
    }

    private void reEnableWebSocketModels(Set<WebSocketModel> currentlyDisabled, Map<String, Map<String, WebSocketModel>> currentlyEnabledByPath, WebSocketModel modelToEnable, Batch batch) {
        LinkedHashSet<WebSocketModel> newlyDisabled = new LinkedHashSet<WebSocketModel>();
        boolean change = false;
        Iterator<WebSocketModel> iterator = currentlyDisabled.iterator();
        while (iterator.hasNext()) {
            WebSocketModel disabled = iterator.next();
            boolean canBeEnabled = true;
            newlyDisabled.clear();
            Set<ServletContextModel> contextsOfDisabledModel = this.getServletContextModels(disabled);
            for (ServletContextModel sc : contextsOfDisabledModel) {
                String cp = sc.getContextPath();
                WebSocketModel existingMapping = currentlyEnabledByPath.get(cp).get(disabled.getMappedPath());
                if (existingMapping == null) continue;
                if (disabled.compareTo(existingMapping) < 0) {
                    newlyDisabled.add(existingMapping);
                    continue;
                }
                canBeEnabled = false;
                break;
            }
            if (canBeEnabled) {
                newlyDisabled.forEach(model -> {
                    batch.disableWebSocketModel((WebSocketModel)model);
                    this.getServletContextModels((ElementModel<?, ?>)model).forEach(scm -> ((Map)currentlyEnabledByPath.get(scm.getContextPath())).remove(model.getMappedPath()));
                });
                for (ServletContextModel sc : contextsOfDisabledModel) {
                    currentlyEnabledByPath.get(sc.getContextPath()).put(disabled.getMappedPath(), null);
                }
                if (modelToEnable != null && modelToEnable.equals(disabled)) {
                    batch.addWebSocketModel(disabled);
                } else {
                    batch.enableWebSocketModel(disabled);
                }
                iterator.remove();
                change = true;
            }
            if (!change) continue;
            break;
        }
        if (change) {
            this.reEnableWebSocketModels(currentlyDisabled, currentlyEnabledByPath, modelToEnable, batch);
        }
    }

    @Override
    public void visitServletContextModelChange(ServletContextModelChange change) {
        if (change.getKind() == OpCode.ADD) {
            ServletContextModel model = change.getServletContextModel();
            this.servletContexts.put(model.getContextPath(), model);
        } else if (change.getKind() == OpCode.DELETE) {
            ServletContextModel model = change.getServletContextModel();
            this.servletContexts.remove(model.getContextPath(), model);
        }
    }

    @Override
    public void visitOsgiContextModelChange(OsgiContextModelChange change) {
        switch (change.getKind()) {
            case ASSOCIATE: {
                OsgiContextModel model = change.getOsgiContextModel();
                this.associateHttpContext(model.getDirectHttpContextInstance(), model);
                break;
            }
            case DISASSOCIATE: {
                OsgiContextModel model = change.getOsgiContextModel();
                this.disassociateHttpContext(model.getDirectHttpContextInstance(), model);
                break;
            }
            case ADD: 
            case DELETE: {
                break;
            }
        }
    }

    @Override
    public void visitServletModelChange(ServletModelChange change) {
        switch (change.getKind()) {
            case ADD: {
                ServletModel model2 = change.getServletModel();
                Set<ServletContextModel> servletContexts = this.getServletContextModels(model2);
                servletContexts.forEach(sc -> {
                    if (change.isDisabled()) {
                        this.disabledServletModels.add(model2);
                    } else {
                        sc.getServletNameMapping().put(model2.getName(), model2);
                        if (model2.getAlias() != null) {
                            sc.getAliasMapping().put(model2.getAlias(), model2);
                        }
                        Arrays.stream(model2.getUrlPatterns()).forEach(p -> sc.getServletUrlPatternMapping().put((String)p, model2));
                        ErrorPageModel epModel = model2.getErrorPageModel();
                        if (epModel != null && epModel.isValid() && epModel.getDtoFailureCode() == -1) {
                            for (String page : epModel.getErrorPages()) {
                                sc.getErrorPageMapping().put(page, epModel);
                            }
                        }
                    }
                });
                if (model2.getServlet() != null) {
                    this.servlets.put(model2.getServlet(), model2);
                }
                if (change.isDisabled()) break;
                this.servletsForDTO.add(model2);
                break;
            }
            case DELETE: {
                Set<ServletModel> models = change.getServletModels().keySet();
                models.forEach(model -> {
                    this.servletsForDTO.remove(model);
                    if (model.getServlet() != null) {
                        this.servlets.remove(model.getServlet(), model);
                    }
                    boolean wasDisabled = this.disabledServletModels.remove(model);
                    if (model.getErrorPageModel() != null) {
                        this.disabledErrorPageModels.remove(model.getErrorPageModel());
                    }
                    if (!wasDisabled) {
                        Set<ServletContextModel> servletContexts = this.getServletContextModels((ElementModel<?, ?>)model);
                        servletContexts.forEach(sc -> {
                            sc.getServletNameMapping().remove(model.getName(), model);
                            if (model.getAlias() != null) {
                                sc.getAliasMapping().remove(model.getAlias(), model);
                            }
                            Arrays.stream(model.getUrlPatterns()).forEach(p -> sc.getServletUrlPatternMapping().remove(p, model));
                            ErrorPageModel epModel = model.getErrorPageModel();
                            if (epModel != null) {
                                for (String page : epModel.getErrorPages()) {
                                    sc.getErrorPageMapping().remove(page, epModel);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case ENABLE: {
                ServletModel model3 = change.getServletModel();
                Set<ServletContextModel> servletContexts = this.getServletContextModels(model3);
                servletContexts.forEach(sc -> sc.enableServletModel(model3));
                this.disabledServletModels.remove(model3);
                if (model3.getErrorPageModel() == null) break;
                servletContexts.forEach(sc -> sc.enableErrorPageModel(model3.getErrorPageModel()));
                if (model3.getErrorPageModel().getDtoFailureCode() == 3) {
                    model3.getErrorPageModel().setDtoFailureCode(-1);
                }
                this.disabledErrorPageModels.remove(model3.getErrorPageModel());
                break;
            }
            case DISABLE: {
                ServletModel model4 = change.getServletModel();
                this.disabledServletModels.add(model4);
                Set<ServletContextModel> servletContexts = this.getServletContextModels(model4);
                servletContexts.forEach(sc -> sc.disableServletModel(model4));
                if (model4.getErrorPageModel() == null) break;
                servletContexts.forEach(sc -> sc.disableErrorPageModel(model4.getErrorPageModel()));
                this.disabledErrorPageModels.add(model4.getErrorPageModel());
                model4.getErrorPageModel().setDtoFailureCode(3);
                break;
            }
        }
    }

    @Override
    public void visitFilterModelChange(FilterModelChange change) {
        switch (change.getKind()) {
            case ADD: {
                FilterModel model2 = change.getFilterModel();
                Set<ServletContextModel> servletContexts = this.getServletContextModels(model2);
                servletContexts.forEach(sc -> {
                    if (change.isDisabled()) {
                        this.disabledFilterModels.add(model2);
                    } else if (model2.isPreprocessor()) {
                        sc.getFilterNameMapping().put(model2.getName() + "-" + model2.getId(), model2);
                    } else {
                        sc.getFilterNameMapping().put(model2.getName(), model2);
                    }
                });
                if (model2.getFilter() != null) {
                    this.filters.put(model2.getFilter(), model2);
                }
                if (change.isDisabled()) break;
                this.filtersForDTO.add(model2);
                break;
            }
            case MODIFY: {
                break;
            }
            case DELETE: {
                List<FilterModel> models = change.getFilterModels();
                models.forEach(model -> {
                    boolean wasDisabled;
                    this.filtersForDTO.remove(model);
                    if (model.getFilter() != null) {
                        this.filters.remove(model.getFilter(), model);
                    }
                    if (!(wasDisabled = this.disabledFilterModels.remove(model))) {
                        Set<ServletContextModel> servletContexts = this.getServletContextModels((ElementModel<?, ?>)model);
                        servletContexts.forEach(sc -> {
                            if (model.isPreprocessor()) {
                                sc.getFilterNameMapping().remove(model.getName() + "-" + model.getId(), model);
                            } else {
                                sc.getFilterNameMapping().remove(model.getName(), model);
                            }
                        });
                    }
                });
                break;
            }
            case ENABLE: {
                FilterModel model3 = change.getFilterModel();
                Set<ServletContextModel> servletContexts = this.getServletContextModels(model3);
                servletContexts.forEach(sc -> sc.enableFilterModel(model3));
                this.disabledFilterModels.remove(model3);
                break;
            }
            case DISABLE: {
                FilterModel model4 = change.getFilterModel();
                this.disabledFilterModels.add(model4);
                Set<ServletContextModel> servletContexts = this.getServletContextModels(model4);
                servletContexts.forEach(sc -> sc.disableFilterModel(model4));
                break;
            }
        }
    }

    @Override
    public void visitFilterStateChange(FilterStateChange change) {
    }

    @Override
    public void visitEventListenerModelChange(EventListenerModelChange change) {
        switch (change.getKind()) {
            case ADD: {
                EventListenerModel model2 = change.getEventListenerModel();
                if (model2.getEventListener() != null) {
                    this.eventListeners.put(model2.getEventListener(), model2);
                }
                this.eventListenersForDTO.add(model2);
                break;
            }
            case DELETE: {
                List<EventListenerModel> models = change.getEventListenerModels();
                models.forEach(model -> {
                    this.eventListenersForDTO.remove(model);
                    if (model.getEventListener() != null) {
                        this.eventListeners.remove(model.getEventListener(), model);
                    }
                });
                break;
            }
        }
    }

    @Override
    public void visitWelcomeFileModelChange(WelcomeFileModelChange change) {
    }

    @Override
    public void visitErrorPageModelChange(ErrorPageModelChange change) {
        switch (change.getKind()) {
            case ADD: {
                ErrorPageModel model2 = change.getErrorPageModel();
                Set<ServletContextModel> servletContexts = this.getServletContextModels(model2);
                servletContexts.forEach(sc -> {
                    if (change.isDisabled()) {
                        this.disabledErrorPageModels.add(model2);
                    } else {
                        for (String page : model2.getErrorPages()) {
                            sc.getErrorPageMapping().put(page, model2);
                        }
                    }
                });
                break;
            }
            case MODIFY: {
                break;
            }
            case DELETE: {
                List<ErrorPageModel> models = change.getErrorPageModels();
                models.forEach(model -> {
                    boolean wasDisabled = this.disabledErrorPageModels.remove(model);
                    if (!wasDisabled) {
                        Set<ServletContextModel> servletContexts = this.getServletContextModels((ElementModel<?, ?>)model);
                        servletContexts.forEach(sc -> {
                            for (String page : model.getErrorPages()) {
                                sc.getErrorPageMapping().remove(page, model);
                            }
                        });
                    }
                });
                break;
            }
            case ENABLE: {
                ErrorPageModel model3 = change.getErrorPageModel();
                Set<ServletContextModel> servletContexts = this.getServletContextModels(model3);
                servletContexts.forEach(sc -> sc.enableErrorPageModel(model3));
                this.disabledErrorPageModels.remove(model3);
                break;
            }
            case DISABLE: {
                ErrorPageModel model4 = change.getErrorPageModel();
                this.disabledErrorPageModels.add(model4);
                Set<ServletContextModel> servletContexts = this.getServletContextModels(model4);
                servletContexts.forEach(sc -> sc.disableErrorPageModel(model4));
                break;
            }
        }
    }

    @Override
    public void visitErrorPageStateChange(ErrorPageStateChange change) {
    }

    @Override
    public void visitContainerInitializerModelChange(ContainerInitializerModelChange change) {
        switch (change.getKind()) {
            case ADD: {
                ContainerInitializerModel model2 = change.getContainerInitializerModel();
                if (model2.getContainerInitializer() == null) break;
                this.containerInitializers.put(model2.getContainerInitializer(), model2);
                break;
            }
            case DELETE: {
                List<ContainerInitializerModel> models = change.getContainerInitializerModels();
                models.forEach(model -> {
                    if (model.getContainerInitializer() != null) {
                        this.containerInitializers.remove(model.getContainerInitializer(), model);
                    }
                });
                break;
            }
        }
    }

    @Override
    public void visitWebSocketModelChange(WebSocketModelChange change) {
        switch (change.getKind()) {
            case ADD: {
                WebSocketModel model2 = change.getWebSocketModel();
                Set<ServletContextModel> servletContexts = this.getServletContextModels(model2);
                servletContexts.forEach(sc -> {
                    if (change.isDisabled()) {
                        this.disabledWebSocketModels.add(model2);
                    } else {
                        sc.getWebSocketUrlPathMapping().put(model2.getMappedPath(), model2);
                    }
                });
                if (model2.getWebSocketEndpoint() != null) {
                    this.webSockets.put(model2.getWebSocketEndpoint(), model2);
                }
                if (model2.getWebSocketEndpointClass() == null) break;
                this.webSockets.put(model2.getWebSocketEndpointClass(), model2);
                break;
            }
            case MODIFY: {
                break;
            }
            case DELETE: {
                Set<WebSocketModel> models = change.getWebSocketModels().keySet();
                models.forEach(model -> {
                    boolean wasDisabled;
                    if (model.getWebSocketEndpoint() != null) {
                        this.webSockets.remove(model.getWebSocketEndpoint(), model);
                    }
                    if (model.getWebSocketEndpointClass() != null) {
                        this.webSockets.remove(model.getWebSocketEndpointClass(), model);
                    }
                    if (!(wasDisabled = this.disabledWebSocketModels.remove(model))) {
                        Set<ServletContextModel> servletContexts = this.getServletContextModels((ElementModel<?, ?>)model);
                        servletContexts.forEach(sc -> sc.getWebSocketUrlPathMapping().remove(model.getMappedPath(), model));
                    }
                });
                break;
            }
            case ENABLE: {
                WebSocketModel model3 = change.getWebSocketModel();
                Set<ServletContextModel> servletContexts = this.getServletContextModels(model3);
                servletContexts.forEach(sc -> sc.enableWebSocketModel(model3));
                this.disabledWebSocketModels.remove(model3);
                break;
            }
            case DISABLE: {
                WebSocketModel model4 = change.getWebSocketModel();
                this.disabledWebSocketModels.add(model4);
                Set<ServletContextModel> servletContexts = this.getServletContextModels(model4);
                servletContexts.forEach(sc -> sc.disableWebSocketModel(model4));
                break;
            }
        }
    }

    @Override
    public void visitClearDynamicRegistrationsChange(ClearDynamicRegistrationsChange change) {
        ElementModel model;
        Map.Entry<Object, ElementModel> e2;
        Iterator<Map.Entry<Object, ElementModel>> iterator = this.servlets.entrySet().iterator();
        while (iterator.hasNext()) {
            e2 = iterator.next();
            Servlet servlet = e2.getKey();
            model = e2.getValue();
            if (!((ServletModel)model).isDynamic()) continue;
            this.disabledServletModels.remove(model);
            this.getServletContextModels(model).forEach(arg_0 -> this.lambda$visitClearDynamicRegistrationsChange$69((ServletModel)model, arg_0));
            iterator.remove();
        }
        iterator = this.filters.entrySet().iterator();
        while (iterator.hasNext()) {
            e2 = iterator.next();
            jakarta.servlet.Filter filter = (jakarta.servlet.Filter)e2.getKey();
            model = (FilterModel)e2.getValue();
            if (!((FilterModel)model).isDynamic()) continue;
            this.getServletContextModels(model).forEach(arg_0 -> ServerModel.lambda$visitClearDynamicRegistrationsChange$70((FilterModel)model, arg_0));
            iterator.remove();
        }
        this.eventListeners.entrySet().removeIf(e -> ((EventListenerModel)e.getValue()).isDynamic());
    }

    public RuntimeDTO getRuntimeDTO() {
        return this.runSilently(() -> {
            RuntimeDTO dto = new RuntimeDTO();
            dto.serviceDTO = new ServiceReferenceDTO();
            dto.serviceDTO.id = this.httpServiceRuntimeDTO.id;
            dto.serviceDTO.bundle = this.httpServiceRuntimeDTO.bundle;
            dto.serviceDTO.usingBundles = Arrays.stream(this.httpServiceRuntimeReg.getReference().getUsingBundles()).mapToLong(Bundle::getBundleId).toArray();
            dto.serviceDTO.properties = new HashMap(this.httpServiceRuntimeDTO.properties);
            dto.serviceDTO.properties.put("service.changecount", this.changeCount.get());
            LinkedHashMap scDTOs = new LinkedHashMap();
            ArrayList failedScDTOs = new ArrayList();
            this.bundleWabAllocatedContexts.values().forEach(ocm -> scDTOs.put(ocm, ocm.toDTO()));
            this.bundleContexts.values().forEach(ocms -> {
                boolean first = true;
                for (OsgiContextModel ocm : ocms) {
                    if (first) {
                        scDTOs.put(ocm, ocm.toDTO());
                    } else {
                        failedScDTOs.add(ocm.toFailedDTO(3));
                    }
                    first = false;
                }
            });
            this.bundleDefaultContexts.values().forEach(ocm -> failedScDTOs.add(ocm.toFailedDTO(3)));
            this.whiteboardContexts.values().forEach(ocms -> {
                boolean first = true;
                for (OsgiContextModel ocm : ocms) {
                    if (ocm.getDtoFailureCode() >= 0) {
                        failedScDTOs.add(ocm.toFailedDTO(ocm.getDtoFailureCode()));
                        continue;
                    }
                    if (first) {
                        scDTOs.put(ocm, ocm.toDTO());
                    } else {
                        failedScDTOs.add(ocm.toFailedDTO(3));
                    }
                    first = false;
                }
            });
            dto.servletContextDTOs = scDTOs.values().toArray(new ServletContextDTO[0]);
            dto.failedServletContextDTOs = failedScDTOs.toArray(new FailedServletContextDTO[0]);
            IdentityHashMap scErrorPages = new IdentityHashMap();
            IdentityHashMap scFilters = new IdentityHashMap();
            IdentityHashMap scListeners = new IdentityHashMap();
            ArrayList preprocessorDTOs = new ArrayList();
            IdentityHashMap scResources = new IdentityHashMap();
            IdentityHashMap scServlets = new IdentityHashMap();
            for (ServletContextDTO scDTO : dto.servletContextDTOs) {
                scErrorPages.put(scDTO, new ArrayList());
                scFilters.put(scDTO, new ArrayList());
                scListeners.put(scDTO, new ArrayList());
                scResources.put(scDTO, new ArrayList());
                scServlets.put(scDTO, new ArrayList());
            }
            ArrayList failedErrorPageDTOs = new ArrayList();
            ArrayList failedFilterDTOs = new ArrayList();
            ArrayList failedListenerDTOs = new ArrayList();
            ArrayList failedPreprocessorDTOs = new ArrayList();
            ArrayList failedResourceDTOs = new ArrayList();
            ArrayList failedServletDTOs = new ArrayList();
            this.servletsForDTO.forEach(sm -> {
                if (sm.isNotMatched()) {
                    return;
                }
                if (sm.isResourceServlet()) {
                    if (!sm.isValid()) {
                        failedResourceDTOs.add(sm.toFailedResourceDTO(sm.getDtoFailureCode()));
                        return;
                    }
                } else {
                    if (!sm.isValid()) {
                        failedServletDTOs.add(sm.toFailedServletDTO(sm.getDtoFailureCode()));
                        return;
                    }
                    ErrorPageModel epm = sm.getErrorPageModel();
                    if (!(epm == null || epm.isValid() && epm.getDtoFailureCode() == -1)) {
                        failedErrorPageDTOs.add(epm.toFailedDTO((ServletModel)sm, epm.getDtoFailureCode()));
                        return;
                    }
                }
                sm.getContextModels().forEach(ocm -> {
                    if (sm.isResourceServlet()) {
                        ((List)scResources.get(scDTOs.get(ocm))).add(sm.toResourceDTO());
                    } else {
                        if (!sm.isErrorPagesOnly()) {
                            ((List)scServlets.get(scDTOs.get(ocm))).add(sm.toServletDTO());
                        }
                        if (sm.getErrorPageModel() != null) {
                            ((List)scErrorPages.get(scDTOs.get(ocm))).add(sm.getErrorPageModel().toDTO((ServletModel)sm));
                        }
                    }
                });
            });
            this.disabledServletModels.forEach(sm -> {
                if (sm.isResourceServlet()) {
                    failedResourceDTOs.add(sm.toFailedResourceDTO(3));
                } else {
                    failedServletDTOs.add(sm.toFailedServletDTO(3));
                    if (sm.getErrorPageModel() != null) {
                        failedErrorPageDTOs.add(sm.getErrorPageModel().toFailedDTO((ServletModel)sm, 3));
                    }
                }
            });
            this.disabledErrorPageModels.forEach(epm -> failedErrorPageDTOs.add(epm.toFailedDTO(null, 3)));
            this.filtersForDTO.forEach(fm -> {
                if (!fm.isValid()) {
                    if (fm.isPreprocessor()) {
                        failedPreprocessorDTOs.add(fm.toFailedPreprocessorDTO(fm.getDtoFailureCode()));
                    } else {
                        failedFilterDTOs.add(fm.toFailedFilterDTO(fm.getDtoFailureCode()));
                    }
                } else {
                    fm.getContextModels().forEach(ocm -> {
                        if (fm.isPreprocessor()) {
                            preprocessorDTOs.add(fm.toPreprocessorDTO());
                        } else {
                            ((List)scFilters.get(scDTOs.get(ocm))).add(fm.toFilterDTO());
                        }
                    });
                }
            });
            this.disabledFilterModels.forEach(fm -> {
                if (fm.isPreprocessor()) {
                    failedPreprocessorDTOs.add(fm.toFailedPreprocessorDTO(3));
                } else {
                    failedFilterDTOs.add(fm.toFailedFilterDTO(3));
                }
            });
            this.eventListenersForDTO.forEach(lm -> {
                if (!lm.isValid()) {
                    failedListenerDTOs.add(lm.toFailedDTO(lm.getDtoFailureCode()));
                } else {
                    lm.getContextModels().forEach(ocm -> ((List)scListeners.get(scDTOs.get(ocm))).add(lm.toDTO()));
                }
            });
            this.failedWhiteboardElements.forEach(em -> {
                if (em instanceof ErrorPageModel) {
                    failedErrorPageDTOs.add(((ErrorPageModel)em).toFailedDTO(null, em.getDtoFailureCode()));
                } else if (em instanceof FilterModel) {
                    if (((FilterModel)em).isPreprocessor()) {
                        failedPreprocessorDTOs.add(((FilterModel)em).toFailedPreprocessorDTO(em.getDtoFailureCode()));
                    } else {
                        failedFilterDTOs.add(((FilterModel)em).toFailedFilterDTO(em.getDtoFailureCode()));
                    }
                } else if (em instanceof EventListenerModel) {
                    failedListenerDTOs.add(((EventListenerModel)em).toFailedDTO(em.getDtoFailureCode()));
                } else if (em instanceof ServletModel) {
                    if (((ServletModel)em).isResourceServlet()) {
                        failedResourceDTOs.add(((ServletModel)em).toFailedResourceDTO(em.getDtoFailureCode()));
                    } else {
                        failedServletDTOs.add(((ServletModel)em).toFailedServletDTO(em.getDtoFailureCode()));
                        if (((ServletModel)em).getErrorPageModel() != null) {
                            failedErrorPageDTOs.add(((ServletModel)em).getErrorPageModel().toFailedDTO((ServletModel)em, ((ServletModel)em).getErrorPageModel().getDtoFailureCode()));
                        }
                    }
                }
            });
            for (ServletContextDTO scDTO : dto.servletContextDTOs) {
                for (ErrorPageDTO errorPageDTO : scDTO.errorPageDTOs = ((List)scErrorPages.get(scDTO)).toArray(new ErrorPageDTO[0])) {
                    errorPageDTO.servletContextId = scDTO.serviceId;
                }
                scDTO.filterDTOs = ((List)scFilters.get(scDTO)).toArray(new FilterDTO[0]);
                for (ErrorPageDTO errorPageDTO : scDTO.filterDTOs) {
                    errorPageDTO.servletContextId = scDTO.serviceId;
                }
                scDTO.listenerDTOs = ((List)scListeners.get(scDTO)).toArray(new ListenerDTO[0]);
                for (ErrorPageDTO errorPageDTO : scDTO.listenerDTOs) {
                    errorPageDTO.servletContextId = scDTO.serviceId;
                }
                scDTO.servletDTOs = ((List)scServlets.get(scDTO)).toArray(new ServletDTO[0]);
                for (ErrorPageDTO errorPageDTO : scDTO.servletDTOs) {
                    errorPageDTO.servletContextId = scDTO.serviceId;
                }
                scDTO.resourceDTOs = ((List)scResources.get(scDTO)).toArray(new ResourceDTO[0]);
                for (ErrorPageDTO errorPageDTO : scDTO.resourceDTOs) {
                    errorPageDTO.servletContextId = scDTO.serviceId;
                }
            }
            dto.failedErrorPageDTOs = failedErrorPageDTOs.toArray(new FailedErrorPageDTO[0]);
            dto.failedFilterDTOs = failedFilterDTOs.toArray(new FailedFilterDTO[0]);
            dto.preprocessorDTOs = preprocessorDTOs.toArray(new PreprocessorDTO[0]);
            dto.failedPreprocessorDTOs = failedPreprocessorDTOs.toArray(new FailedPreprocessorDTO[0]);
            dto.failedListenerDTOs = failedListenerDTOs.toArray(new FailedListenerDTO[0]);
            dto.failedResourceDTOs = failedResourceDTOs.toArray(new FailedResourceDTO[0]);
            dto.failedServletDTOs = failedServletDTOs.toArray(new FailedServletDTO[0]);
            return dto;
        }, false);
    }

    public RequestInfoDTO calculateRequestInfoDTO(String path) {
        return this.runSilently(() -> {
            RequestInfoDTO dto = new RequestInfoDTO();
            dto.path = path;
            RuntimeDTO runtimeDTO = this.getRuntimeDTO();
            TreeSet<ServletContextDTO> orderedServletContexts = new TreeSet<ServletContextDTO>(new ContextComparator());
            Collections.addAll(orderedServletContexts, runtimeDTO.servletContextDTOs);
            for (ServletContextDTO scdto : orderedServletContexts) {
                if (!path.startsWith(scdto.contextPath)) continue;
                Object remaining = path.substring(scdto.contextPath.length());
                if (!"/".equals(scdto.contextPath) && !"".equals(remaining) && !((String)remaining).startsWith("/")) continue;
                dto.servletContextId = scdto.serviceId;
                remaining = path.substring(scdto.contextPath.length());
                if (((String)remaining).contains("?")) {
                    remaining = ((String)remaining).substring(0, ((String)remaining).indexOf("?"));
                }
                if (!((String)remaining).startsWith("/")) {
                    remaining = "/" + (String)remaining;
                }
                TreeMap<String, ServletDTO> orderedMappings = new TreeMap<String, ServletDTO>(new PatternComparator());
                for (ServletDTO servletDTO : scdto.servletDTOs) {
                    for (String p : servletDTO.patterns) {
                        orderedMappings.put(p, servletDTO);
                    }
                }
                for (ServletDTO servletDTO : scdto.resourceDTOs) {
                    for (String p : servletDTO.patterns) {
                        orderedMappings.put(p, servletDTO);
                    }
                }
                for (Map.Entry entry : orderedMappings.entrySet()) {
                    String mapping = (String)entry.getKey();
                    DTO dTO = (DTO)entry.getValue();
                    boolean match = false;
                    if (!"/".equals(mapping)) {
                        if (!mapping.contains("*") && mapping.equals(remaining)) {
                            match = true;
                        } else if (mapping.contains("*")) {
                            if (mapping.endsWith("/*") && ((String)remaining).startsWith(mapping.substring(0, mapping.length() - 2))) {
                                match = true;
                            } else if (mapping.startsWith("*.") && ((String)remaining).endsWith(mapping.substring(1))) {
                                match = true;
                            }
                        }
                    } else {
                        match = true;
                    }
                    if (!match) continue;
                    if (dTO instanceof ResourceDTO) {
                        dto.resourceDTO = (ResourceDTO)dTO;
                        break;
                    }
                    dto.servletDTO = (ServletDTO)dTO;
                    break;
                }
                String targetName = null;
                if (dto.servletDTO != null) {
                    targetName = dto.servletDTO.name;
                } else if (dto.resourceDTO != null) {
                    targetName = DEFAULT_VIRTUAL_HOST;
                }
                ArrayList<FilterDTO> arrayList = new ArrayList<FilterDTO>();
                block6: for (FilterDTO fdto2 : scdto.filterDTOs) {
                    boolean match;
                    if (fdto2.servletNames != null) {
                        match = false;
                        for (String sn : fdto2.servletNames) {
                            if (sn == null || !sn.equals(targetName)) continue;
                            arrayList.add(fdto2);
                            match = true;
                            break;
                        }
                        if (match) continue;
                    }
                    if (fdto2.patterns != null) {
                        match = false;
                        for (String p : fdto2.patterns) {
                            if (!p.contains("*") && p.equals(remaining)) {
                                match = true;
                            } else if ("".equals(p) && "/".equals(remaining)) {
                                match = true;
                            } else if (p.contains("*")) {
                                if (p.endsWith("/*") && ((String)remaining).startsWith(p.substring(0, p.length() - 2))) {
                                    match = true;
                                } else if (p.startsWith("*.") && ((String)remaining).endsWith(p.substring(1))) {
                                    match = true;
                                }
                            }
                            if (!match) continue;
                            arrayList.add(fdto2);
                            break;
                        }
                        if (match) continue;
                    }
                    if (fdto2.regexs == null) continue;
                    match = false;
                    for (String p : fdto2.regexs) {
                        Pattern re = Pattern.compile(p);
                        if (!re.matcher((CharSequence)remaining).matches()) continue;
                        arrayList.add(fdto2);
                        continue block6;
                    }
                }
                dto.filterDTOs = (FilterDTO[])arrayList.stream().filter(fdto -> {
                    if (fdto.dispatcher == null || fdto.dispatcher.length == 0) {
                        return true;
                    }
                    for (String d : fdto.dispatcher) {
                        if (!"REQUEST".equals(d)) continue;
                        return true;
                    }
                    return false;
                }).toArray(FilterDTO[]::new);
                break;
            }
            return dto;
        }, false);
    }

    @Override
    public void collectWebApplications(Set<WebApplicationInfo> webapps) {
        this.bundleDefaultContexts.values().forEach(ocm -> webapps.add(new WebApplicationInfo((OsgiContextModel)ocm, true)));
        this.bundleContexts.values().forEach(ocms -> ocms.forEach(ocm -> {
            if (!ocm.isWab()) {
                webapps.add(new WebApplicationInfo((OsgiContextModel)ocm));
            }
        }));
        this.sharedDefaultContexts.values().forEach(ocm -> webapps.add(new WebApplicationInfo((OsgiContextModel)ocm, true)));
        this.sharedContexts.values().forEach(ocms -> ocms.forEach(ocm -> webapps.add(new WebApplicationInfo((OsgiContextModel)ocm))));
        this.whiteboardContexts.values().stream().flatMap(Collection::stream).forEach(ocm -> webapps.add(new WebApplicationInfo((OsgiContextModel)ocm)));
        this.plugins.forEach(plugin -> plugin.collectWebApplications(webapps));
    }

    @Override
    public WebApplicationInfo getWebApplication(String contextPath) {
        for (ReportViewPlugin plugin : this.plugins) {
            WebApplicationInfo app = plugin.getWebApplication(contextPath);
            if (app == null) continue;
            return app;
        }
        return null;
    }

    @Override
    public WebApplicationInfo getWebApplication(long bundleId) {
        for (ReportViewPlugin plugin : this.plugins) {
            WebApplicationInfo app = plugin.getWebApplication(bundleId);
            if (app == null) continue;
            return app;
        }
        return null;
    }

    @Override
    public void collectServlets(Set<ServletInfo> servlets) {
        for (ServletModel s : this.servletsForDTO) {
            servlets.add(new ServletInfo(s));
        }
    }

    public void registerReportViewPlugin(ReportViewPlugin plugin) {
        this.plugins.add(plugin);
    }

    public void unregisterReportViewPlugin(ReportViewPlugin plugin) {
        this.plugins.remove(plugin);
    }

    public void setHttpServiceRuntimeInformation(ServiceRegistration<HttpServiceRuntime> httpServiceRuntimeReg, ServiceReferenceDTO httpServiceRuntimeDTO) {
        this.httpServiceRuntimeReg = httpServiceRuntimeReg;
        this.httpServiceRuntimeDTO = httpServiceRuntimeDTO;
    }

    public ServiceRegistration<HttpServiceRuntime> getHttpServiceRuntimeReg() {
        return this.httpServiceRuntimeReg;
    }

    public ServiceReferenceDTO getHttpServiceRuntimeDTO() {
        return this.httpServiceRuntimeDTO;
    }

    public Set<OsgiContextModel> getAllWhiteboardContexts() {
        return this.whiteboardContexts.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public void addWhiteboardContext(OsgiContextModel ocm) {
        this.whiteboardContexts.computeIfAbsent(ocm.getName(), cp -> new TreeSet()).add(ocm);
    }

    public void removeWhiteboardContext(OsgiContextModel ocm) {
        TreeSet<OsgiContextModel> models = this.whiteboardContexts.get(ocm.getContextPath());
        if (models != null) {
            models.remove(ocm);
            if (models.isEmpty()) {
                this.whiteboardContexts.remove(ocm.getContextPath());
            } else {
                OsgiContextModel next = models.iterator().next();
                if (next.getDtoFailureCode() == 3) {
                    next.setDtoFailureCode(-1);
                }
            }
        }
    }

    public Set<ElementModel<?, ?>> getFailedWhiteboardElements() {
        return this.failedWhiteboardElements;
    }

    public boolean matchesRuntime(ServiceReference<?> ref) {
        if (ref == null || this.context == null) {
            return true;
        }
        Object targetSelector = ref.getProperty("osgi.http.whiteboard.target");
        if (targetSelector instanceof String) {
            try {
                Filter f = this.context.createFilter((String)targetSelector);
                if (f.matches(this.httpServiceRuntimeDTO.properties)) {
                    return true;
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        } else {
            return true;
        }
        return false;
    }

    public void addNotMatchedModel(ServletModel model) {
        this.servletsForDTO.add(model);
    }

    private static /* synthetic */ void lambda$visitClearDynamicRegistrationsChange$70(FilterModel model, ServletContextModel sc) {
        sc.getFilterNameMapping().remove(model.getName(), model);
    }

    private /* synthetic */ void lambda$visitClearDynamicRegistrationsChange$69(ServletModel model, ServletContextModel sc) {
        sc.getServletNameMapping().remove(model.getName(), model);
        if (model.getAlias() != null) {
            sc.getAliasMapping().remove(model.getAlias(), model);
        }
        Arrays.stream(model.getUrlPatterns()).forEach(p -> sc.getServletUrlPatternMapping().remove(p, model));
        ErrorPageModel epModel = model.getErrorPageModel();
        if (epModel != null && epModel.isValid()) {
            this.disabledErrorPageModels.remove(epModel);
            for (String page : epModel.getErrorPages()) {
                sc.getErrorPageMapping().remove(page, epModel);
            }
        }
    }

    private static class ContextComparator
    implements Comparator<ServletContextDTO> {
        private ContextComparator() {
        }

        @Override
        public int compare(ServletContextDTO o1, ServletContextDTO o2) {
            long slashes2;
            String cp1 = o1.contextPath;
            String cp2 = o2.contextPath;
            long slashes1 = cp1.codePoints().mapToObj(cp -> Character.valueOf((char)cp)).filter(c -> c.charValue() == '/').count();
            if (slashes1 != (slashes2 = cp2.codePoints().mapToObj(cp -> Character.valueOf((char)cp)).filter(c -> c.charValue() == '/').count())) {
                return Long.compare(slashes2, slashes1);
            }
            if (cp1.length() != cp2.length()) {
                return Integer.compare(cp2.length(), cp1.length());
            }
            if (o1 instanceof OsgiContextModel.RankedServletContextDTO && o2 instanceof OsgiContextModel.RankedServletContextDTO) {
                OsgiContextModel.RankedServletContextDTO ro1 = (OsgiContextModel.RankedServletContextDTO)o1;
                OsgiContextModel.RankedServletContextDTO ro2 = (OsgiContextModel.RankedServletContextDTO)o2;
                if (ro1.rank != ro2.rank) {
                    return ro1.rank < ro2.rank ? 1 : -1;
                }
            }
            if (o1.serviceId != o2.serviceId) {
                return o1.serviceId < o2.serviceId ? -1 : 1;
            }
            return cp1.compareTo(cp2);
        }
    }

    private static class PatternComparator
    implements Comparator<String> {
        private PatternComparator() {
        }

        @Override
        public int compare(String p1, String p2) {
            long slashes1 = p1.codePoints().mapToObj(cp -> Character.valueOf((char)cp)).filter(c -> c.charValue() == '/').count();
            long slashes2 = p2.codePoints().mapToObj(cp -> Character.valueOf((char)cp)).filter(c -> c.charValue() == '/').count();
            if ("/".equals(p1)) {
                return 1;
            }
            if ("/".equals(p2)) {
                return -1;
            }
            if (slashes1 != slashes2) {
                return Long.compare(slashes2, slashes1);
            }
            if (p1.contains("*") && p2.contains("*")) {
                if (p1.length() != p2.length()) {
                    return Integer.compare(p2.length(), p1.length());
                }
                return p1.compareTo(p2);
            }
            if (p1.contains("*")) {
                return 1;
            }
            if (p2.contains("*")) {
                return 1;
            }
            if (p1.length() != p2.length()) {
                return Integer.compare(p2.length(), p1.length());
            }
            return p1.compareTo(p2);
        }
    }
}

