/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.context;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.context.UniqueWebContainerContextWrapper;
import org.ops4j.pax.web.service.spi.util.Path;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpContext
implements WebContainerContext {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpContext.class);
    protected final Bundle bundle;
    protected final String contextId;

    public DefaultHttpContext(Bundle bundle) {
        this.bundle = bundle;
        this.contextId = "default";
    }

    public DefaultHttpContext(Bundle bundle, String contextId) {
        this.bundle = bundle;
        this.contextId = contextId == null || contextId.trim().equals("") ? "default" : contextId;
    }

    protected DefaultHttpContext(String contextId) {
        this.bundle = null;
        this.contextId = contextId;
    }

    public boolean isShared() {
        return false;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return true;
    }

    public void finishSecurity(HttpServletRequest request, HttpServletResponse response) {
    }

    public URL getResource(String name) {
        return this.getResource(this.bundle, name);
    }

    public String getMimeType(String name) {
        return null;
    }

    public Set<String> getResourcePaths(String name) {
        return this.getResourcePaths(this.bundle, name);
    }

    public String getContextId() {
        return this.contextId;
    }

    public String toString() {
        return "DefaultHttpContext{bundle=" + String.valueOf(this.bundle) + ",contextId='" + this.contextId + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UniqueWebContainerContextWrapper) {
            o = ((UniqueWebContainerContextWrapper)o).getDelegate();
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultHttpContext that = (DefaultHttpContext)o;
        return this.bundle.equals(that.bundle) && this.contextId.equals(that.contextId);
    }

    public int hashCode() {
        return Objects.hash(this.bundle, this.contextId);
    }

    protected URL getResource(Bundle bundle, String name) {
        String normalizedName = Path.normalizeResourcePath(name);
        LOG.trace("Searching bundle [" + String.valueOf(bundle) + "] for resource [" + normalizedName + "]");
        return bundle.getResource(normalizedName);
    }

    protected Set<String> getResourcePaths(Bundle bundle, String name) {
        String normalizedName = Path.normalizeResourcePath(name);
        LOG.trace("Searching bundle [" + String.valueOf(bundle) + "] for resource paths of [" + normalizedName + "]");
        if (normalizedName != null && bundle != null) {
            int state = bundle.getState();
            if (state == 2 || state == 16 || state == 1) {
                return null;
            }
            Enumeration e = bundle.findEntries(normalizedName, null, false);
            if (e != null) {
                LinkedHashSet<String> result = new LinkedHashSet<String>();
                while (e.hasMoreElements()) {
                    String path = ((URL)e.nextElement()).getPath();
                    result.add(path);
                }
                return result;
            }
        }
        return null;
    }
}

