/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import jakarta.servlet.Filter;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletException;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.descriptor.JspPropertyGroupDescriptor;
import jakarta.servlet.descriptor.TaglibDescriptor;
import java.util.Collection;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.List;
import org.ops4j.pax.web.service.MultiBundleWebContainerContext;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.http.HttpContext;
import org.ops4j.pax.web.service.http.NamespaceException;
import org.ops4j.pax.web.service.internal.HttpServiceDisabled;
import org.ops4j.pax.web.service.internal.StoppableHttpService;
import org.ops4j.pax.web.service.views.PaxWebContainerView;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpServiceProxy
implements WebContainer,
StoppableHttpService {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServiceProxy.class);
    private volatile WebContainer delegate;
    private final Bundle serviceBundle;

    HttpServiceProxy(Bundle serviceBundle, WebContainer delegate) {
        LOG.debug("HttpServiceProxy created for {}", (Object)delegate);
        this.serviceBundle = serviceBundle;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.delegate instanceof StoppableHttpService) {
            StoppableHttpService stopping;
            LOG.debug("Stopping http service: {}", (Object)this.delegate);
            HttpServiceProxy httpServiceProxy = this;
            synchronized (httpServiceProxy) {
                stopping = (StoppableHttpService)this.delegate;
                this.delegate = new HttpServiceDisabled(this.serviceBundle);
            }
            if (stopping != null) {
                stopping.stop();
            }
        } else {
            LOG.warn("Http service has already been stopped");
        }
    }

    public <T extends PaxWebContainerView> T adapt(Class<T> type) {
        return (T)this.delegate.adapt(type);
    }

    public HttpContext createDefaultHttpContext() {
        return this.delegate.createDefaultHttpContext();
    }

    public HttpContext createDefaultHttpContext(String contextId) {
        return this.delegate.createDefaultHttpContext(contextId);
    }

    public MultiBundleWebContainerContext createDefaultSharedHttpContext() {
        return this.delegate.createDefaultSharedHttpContext();
    }

    public MultiBundleWebContainerContext createDefaultSharedHttpContext(String contextId) {
        return this.delegate.createDefaultSharedHttpContext(contextId);
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary<?, ?> initParams, HttpContext httpContext) throws ServletException, NamespaceException {
        this.delegate.registerServlet(alias, servlet, initParams, httpContext);
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary<?, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException, NamespaceException {
        this.delegate.registerServlet(alias, servlet, initParams, loadOnStartup, asyncSupported, httpContext);
    }

    public void registerServlet(Servlet servlet, String[] urlPatterns, Dictionary<String, String> initParams, HttpContext httpContext) throws ServletException {
        this.delegate.registerServlet(servlet, urlPatterns, initParams, httpContext);
    }

    public void registerServlet(Servlet servlet, String[] urlPatterns, Dictionary<String, String> initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException {
        this.delegate.registerServlet(servlet, urlPatterns, initParams, loadOnStartup, asyncSupported, httpContext);
    }

    public void registerServlet(Servlet servlet, String servletName, String[] urlPatterns, Dictionary<String, String> initParams, HttpContext httpContext) throws ServletException {
        this.delegate.registerServlet(servlet, servletName, urlPatterns, initParams, httpContext);
    }

    public void registerServlet(Servlet servlet, String servletName, String[] urlPatterns, Dictionary<String, String> initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException {
        this.delegate.registerServlet(servlet, servletName, urlPatterns, initParams, loadOnStartup, asyncSupported, httpContext);
    }

    public void registerServlet(Servlet servlet, String servletName, String[] urlPatterns, Dictionary<String, String> initParams, Integer loadOnStartup, Boolean asyncSupported, MultipartConfigElement multiPartConfig, HttpContext httpContext) throws ServletException {
        this.delegate.registerServlet(servlet, servletName, urlPatterns, initParams, loadOnStartup, asyncSupported, multiPartConfig, httpContext);
    }

    public void registerServlet(Class<? extends Servlet> servletClass, String[] urlPatterns, Dictionary<String, String> initParams, HttpContext httpContext) throws ServletException {
        this.delegate.registerServlet(servletClass, urlPatterns, initParams, httpContext);
    }

    public void registerServlet(Class<? extends Servlet> servletClass, String[] urlPatterns, Dictionary<String, String> initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException {
        this.delegate.registerServlet(servletClass, urlPatterns, initParams, loadOnStartup, asyncSupported, httpContext);
    }

    public void registerServlet(Class<? extends Servlet> servletClass, String[] urlPatterns, Dictionary<String, String> initParams, Integer loadOnStartup, Boolean asyncSupported, MultipartConfigElement multiPartConfig, HttpContext httpContext) throws ServletException {
        this.delegate.registerServlet(servletClass, urlPatterns, initParams, loadOnStartup, asyncSupported, multiPartConfig, httpContext);
    }

    public void unregister(String alias) {
        this.delegate.unregister(alias);
    }

    public void unregisterServlet(Servlet servlet) {
        this.delegate.unregisterServlet(servlet);
    }

    public void unregisterServlet(String servletName) {
        this.delegate.unregisterServlet(servletName);
    }

    public void unregisterServlets(Class<? extends Servlet> servletClass) {
        this.delegate.unregisterServlets(servletClass);
    }

    public void registerResources(String alias, String name, HttpContext context) throws NamespaceException {
        this.delegate.registerResources(alias, name, context);
    }

    public void registerFilter(Filter filter, String[] urlPatterns, String[] servletNames, Dictionary<String, String> initParams, HttpContext httpContext) throws ServletException {
        this.delegate.registerFilter(filter, urlPatterns, servletNames, initParams, httpContext);
    }

    public void registerFilter(Filter filter, String filterName, String[] urlPatterns, String[] servletNames, Dictionary<String, String> initParams, Boolean asyncSupported, HttpContext httpContext) throws ServletException {
        this.delegate.registerFilter(filter, filterName, urlPatterns, servletNames, initParams, asyncSupported, httpContext);
    }

    public void registerFilter(Class<? extends Filter> filterClass, String[] urlPatterns, String[] servletNames, Dictionary<String, String> initParams, HttpContext httpContext) throws ServletException {
        this.delegate.registerFilter(filterClass, urlPatterns, servletNames, initParams, httpContext);
    }

    public void registerFilter(Class<? extends Filter> filterClass, String filterName, String[] urlPatterns, String[] servletNames, Dictionary<String, String> initParams, Boolean asyncSupported, HttpContext httpContext) throws ServletException {
        this.delegate.registerFilter(filterClass, filterName, urlPatterns, servletNames, initParams, asyncSupported, httpContext);
    }

    public void unregisterFilter(Filter filter) {
        this.delegate.unregisterFilter(filter);
    }

    public void unregisterFilter(String filterName) {
        this.delegate.unregisterFilter(filterName);
    }

    public void unregisterFilters(Class<? extends Filter> filterClass) {
        this.delegate.unregisterFilters(filterClass);
    }

    public void registerEventListener(EventListener listener, HttpContext httpContext) {
        this.delegate.registerEventListener(listener, httpContext);
    }

    public void unregisterEventListener(EventListener listener) {
        this.delegate.unregisterEventListener(listener);
    }

    public void registerWelcomeFiles(String[] welcomeFiles, boolean redirect, HttpContext httpContext) {
        this.delegate.registerWelcomeFiles(welcomeFiles, redirect, httpContext);
    }

    public void unregisterWelcomeFiles(String[] welcomeFiles, HttpContext httpContext) {
        this.delegate.unregisterWelcomeFiles(welcomeFiles, httpContext);
    }

    public void registerErrorPage(String error, String location, HttpContext httpContext) {
        this.delegate.registerErrorPage(error, location, httpContext);
    }

    public void registerErrorPages(String[] errors, String location, HttpContext httpContext) {
        this.delegate.registerErrorPages(errors, location, httpContext);
    }

    public void unregisterErrorPage(String error, HttpContext httpContext) {
        this.delegate.unregisterErrorPage(error, httpContext);
    }

    public void unregisterErrorPages(String[] errors, HttpContext httpContext) {
        this.delegate.unregisterErrorPages(errors, httpContext);
    }

    public void registerJsps(String[] urlPatterns, Dictionary<String, String> initParams, HttpContext httpContext) {
        this.delegate.registerJsps(urlPatterns, initParams, httpContext);
    }

    public void registerJspServlet(String jspFile, String[] urlPatterns, Dictionary<String, String> initParams, HttpContext httpContext) {
        this.delegate.registerJspServlet(jspFile, urlPatterns, initParams, httpContext);
    }

    public void registerJspConfigTagLibs(String tagLibLocation, String tagLibUri, HttpContext httpContext) {
        this.delegate.registerJspConfigTagLibs(tagLibLocation, tagLibUri, httpContext);
    }

    public void registerJspConfigTagLibs(Collection<TaglibDescriptor> tagLibs, HttpContext httpContext) {
        this.delegate.registerJspConfigTagLibs(tagLibs, httpContext);
    }

    public void registerJspConfigPropertyGroup(List<String> includeCodas, List<String> includePreludes, List<String> urlPatterns, Boolean elIgnored, Boolean scriptingInvalid, Boolean isXml, HttpContext httpContext) {
        this.delegate.registerJspConfigPropertyGroup(includeCodas, includePreludes, urlPatterns, elIgnored, scriptingInvalid, isXml, httpContext);
    }

    public void registerJspConfigPropertyGroup(JspPropertyGroupDescriptor descriptor, HttpContext httpContext) {
        this.delegate.registerJspConfigPropertyGroup(descriptor, httpContext);
    }

    public void unregisterJsps(HttpContext httpContext) {
        this.delegate.unregisterJsps(httpContext);
    }

    public void unregisterJspServlet(String jspFile, HttpContext httpContext) {
        this.delegate.unregisterJspServlet(jspFile, httpContext);
    }

    public void registerServletContainerInitializer(ServletContainerInitializer initializer, Class<?>[] classes, HttpContext httpContext) {
        this.delegate.registerServletContainerInitializer(initializer, (Class[])classes, httpContext);
    }

    public void unregisterServletContainerInitializer(ServletContainerInitializer initializer, HttpContext httpContext) {
        this.delegate.unregisterServletContainerInitializer(initializer, httpContext);
    }

    public void setSessionTimeout(Integer minutes, HttpContext httpContext) {
        this.delegate.setSessionTimeout(minutes, httpContext);
    }

    public void setSessionCookieConfig(String domain, String name, Boolean httpOnly, Boolean secure, String path, Integer maxAge, HttpContext httpContext) {
        this.delegate.setSessionCookieConfig(domain, name, httpOnly, secure, path, maxAge, httpContext);
    }

    public void setSessionCookieConfig(SessionCookieConfig config, HttpContext httpContext) {
        this.delegate.setSessionCookieConfig(config, httpContext);
    }

    public void setContextParams(Dictionary<String, Object> params, HttpContext httpContext) {
        this.delegate.setContextParams(params, httpContext);
    }

    public void registerWebSocket(Object webSocket, HttpContext httpContext) {
        this.delegate.registerWebSocket(webSocket, httpContext);
    }

    public void unregisterWebSocket(Object webSocket, HttpContext httpContext) {
        this.delegate.unregisterWebSocket(webSocket, httpContext);
    }

    public void registerLoginConfig(String authMethod, String realmName, String formLoginPage, String formErrorPage, HttpContext httpContext) {
        this.delegate.registerLoginConfig(authMethod, realmName, formLoginPage, formErrorPage, httpContext);
    }

    public void registerConstraintMapping(String constraintName, String httpMethod, String url, String dataConstraint, boolean authentication, List<String> roles, HttpContext httpContext) {
        this.delegate.registerConstraintMapping(constraintName, httpMethod, url, dataConstraint, authentication, roles, httpContext);
    }

    public void unregisterLoginConfig(HttpContext httpContext) {
        this.delegate.unregisterLoginConfig(httpContext);
    }

    public void unregisterConstraintMapping(HttpContext httpContext) {
        this.delegate.unregisterConstraintMapping(httpContext);
    }

    public String toString() {
        return "Proxy for " + this.delegate.toString();
    }
}

