/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import jakarta.servlet.annotation.ServletSecurity;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.apache.tomcat.util.descriptor.web.WebXml;
import org.apache.tomcat.util.descriptor.web.WebXmlParser;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.internal.views.ProcessingWebContainerView;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.LoginConfigModel;
import org.ops4j.pax.web.service.spi.model.elements.SecurityConstraintModel;
import org.ops4j.pax.web.service.spi.task.Batch;
import org.ops4j.pax.web.service.spi.task.ContextParamsChange;
import org.ops4j.pax.web.service.spi.task.ContextStartChange;
import org.ops4j.pax.web.service.spi.task.ContextStopChange;
import org.ops4j.pax.web.service.spi.task.OpCode;
import org.ops4j.pax.web.service.spi.task.SecurityConfigChange;
import org.ops4j.pax.web.service.spi.util.NamedThreadFactory;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpContextProcessing
implements ManagedServiceFactory {
    public static final Logger LOG = LoggerFactory.getLogger(HttpContextProcessing.class);
    public static final String PID = "org.ops4j.pax.web.context";
    private static final String KEY_CONTEXT_ID = "context.id";
    private static final String KEY_BUNDLE_SN = "bundle.symbolicName";
    private static final String KEY_WEB_FRAGMENT = "context.webFragment";
    private static final String KEY_WHITEBOARD = "whiteboard";
    private static final String PREFIX_CONTEXT_PARAM = "context.param.";
    private static final String PREFIX_LOGIN_CONFIG = "login.config.";
    private static final String PREFIX_SECURITY = "security.";
    private static final String PREFIX_SECURITY_ROLE = "security.roles";
    private final ExecutorService configExecutor = new ThreadPoolExecutor(0, 1, 20L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("paxweb-context"));
    private final BundleContext serviceContext;
    private final ConcurrentMap<String, HttpContextTracker> httpContextTrackers = new ConcurrentHashMap<String, HttpContextTracker>();

    public HttpContextProcessing(BundleContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public String getName() {
        return PID;
    }

    public void updated(String pid, Dictionary<String, ?> properties) {
        LOG.info("Updated configuration for pid={}", (Object)pid);
        this.configExecutor.submit(new ConfigurationChangeTask(pid, properties));
    }

    public void deleted(String pid) {
        LOG.info("Deleted configuration for pid={}", (Object)pid);
        this.configExecutor.submit(new ConfigurationChangeTask(pid, null));
    }

    public void destroy() {
        this.configExecutor.shutdown();
    }

    private class ConfigurationChangeTask
    implements Runnable {
        private final String pid;
        private final Dictionary<String, ?> properties;

        ConfigurationChangeTask(String pid, Dictionary<String, ?> properties) {
            this.pid = pid;
            this.properties = properties;
        }

        @Override
        public void run() {
            try {
                LOG.debug("Processing {} PID {}", (Object)this.pid, (Object)(this.properties == null ? "removal" : "change"));
                HttpContextTracker p = HttpContextProcessing.this.httpContextTrackers.computeIfAbsent(this.pid, x$0 -> new HttpContextTracker((String)x$0));
                p.reconfigure(this.properties);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private class HttpContextTracker
    implements BundleTrackerCustomizer<Object> {
        private final String pid;
        private Map<String, String> properties;
        private String symbolicName;
        private BundleTracker<?> bundleTracker;
        private Bundle bundle;
        private Version version;
        private String contextId;
        private boolean whiteboard;
        private final Map<String, String> contextParams = new LinkedHashMap<String, String>();
        private LoginConfigModel loginConfiguration;
        private final Set<String> securityRoles = new LinkedHashSet<String>();
        private final List<SecurityConstraintModel> securityMappings = new LinkedList<SecurityConstraintModel>();

        HttpContextTracker(String pid) {
            this.pid = pid;
        }

        public void reconfigure(Dictionary<String, ?> props) {
            if (props == null) {
                HttpContextTracker tracker;
                if (this.bundleTracker != null) {
                    this.bundleTracker.close();
                }
                if ((tracker = (HttpContextTracker)HttpContextProcessing.this.httpContextTrackers.remove(this.pid)) != null && this.symbolicName != null) {
                    HttpContextProcessing.this.configExecutor.execute(tracker::cleanupContext);
                }
                this.properties = null;
            } else {
                if (this.bundleTracker != null) {
                    this.bundleTracker.close();
                    HttpContextProcessing.this.configExecutor.execute(this::cleanupContext);
                }
                if (props.get(HttpContextProcessing.KEY_BUNDLE_SN) == null) {
                    LOG.warn("Incorrect {} configuration - missing {} selector", (Object)this.pid, (Object)HttpContextProcessing.KEY_BUNDLE_SN);
                    return;
                }
                this.properties = Utils.toMap(props);
                this.symbolicName = this.properties.get(HttpContextProcessing.KEY_BUNDLE_SN).trim();
                this.contextId = this.properties.get(HttpContextProcessing.KEY_CONTEXT_ID);
                if (this.contextId == null) {
                    this.contextId = "default";
                }
                this.whiteboard = "true".equalsIgnoreCase(this.properties.get(HttpContextProcessing.KEY_WHITEBOARD));
                if (this.bundleTracker == null) {
                    this.bundleTracker = new BundleTracker(HttpContextProcessing.this.serviceContext, 32, (BundleTrackerCustomizer)this);
                }
                this.bundleTracker.open();
            }
        }

        private void processContext() {
            LoginConfigModel cmLoginConfig;
            OsgiContextModel osgiContextModel = this.getProcessedOsgiContextModel();
            if (osgiContextModel == null) {
                return;
            }
            LOG.info("Customizing {}", (Object)osgiContextModel);
            ProcessingWebContainerView view = this.getProcessingView();
            if (view == null) {
                return;
            }
            Batch batch = new Batch("Processing context \"" + this.contextId + "\" for bundle " + this.bundle.getSymbolicName());
            batch.getOperations().add(new ContextStopChange(OpCode.MODIFY, osgiContextModel));
            String webFragmentLocation = this.properties.get(HttpContextProcessing.KEY_WEB_FRAGMENT);
            if (webFragmentLocation != null && !"".equals(webFragmentLocation.trim())) {
                File f = new File(webFragmentLocation);
                if (!f.isFile()) {
                    LOG.warn("Web Fragment location {} is not accessible. Skipping.", (Object)webFragmentLocation);
                } else {
                    LOG.info("Processing Web Fragment {}", (Object)webFragmentLocation);
                    WebXml fragment = new WebXml();
                    fragment.setDistributable(true);
                    fragment.setOverridable(true);
                    fragment.setAlwaysAddWelcomeFiles(false);
                    fragment.setReplaceWelcomeFiles(true);
                    try {
                        fragment.setURL(f.toURI().toURL());
                        WebXmlParser parser = new WebXmlParser(false, false, true);
                        parser.setClassLoader(WebXmlParser.class.getClassLoader());
                        parser.parseWebXml(fragment.getURL(), fragment, true);
                        this.contextParams.putAll(fragment.getContextParams());
                        this.securityRoles.addAll(fragment.getSecurityRoles());
                        LoginConfig loginConfig = fragment.getLoginConfig();
                        if (loginConfig != null) {
                            this.loginConfiguration = new LoginConfigModel();
                            LOG.info("Registering login configuration in WebContainer for bundle \"" + this.symbolicName + "\": method={}, realm={}", (Object)loginConfig.getAuthMethod(), (Object)loginConfig.getRealmName());
                            this.loginConfiguration.setAuthMethod(loginConfig.getAuthMethod());
                            this.loginConfiguration.setRealmName(loginConfig.getRealmName());
                            this.loginConfiguration.setFormLoginPage(loginConfig.getLoginPage());
                            this.loginConfiguration.setFormErrorPage(loginConfig.getErrorPage());
                        }
                        for (SecurityConstraint sc : fragment.getSecurityConstraints()) {
                            SecurityConstraintModel constraint = new SecurityConstraintModel();
                            constraint.setName(sc.getDisplayName());
                            for (SecurityCollection wrc : sc.findCollections()) {
                                SecurityConstraintModel.WebResourceCollection collection = new SecurityConstraintModel.WebResourceCollection();
                                collection.setName(wrc.getName());
                                collection.getMethods().addAll(Arrays.asList(wrc.findMethods()));
                                collection.getOmittedMethods().addAll(Arrays.asList(wrc.findOmittedMethods()));
                                collection.getPatterns().addAll(Arrays.asList(wrc.findPatterns()));
                                constraint.getWebResourceCollections().add(collection);
                            }
                            constraint.setAuthRolesSet(sc.getAuthConstraint());
                            constraint.getAuthRoles().addAll(Arrays.asList(sc.findAuthRoles()));
                            this.securityRoles.addAll(constraint.getAuthRoles());
                            if (sc.getUserConstraint() != null && !"".equals(sc.getUserConstraint().trim())) {
                                if (ServletSecurity.TransportGuarantee.NONE.toString().equals(sc.getUserConstraint())) {
                                    constraint.setTransportGuarantee(ServletSecurity.TransportGuarantee.NONE);
                                } else {
                                    constraint.setTransportGuarantee(ServletSecurity.TransportGuarantee.CONFIDENTIAL);
                                }
                            }
                            this.securityMappings.add(constraint);
                        }
                    }
                    catch (IOException e) {
                        LOG.warn("Failure parsing default {}: {}", new Object[]{webFragmentLocation, e.getMessage(), e});
                    }
                }
            }
            this.contextParams.putAll(this.collectContextParams(this.properties));
            if (!this.contextParams.isEmpty()) {
                LOG.info("Setting context parameters in {}", (Object)osgiContextModel);
                batch.getOperations().add(new ContextParamsChange(OpCode.ADD, osgiContextModel, this.contextParams));
            }
            if ((cmLoginConfig = this.collectLoginConfiguration(this.properties)) != null) {
                if (this.loginConfiguration == null) {
                    this.loginConfiguration = new LoginConfigModel();
                    LOG.info("Registering login configuration in {}: method={}, realm={}", new Object[]{osgiContextModel, cmLoginConfig.getAuthMethod(), cmLoginConfig.getRealmName()});
                } else {
                    LOG.info("Overriding login configuration in {}: method={}, realm={}", new Object[]{osgiContextModel, cmLoginConfig.getAuthMethod(), cmLoginConfig.getRealmName()});
                }
                this.loginConfiguration.setAuthMethod(cmLoginConfig.getAuthMethod());
                this.loginConfiguration.setRealmName(cmLoginConfig.getRealmName());
                this.loginConfiguration.setFormLoginPage(cmLoginConfig.getFormLoginPage());
                this.loginConfiguration.setFormErrorPage(cmLoginConfig.getFormErrorPage());
            }
            List<SecurityConstraintModel> cmSecurityMappings = this.collectSecurityMappings(this.properties);
            cmSecurityMappings.addAll(this.securityMappings);
            this.securityMappings.clear();
            this.securityMappings.addAll(cmSecurityMappings);
            if (!this.securityMappings.isEmpty()) {
                LOG.info("Registering security mappings in {}", (Object)osgiContextModel);
            }
            batch.getOperations().add(new SecurityConfigChange(OpCode.ADD, osgiContextModel, this.loginConfiguration, this.securityMappings, new ArrayList<String>(this.securityRoles)));
            batch.getOperations().add(new ContextStartChange(OpCode.MODIFY, osgiContextModel));
            view.sendBatch(batch);
        }

        public void cleanupContext() {
            LOG.info("{}: Restoring WebContainer for bundle {}/{}", new Object[]{this, this.symbolicName, this.version});
            OsgiContextModel osgiContextModel = this.getProcessedOsgiContextModel();
            if (osgiContextModel == null) {
                return;
            }
            ProcessingWebContainerView view = this.getProcessingView();
            if (view == null) {
                return;
            }
            Batch batch = new Batch("Processing context \"" + this.contextId + "\" for bundle " + this.bundle.getSymbolicName());
            batch.getOperations().add(new ContextStopChange(OpCode.MODIFY, osgiContextModel));
            batch.getOperations().add(new ContextParamsChange(OpCode.DELETE, osgiContextModel, this.contextParams));
            batch.getOperations().add(new SecurityConfigChange(OpCode.DELETE, osgiContextModel, this.loginConfiguration, this.securityMappings, new ArrayList<String>(this.securityRoles)));
            batch.getOperations().add(new ContextStartChange(OpCode.MODIFY, osgiContextModel));
            view.sendBatch(batch);
        }

        private LoginConfigModel collectLoginConfiguration(Map<String, String> properties) {
            if (properties != null && properties.get("login.config.authMethod") != null) {
                LoginConfigModel lc = new LoginConfigModel();
                lc.setAuthMethod(properties.get("login.config.authMethod"));
                lc.setRealmName(properties.get("login.config.realmName"));
                if (lc.getRealmName() == null) {
                    lc.setRealmName("default");
                }
                lc.setFormLoginPage(properties.get("login.config.formLoginPage"));
                lc.setFormErrorPage(properties.get("login.config.formErrorPage"));
                return lc;
            }
            return null;
        }

        private Map<String, String> collectContextParams(Map<String, String> properties) {
            HashMap<String, String> result = new HashMap<String, String>();
            if (properties != null) {
                for (String k : properties.keySet()) {
                    if (k == null || !k.startsWith(HttpContextProcessing.PREFIX_CONTEXT_PARAM)) continue;
                    String v = properties.get(k);
                    String paramName = k.substring(HttpContextProcessing.PREFIX_CONTEXT_PARAM.length());
                    result.put(paramName, v);
                }
            }
            return result;
        }

        private List<SecurityConstraintModel> collectSecurityMappings(Map<String, String> properties) {
            LinkedList<SecurityConstraintModel> result = new LinkedList<SecurityConstraintModel>();
            if (properties != null) {
                LinkedHashMap<String, SecurityConstraintModel> temp = new LinkedHashMap<String, SecurityConstraintModel>();
                for (String k : properties.keySet()) {
                    String paramName;
                    if (k == null || !k.startsWith(HttpContextProcessing.PREFIX_SECURITY) || !(paramName = k.substring(HttpContextProcessing.PREFIX_SECURITY.length())).contains(".")) continue;
                    String constraintName = paramName.substring(0, paramName.lastIndexOf(46));
                    SecurityConstraintModel model = temp.computeIfAbsent(constraintName, n -> {
                        SecurityConstraintModel scm = new SecurityConstraintModel();
                        scm.setName(constraintName);
                        SecurityConstraintModel.WebResourceCollection collection = new SecurityConstraintModel.WebResourceCollection();
                        collection.setName(constraintName);
                        scm.getWebResourceCollections().add(collection);
                        scm.setAuthRolesSet(true);
                        return scm;
                    });
                    SecurityConstraintModel.WebResourceCollection collection = (SecurityConstraintModel.WebResourceCollection)model.getWebResourceCollections().get(0);
                    String v = properties.get(k);
                    if (paramName.endsWith(".url")) {
                        collection.getPatterns().add(v.trim());
                        continue;
                    }
                    if (paramName.endsWith(".urls")) {
                        collection.getPatterns().addAll(Arrays.asList(v.split("\\s*,\\s*")));
                        continue;
                    }
                    if (paramName.endsWith(".method")) {
                        collection.getMethods().add(v.trim());
                        continue;
                    }
                    if (paramName.endsWith(".methods")) {
                        collection.getMethods().addAll(Arrays.asList(v.split("\\s*,\\s*")));
                        continue;
                    }
                    if (paramName.endsWith(".methodOmissions")) {
                        collection.getOmittedMethods().addAll(Arrays.asList(v.split("\\s*,\\s*")));
                        continue;
                    }
                    if (paramName.endsWith(".roles")) {
                        model.getAuthRoles().addAll(Arrays.asList(v.split("\\s*,\\s*")));
                        continue;
                    }
                    if (!paramName.endsWith(".transportGuarantee")) continue;
                    if (ServletSecurity.TransportGuarantee.CONFIDENTIAL.toString().equalsIgnoreCase(v.trim()) || "INTEGRAL".equalsIgnoreCase(v.trim())) {
                        model.setTransportGuarantee(ServletSecurity.TransportGuarantee.CONFIDENTIAL);
                        continue;
                    }
                    model.setTransportGuarantee(ServletSecurity.TransportGuarantee.NONE);
                }
                result.addAll(temp.values());
            }
            return result;
        }

        private OsgiContextModel getProcessedOsgiContextModel() {
            OsgiContextModel osgiContextModel;
            ProcessingWebContainerView view = this.getProcessingView();
            if (view == null) {
                return null;
            }
            OsgiContextModel osgiContextModel2 = osgiContextModel = this.whiteboard ? view.getContextModel(null, this.contextId) : view.getContextModel(this.bundle, this.contextId);
            if (osgiContextModel == null) {
                if (this.whiteboard) {
                    LOG.warn("Can't find whiteboard OsgiContextModel with name \"{}\"", (Object)this.contextId);
                } else {
                    LOG.warn("Can't find OsgiContextModel with name \"{}\" for bundle {}", (Object)this.contextId, (Object)this.bundle);
                }
                return null;
            }
            return osgiContextModel;
        }

        private ProcessingWebContainerView getProcessingView() {
            WebContainer wc = this.getWebContainer();
            if (wc == null) {
                return null;
            }
            return (ProcessingWebContainerView)wc.adapt(ProcessingWebContainerView.class);
        }

        public Object addingBundle(Bundle bundle, BundleEvent event) {
            if (this.symbolicName.equals(bundle.getSymbolicName())) {
                this.bundle = bundle;
                this.version = bundle.getVersion();
                LOG.info("Found bundle \"" + this.symbolicName + "\", scheduling customization of its WebContainer");
                HttpContextProcessing.this.configExecutor.execute(this::processContext);
            }
            return null;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
            this.bundle = null;
            this.version = null;
        }

        private WebContainer getWebContainer() {
            Bundle currentBundle = this.bundle;
            if (currentBundle == null) {
                LOG.debug("Bundle context for {} bundle is no longer valid", (Object)this.symbolicName);
                return null;
            }
            BundleContext context = currentBundle.getBundleContext();
            if (context == null) {
                LOG.debug("Bundle context for {} bundle is no longer valid", (Object)this.symbolicName);
                return null;
            }
            try {
                ServiceReference sr = context.getServiceReference(WebContainer.class);
                if (sr == null) {
                    LOG.warn("Can't obtain service reference for WebContainer for bundle {}", (Object)this.symbolicName);
                    return null;
                }
                WebContainer wc = (WebContainer)context.getService(sr);
                if (wc == null) {
                    LOG.warn("Can't obtain WebContainer service for bundle {}", (Object)this.symbolicName);
                    return null;
                }
                return wc;
            }
            catch (IllegalStateException e) {
                LOG.debug("Bundle context for {} bundle is no longer valid", (Object)this.symbolicName);
                return null;
            }
        }

        public String toString() {
            return "HTTP Context Processor {bundle=" + String.valueOf(this.bundle) + "}";
        }
    }
}

