/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import jakarta.servlet.SessionCookieConfig;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.ops4j.pax.web.service.spi.config.Configuration;
import org.ops4j.pax.web.service.spi.config.JspConfiguration;
import org.ops4j.pax.web.service.spi.config.LogConfiguration;
import org.ops4j.pax.web.service.spi.config.ResourceConfiguration;
import org.ops4j.pax.web.service.spi.config.SecurityConfiguration;
import org.ops4j.pax.web.service.spi.config.ServerConfiguration;
import org.ops4j.pax.web.service.spi.config.SessionConfiguration;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.servlet.DefaultSessionCookieConfig;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.ops4j.util.property.PropertyResolver;
import org.ops4j.util.property.PropertyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationImpl
extends PropertyStore
implements Configuration {
    public static final Logger LOG = LoggerFactory.getLogger(ConfigurationImpl.class);
    private final String id;
    private final ServerConfiguration serverConfiguration;
    private final SecurityConfiguration securityConfiguration;
    private final ResourceConfiguration resourceConfiguration;
    private final SessionConfiguration sessionConfiguration;
    private final JspConfiguration jspConfiguration;
    private final LogConfiguration logConfiguration;
    private final PropertyResolver propertyResolver;
    private final Map<String, String> sourceProperties;

    ConfigurationImpl(PropertyResolver propertyResolver, Map<String, String> sourceProperties) {
        this.propertyResolver = propertyResolver;
        for (String key : sourceProperties.keySet()) {
            String v = propertyResolver.get(key);
            if (v == null || "".equals(v)) continue;
            sourceProperties.put(key, v);
        }
        this.sourceProperties = Collections.unmodifiableMap(sourceProperties);
        this.id = UUID.randomUUID().toString();
        this.serverConfiguration = new ServerConfigurationImpl();
        this.securityConfiguration = new SecurityConfigurationImpl();
        this.resourceConfiguration = new ResourceConfigurationImpl();
        this.sessionConfiguration = new SessionConfigurationImpl();
        this.jspConfiguration = new JspConfigurationImpl(this.serverConfiguration);
        this.logConfiguration = new LogConfigurationImpl();
    }

    public String id() {
        return this.id;
    }

    public ServerConfiguration server() {
        return this.serverConfiguration;
    }

    public SecurityConfiguration security() {
        return this.securityConfiguration;
    }

    public ResourceConfiguration resources() {
        return this.resourceConfiguration;
    }

    public JspConfiguration jsp() {
        return this.jspConfiguration;
    }

    public SessionConfiguration session() {
        return this.sessionConfiguration;
    }

    public LogConfiguration logging() {
        return this.logConfiguration;
    }

    public <T> T get(String propertyName, Class<T> clazz) {
        if (clazz == Integer.class) {
            return clazz.cast(this.resolveIntegerProperty(propertyName));
        }
        if (clazz == Boolean.class) {
            return clazz.cast(this.resolveBooleanProperty(propertyName));
        }
        if (clazz == String.class) {
            return clazz.cast(this.resolveStringProperty(propertyName));
        }
        throw new IllegalArgumentException("Can't convert \"" + propertyName + "\" to " + String.valueOf(clazz));
    }

    public Map<String, String> all() {
        return this.sourceProperties;
    }

    private Integer eagerIntegerProperty(String property) {
        return (Integer)super.get(property);
    }

    private Integer resolveIntegerProperty(String property) {
        if (!this.contains(property)) {
            this.ensurePropertyResolver(property);
            try {
                String resolvedProperty = this.propertyResolver.get(property);
                return this.set(property, resolvedProperty == null ? null : Integer.valueOf(this.propertyResolver.get(property)));
            }
            catch (Exception e) {
                LOG.debug("Reading configuration property " + property + " has failed: {}", (Object)e.getMessage());
            }
        }
        return (Integer)super.get(property);
    }

    private Long resolveLongProperty(String property) {
        if (!this.contains(property)) {
            this.ensurePropertyResolver(property);
            try {
                String resolvedProperty = this.propertyResolver.get(property);
                return this.set(property, resolvedProperty == null ? null : Long.valueOf(this.propertyResolver.get(property)));
            }
            catch (Exception e) {
                LOG.debug("Reading configuration property " + property + " has failed: {}", (Object)e.getMessage());
            }
        }
        return (Long)super.get(property);
    }

    private Boolean eagerBooleanProperty(String property) {
        return (Boolean)super.get(property);
    }

    private Boolean resolveBooleanProperty(String property) {
        if (!this.contains(property)) {
            this.ensurePropertyResolver(property);
            try {
                String resolvedProperty = this.propertyResolver.get(property);
                return this.set(property, resolvedProperty == null ? null : Boolean.valueOf(this.propertyResolver.get(property)));
            }
            catch (Exception e) {
                LOG.debug("Reading configuration property " + property + " has failed: {}", (Object)e.getMessage());
            }
        }
        return (Boolean)super.get(property);
    }

    private String resolveStringProperty(String property) {
        if (!this.contains(property)) {
            this.ensurePropertyResolver(property);
            try {
                String resolvedProperty = this.propertyResolver.get(property);
                return this.set(property, resolvedProperty == null ? null : this.propertyResolver.get(property));
            }
            catch (Exception e) {
                LOG.debug("Reading configuration property " + property + " has failed: {}", (Object)e.getMessage());
            }
        }
        return (String)super.get(property);
    }

    private void ensurePropertyResolver(String property) {
        if (this.propertyResolver == null) {
            throw new IllegalStateException("Can't access property resolver to resolve \"" + property + "\" property");
        }
    }

    private class ServerConfigurationImpl
    implements ServerConfiguration {
        private final File tmpDir;
        private final String[] listeningAddresses;
        private final File[] externalConfigurations;
        private final File externalContextConfiguration;
        private final int eventDispatcherThreadCount;
        private final boolean showStacks;
        private final String[] virtualHosts;
        private final String[] connectors;
        private final String tcclType;
        private final boolean whiteboardSynchronous;

        private ServerConfigurationImpl() {
            String[] connectorNames;
            Integer eventDispatcherThreadCount;
            ConfigurationImpl.this.resolveIntegerProperty("org.osgi.service.http.port");
            ConfigurationImpl.this.resolveIntegerProperty("org.osgi.service.http.port.secure");
            ConfigurationImpl.this.resolveBooleanProperty("org.osgi.service.http.enabled");
            ConfigurationImpl.this.resolveBooleanProperty("org.osgi.service.http.secure.enabled");
            String tmpDir = ConfigurationImpl.this.resolveStringProperty("jakarta.servlet.context.tempdir");
            if (tmpDir == null) {
                tmpDir = ConfigurationImpl.this.resolveStringProperty("java.io.tmpdir");
            }
            if (tmpDir == null) {
                throw new IllegalStateException("Can't determine java.io.tmpdir property");
            }
            File possibleTmpDir = (tmpDir = Utils.resolve((String)tmpDir)).startsWith("file:") ? new File(URI.create(tmpDir)) : new File(tmpDir);
            if (possibleTmpDir.isFile()) {
                throw new IllegalStateException(String.valueOf(possibleTmpDir) + " can't be used as temporary directory");
            }
            if (!possibleTmpDir.isDirectory()) {
                possibleTmpDir.mkdirs();
            }
            this.tmpDir = possibleTmpDir;
            String listeningAddresses = ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.listening.addresses");
            if (listeningAddresses == null || "".equals(listeningAddresses.trim())) {
                listeningAddresses = "0.0.0.0";
            }
            this.listeningAddresses = listeningAddresses.split("\\s*,\\s*");
            String externalFile = ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.config.files");
            if (externalFile == null) {
                externalFile = ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.config.file");
            }
            if (externalFile == null || "".equals(externalFile.trim())) {
                this.externalConfigurations = new File[0];
            } else {
                String[] locations = externalFile.split("\\s*,\\s*");
                File[] fileLocations = new File[locations.length];
                int idx = 0;
                for (String location : locations) {
                    File f = new File(location);
                    if (!f.isFile()) {
                        throw new IllegalArgumentException("External configuration " + String.valueOf(f) + " is not available");
                    }
                    fileLocations[idx++] = f;
                }
                this.externalConfigurations = fileLocations;
            }
            String contextConfig = ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.context.file");
            if (contextConfig != null && !"".equals(contextConfig.trim())) {
                this.externalContextConfiguration = new File(contextConfig);
                if (!this.externalContextConfiguration.isFile()) {
                    throw new IllegalArgumentException("Global context configuration " + contextConfig + " is not available");
                }
            } else {
                this.externalContextConfiguration = null;
            }
            this.eventDispatcherThreadCount = (eventDispatcherThreadCount = ConfigurationImpl.this.resolveIntegerProperty("org.ops4j.pax.web.server.eventDispatcherThreadCount")) == null ? 1 : eventDispatcherThreadCount;
            Boolean stacks = ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.server.showStacks");
            this.showStacks = stacks != null && stacks != false;
            String[] virtualHostNames = ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.default.virtualhosts");
            if (virtualHostNames != null) {
                virtualHostNames = virtualHostNames.split("\\s*,\\s*");
            }
            if ((connectorNames = ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.default.connectors")) != null) {
                connectorNames = connectorNames.split("\\s*,\\s*");
            }
            this.virtualHosts = Utils.asStringArray((String)"org.ops4j.pax.web.default.virtualhosts", (Object)virtualHostNames);
            this.connectors = Utils.asStringArray((String)"org.ops4j.pax.web.default.connectors", (Object)connectorNames);
            String tcclValue = ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.tccl.type");
            String tcclTypeValue = "servlet";
            if ("whiteboard".equalsIgnoreCase(tcclValue)) {
                tcclTypeValue = "whiteboard";
            } else if ("servlet".equalsIgnoreCase(tcclValue)) {
                tcclTypeValue = "servlet";
            } else if (tcclValue != null && !"".equals(tcclValue.trim())) {
                LOG.warn("Unknown value of {} property. Falling back to \"servlet\".", (Object)"org.ops4j.pax.web.tccl.type");
            }
            this.tcclType = tcclTypeValue;
            Boolean sync = ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.extender.whiteboard.synchronous");
            this.whiteboardSynchronous = sync != null && sync != false;
        }

        public File getTemporaryDirectory() {
            return this.tmpDir;
        }

        public File[] getConfigurationFiles() {
            return this.externalConfigurations;
        }

        public File getContextConfigurationFile() {
            return this.externalContextConfiguration;
        }

        public Integer getHttpPort() {
            return ConfigurationImpl.this.eagerIntegerProperty("org.osgi.service.http.port");
        }

        public Integer getHttpSecurePort() {
            return ConfigurationImpl.this.resolveIntegerProperty("org.osgi.service.http.port.secure");
        }

        public Boolean isHttpEnabled() {
            return ConfigurationImpl.this.eagerBooleanProperty("org.osgi.service.http.enabled");
        }

        public Boolean isHttpSecureEnabled() {
            return ConfigurationImpl.this.eagerBooleanProperty("org.osgi.service.http.secure.enabled");
        }

        public String[] getListeningAddresses() {
            return this.listeningAddresses;
        }

        public Integer getConnectorIdleTimeout() {
            return ConfigurationImpl.this.resolveIntegerProperty("org.ops4j.pax.web.server.connector.idleTimeout");
        }

        public String getHttpConnectorName() {
            return ConfigurationImpl.this.resolveStringProperty("org.osgi.service.http.connector.name");
        }

        public String getHttpSecureConnectorName() {
            return ConfigurationImpl.this.resolveStringProperty("org.osgi.service.http.secure.connector.name");
        }

        public Integer getServerIdleTimeout() {
            return ConfigurationImpl.this.resolveIntegerProperty("org.ops4j.pax.web.server.idleTimeout");
        }

        public Integer getServerMaxThreads() {
            return ConfigurationImpl.this.resolveIntegerProperty("org.ops4j.pax.web.server.maxThreads");
        }

        public Integer getServerMinThreads() {
            return ConfigurationImpl.this.resolveIntegerProperty("org.ops4j.pax.web.server.minThreads");
        }

        public String getServerThreadNamePrefix() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.server.threadNamePrefix");
        }

        public Boolean checkForwardedHeaders() {
            return ConfigurationImpl.this.resolveBooleanProperty("org.osgi.service.http.checkForwardedHeaders");
        }

        public Integer getEventDispatcherThreadCount() {
            return this.eventDispatcherThreadCount;
        }

        public Boolean isShowStacks() {
            return this.showStacks;
        }

        public String[] getVirtualHosts() {
            return this.virtualHosts;
        }

        public String[] getConnectors() {
            return this.connectors;
        }

        public String getTCCLType() {
            return this.tcclType;
        }

        public boolean isWhiteboardSynchronous() {
            return this.whiteboardSynchronous;
        }
    }

    private class SecurityConfigurationImpl
    implements SecurityConfiguration {
        private String[] includedProtocols = new String[0];
        private String[] excludedProtocols = new String[0];
        private String[] includedCipherSuites = new String[0];
        private String[] excludedCipherSuites = new String[0];

        SecurityConfigurationImpl() {
            String includedProtocols = ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ssl.protocols.included");
            String excludedProtocols = ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ssl.protocols.excluded");
            String includedCipherSuites = ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ssl.ciphersuites.included");
            String excludedCipherSuites = ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ssl.ciphersuites.excluded");
            if (includedProtocols != null && !"".equals(includedProtocols.trim())) {
                this.includedProtocols = includedProtocols.split("\\s*,\\s*");
            }
            if (excludedProtocols != null && !"".equals(excludedProtocols.trim())) {
                this.excludedProtocols = excludedProtocols.split("\\s*,\\s*");
            }
            if (includedCipherSuites != null && !"".equals(includedCipherSuites.trim())) {
                this.includedCipherSuites = includedCipherSuites.split("\\s*,\\s*");
            }
            if (excludedCipherSuites != null && !"".equals(excludedCipherSuites.trim())) {
                this.excludedCipherSuites = excludedCipherSuites.split("\\s*,\\s*");
            }
        }

        public String getSslProvider() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ssl.provider");
        }

        public String getSslKeystore() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ssl.keystore");
        }

        public String getSslKeystorePassword() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ssl.keystore.password");
        }

        public String getSslKeystoreType() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ssl.keystore.type");
        }

        public String getSslKeystoreProvider() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ssl.keystore.provider");
        }

        public String getSslKeyPassword() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ssl.key.password");
        }

        public String getSslKeyManagerFactoryAlgorithm() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ssl.keyManagerFactory.algorithm");
        }

        public String getSslKeyAlias() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ssl.key.alias");
        }

        public String getTruststore() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ssl.truststore");
        }

        public String getTruststorePassword() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ssl.truststore.password");
        }

        public String getTruststoreType() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ssl.truststore.type");
        }

        public String getTruststoreProvider() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ssl.truststore.provider");
        }

        public String getTrustManagerFactoryAlgorithm() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ssl.trustManagerFactory.algorithm");
        }

        public Boolean isClientAuthWanted() {
            return ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.ssl.clientauth.wanted");
        }

        public Boolean isClientAuthNeeded() {
            return ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.ssl.clientauth.needed");
        }

        public String getSslProtocol() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ssl.protocol");
        }

        public String getSecureRandomAlgorithm() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ssl.secureRandom.algorithm");
        }

        public String[] getProtocolsIncluded() {
            return this.includedProtocols;
        }

        public String[] getProtocolsExcluded() {
            return this.excludedProtocols;
        }

        public String[] getCiphersuiteIncluded() {
            return this.includedCipherSuites;
        }

        public String[] getCiphersuiteExcluded() {
            return this.excludedCipherSuites;
        }

        public Boolean isSslRenegotiationAllowed() {
            return ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.ssl.renegotiationAllowed");
        }

        public Integer getSslRenegotiationLimit() {
            return ConfigurationImpl.this.resolveIntegerProperty("org.ops4j.pax.web.ssl.renegotiationLimit");
        }

        public Boolean getSslSessionsEnabled() {
            return ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.ssl.session.enabled");
        }

        public Integer getSslSessionCacheSize() {
            return ConfigurationImpl.this.resolveIntegerProperty("org.ops4j.pax.web.ssl.session.cacheSize");
        }

        public Integer getSslSessionTimeout() {
            return ConfigurationImpl.this.resolveIntegerProperty("org.ops4j.pax.web.ssl.session.timeout");
        }

        public Boolean isValidateCerts() {
            return ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.validateCerts");
        }

        public Boolean isValidatePeerCerts() {
            return ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.validatePeerCerts");
        }

        public Boolean isEnableOCSP() {
            return ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.enableOCSP");
        }

        public Boolean isEnableCRLDP() {
            return ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.enableCRLDP");
        }

        public String getCrlPath() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.crlPath");
        }

        public String getOcspResponderURL() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.ocspResponderURL");
        }

        public Integer getMaxCertPathLength() {
            return ConfigurationImpl.this.resolveIntegerProperty("org.ops4j.pax.web.maxCertPathLength");
        }

        public Long getDigestAuthMaxNonceAge() {
            return ConfigurationImpl.this.resolveLongProperty("org.ops4j.pax.web.digestAuth.maxNonceAge");
        }

        public Integer getDigestAuthMaxNonceCount() {
            return ConfigurationImpl.this.resolveIntegerProperty("org.ops4j.pax.web.digestAuth.maxNonceCount");
        }

        public Boolean getFormAuthRedirect() {
            return ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.formAuth.errorRedirect");
        }

        public Boolean isEncEnabled() {
            Boolean enabled = ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.enc.enabled");
            return enabled == null ? Boolean.FALSE : enabled;
        }

        public String getEncPrefix() {
            String prefix = ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.enc.prefix");
            return prefix == null || "".equals(prefix.trim()) ? "ENC(" : prefix;
        }

        public String getEncSuffix() {
            String suffix = ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.enc.suffix");
            return suffix == null || "".equals(suffix.trim()) ? ")" : suffix;
        }

        public String getEncProvider() {
            String provider = ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.enc.provider");
            return provider == null || "SunJCE".equals(provider.trim()) ? null : provider;
        }

        public String getEncAlgorithm() {
            String alg = ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.enc.provider");
            return alg == null || "".equals(alg.trim()) ? "PBEWithHmacSHA256AndAES_128" : alg;
        }

        public String getEncMasterPassword() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.enc.masterpassword");
        }

        public String getEncMasterPasswordEnvVariable() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.enc.masterpassword.env.variable");
        }

        public String getEncMasterPasswordSystemProperty() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.enc.masterpassword.sys.property");
        }

        public Integer getEncIterationCount() {
            Integer ic = ConfigurationImpl.this.resolveIntegerProperty("org.ops4j.pax.web.enc.iterationcount");
            return ic == null ? 1000 : ic;
        }

        public String getEncOSGiDecryptorId() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.enc.osgi.decryptor");
        }
    }

    private class ResourceConfigurationImpl
    implements ResourceConfiguration {
        private ResourceConfigurationImpl() {
        }

        public boolean acceptRanges() {
            return ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.resource.acceptRanges");
        }

        public boolean redirectWelcome() {
            return ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.resource.redirectWelcome");
        }

        public boolean dirListing() {
            return ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.resource.dirListing");
        }

        public Integer maxCacheEntries() {
            return ConfigurationImpl.this.resolveIntegerProperty("org.ops4j.pax.web.resource.cache.maxEntries");
        }

        public Integer maxCacheEntrySize() {
            return ConfigurationImpl.this.resolveIntegerProperty("org.ops4j.pax.web.resource.cache.maxEntrySize");
        }

        public Integer maxTotalCacheSize() {
            return ConfigurationImpl.this.resolveIntegerProperty("org.ops4j.pax.web.resource.cache.maxTotalSize");
        }

        public Integer maxCacheTTL() {
            return ConfigurationImpl.this.resolveIntegerProperty("org.ops4j.pax.web.resource.cache.ttl");
        }
    }

    private class SessionConfigurationImpl
    implements SessionConfiguration {
        private final int sessionTimeout;
        private final String sessionCookieName;
        private final String sessionCookiePathName;
        private final DefaultSessionCookieConfig defaultSessionCookieConfig;

        SessionConfigurationImpl() {
            Integer sessionTimeout = ConfigurationImpl.this.resolveIntegerProperty("org.ops4j.pax.web.session.timeout");
            if (sessionTimeout == null) {
                sessionTimeout = 30;
            }
            this.sessionTimeout = sessionTimeout;
            String sessionCookieName = ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.session.cookie.name");
            if (sessionCookieName == null) {
                sessionCookieName = "JSESSIONID";
            }
            this.sessionCookieName = sessionCookieName;
            String sessionCookiePathName = ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.session.url");
            if (sessionCookiePathName == null) {
                sessionCookiePathName = "jsessionid";
            }
            this.sessionCookiePathName = sessionCookiePathName;
            this.defaultSessionCookieConfig = new DefaultSessionCookieConfig();
            this.defaultSessionCookieConfig.setName(sessionCookieName);
            if (this.getSessionCookieDomain() != null) {
                this.defaultSessionCookieConfig.setDomain(this.getSessionCookieDomain());
            }
            if (this.getSessionCookiePath() != null) {
                this.defaultSessionCookieConfig.setPath(this.getSessionCookiePath());
            }
            if (this.getSessionCookieComment() != null) {
                this.defaultSessionCookieConfig.setComment(this.getSessionCookieComment());
            }
            this.defaultSessionCookieConfig.setHttpOnly(this.getSessionCookieHttpOnly() == null || this.getSessionCookieHttpOnly() != false);
            this.defaultSessionCookieConfig.setSecure(this.getSessionCookieSecure() != null && this.getSessionCookieSecure() != false);
            if (this.getSessionCookieMaxAge() != null) {
                this.defaultSessionCookieConfig.setMaxAge(this.getSessionCookieMaxAge().intValue());
            }
        }

        public Integer getSessionTimeout() {
            return this.sessionTimeout;
        }

        public String getSessionCookieName() {
            return this.sessionCookieName;
        }

        public String getSessionCookieDomain() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.session.cookie.domain");
        }

        public String getSessionCookiePath() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.session.cookie.path");
        }

        public String getSessionCookieComment() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.session.cookie.comment");
        }

        public Boolean getSessionCookieHttpOnly() {
            return ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.session.cookie.httpOnly");
        }

        public Boolean getSessionCookieSecure() {
            return ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.session.cookie.secure");
        }

        public Integer getSessionCookieMaxAge() {
            return ConfigurationImpl.this.resolveIntegerProperty("org.ops4j.pax.web.session.cookie.maxAge");
        }

        public String getSessionCookieSameSite() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.session.cookie.sameSite");
        }

        public String getSessionUrlPathParameter() {
            return this.sessionCookiePathName;
        }

        public String getSessionWorkerName() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.session.worker.name");
        }

        public String getSessionStoreDirectoryLocation() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.session.storedirectory");
        }

        public File getSessionStoreDirectory() {
            String location = this.getSessionStoreDirectoryLocation();
            if (location == null || "".equals(location.trim())) {
                return null;
            }
            File result = null;
            if (location.startsWith("file:")) {
                try {
                    URL locationUrl = new URL(location);
                    result = new File(locationUrl.toURI());
                }
                catch (MalformedURLException | URISyntaxException e) {
                    LOG.warn("Invalid URL for session persistence: {}", (Object)location, (Object)e);
                }
            } else {
                result = new File(location);
            }
            if (result != null && !result.isDirectory()) {
                LOG.warn("Directory {} is not accessible, skipping configuration of file session persistence", (Object)location);
                return null;
            }
            return result;
        }

        public SessionCookieConfig getDefaultSessionCookieConfig() {
            return this.defaultSessionCookieConfig;
        }
    }

    private class JspConfigurationImpl
    implements JspConfiguration {
        private final ServerConfiguration serverConfig;
        private String globalScratchDir = null;

        JspConfigurationImpl(ServerConfiguration serverConfiguration) {
            this.serverConfig = serverConfiguration;
            String location = ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.jsp.scratch.dir");
            File result = null;
            if (location != null) {
                if (location.startsWith("file:")) {
                    try {
                        URL locationUrl = new URL(location);
                        result = new File(locationUrl.toURI());
                    }
                    catch (MalformedURLException | URISyntaxException e) {
                        LOG.warn("Invalid URL for JSP global scratch directory: {}", (Object)location, (Object)e);
                    }
                } else {
                    result = new File(location);
                }
            }
            if (result != null) {
                result.mkdirs();
                if (!result.isDirectory()) {
                    LOG.warn("Directory {} is not accessible, JSP scratch dir will be relative to tmp dir and context dependent", (Object)location);
                }
                try {
                    this.globalScratchDir = result.getCanonicalPath();
                }
                catch (IOException e) {
                    LOG.warn("Unexpected problem when checking JSP scratch dir {}", (Object)result, (Object)e);
                }
            }
        }

        public String getJspScratchDir(OsgiContextModel context) {
            if (this.globalScratchDir != null) {
                return this.globalScratchDir;
            }
            File dir = new File(this.serverConfig.getTemporaryDirectory(), "jsp/" + context.getTemporaryLocation());
            try {
                dir.mkdirs();
                return dir.getCanonicalPath();
            }
            catch (IOException e) {
                LOG.warn("Unexpected problem when checking JSP scratch dir {}", (Object)dir, (Object)e);
                return dir.getAbsolutePath();
            }
        }

        public String getGloablJspScratchDir() {
            return this.globalScratchDir;
        }
    }

    private class LogConfigurationImpl
    implements LogConfiguration {
        private final Boolean ncsaBuffered;

        private LogConfigurationImpl() {
            ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.log.ncsa.enabled");
            Boolean buffered = ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.log.ncsa.buffered");
            this.ncsaBuffered = buffered == null || buffered != false;
        }

        public Boolean isLogNCSAFormatEnabled() {
            return ConfigurationImpl.this.eagerBooleanProperty("org.ops4j.pax.web.log.ncsa.enabled");
        }

        public String getLogNCSADirectory() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.log.ncsa.directory");
        }

        public String getLogNCSAFile() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.log.ncsa.file");
        }

        public Boolean isLogNCSAAppend() {
            return ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.log.ncsa.append");
        }

        public String getLogNCSAFilenameDateFormat() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.log.ncsa.file.date.format");
        }

        public Integer getLogNCSARetainDays() {
            return ConfigurationImpl.this.resolveIntegerProperty("org.ops4j.pax.web.log.ncsa.retaindays");
        }

        public Boolean isLogNCSAExtended() {
            return ConfigurationImpl.this.resolveBooleanProperty("org.ops4j.pax.web.log.ncsa.extended");
        }

        public String getLogNCSATimeZone() {
            return ConfigurationImpl.this.resolveStringProperty("org.ops4j.pax.web.log.ncsa.logtimezone");
        }

        public Boolean getLogNCSABuffered() {
            return this.ncsaBuffered;
        }
    }
}

