/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.ops4j.pax.swissbox.property.BundleContextPropertyResolver;
import org.ops4j.pax.web.service.PaxWebConstants;
import org.ops4j.pax.web.service.internal.ConfigurationBuilder;
import org.ops4j.pax.web.service.internal.EventAdminHandler;
import org.ops4j.pax.web.service.internal.HttpContextProcessing;
import org.ops4j.pax.web.service.internal.HttpServiceEnabled;
import org.ops4j.pax.web.service.internal.HttpServiceProxy;
import org.ops4j.pax.web.service.internal.MetaTypePropertyResolver;
import org.ops4j.pax.web.service.internal.PaxWebManagedService;
import org.ops4j.pax.web.service.internal.StoppableHttpService;
import org.ops4j.pax.web.service.internal.StoppableHttpServiceFactory;
import org.ops4j.pax.web.service.internal.WebElementEventDispatcher;
import org.ops4j.pax.web.service.internal.security.SecurePropertyResolver;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.ServerControllerFactory;
import org.ops4j.pax.web.service.spi.config.Configuration;
import org.ops4j.pax.web.service.spi.config.JspConfiguration;
import org.ops4j.pax.web.service.spi.config.LogConfiguration;
import org.ops4j.pax.web.service.spi.config.ResourceConfiguration;
import org.ops4j.pax.web.service.spi.config.SecurityConfiguration;
import org.ops4j.pax.web.service.spi.config.ServerConfiguration;
import org.ops4j.pax.web.service.spi.config.SessionConfiguration;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.ops4j.pax.web.service.spi.model.events.ServerEvent;
import org.ops4j.pax.web.service.spi.model.events.ServerListener;
import org.ops4j.pax.web.service.spi.model.events.WebApplicationEventListener;
import org.ops4j.pax.web.service.spi.util.NamedThreadFactory;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.ops4j.util.property.PropertyResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.log.LogService;
import org.osgi.service.servlet.runtime.HttpServiceRuntime;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
PaxWebManagedService.ConfigurationUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private BundleContext bundleContext;
    private Dictionary<String, ?> configuration;
    private ServerControllerFactory serverControllerFactory;
    private ServerController serverController;
    private WebElementEventDispatcher webElementEventDispatcher;
    private HttpContextProcessing httpContextProcessing;
    private ServiceRegistration<?> httpServiceFactoryReg;
    private ServiceRegistration<HttpServiceRuntime> httpServiceRuntimeReg;
    private ServiceRegistration<?> managedServiceReg;
    private ServiceRegistration<?> managedServiceFactoryReg;
    private ServiceTracker<ServerControllerFactory, ServerControllerFactory> serverControllerFactoryTracker;
    private ServiceTracker<?, ?> eventServiceTracker;
    private ServiceTracker<LogService, LogService> logServiceTracker;
    private ServiceTracker<ServerListener, ServerListener> serverListenerTracker;
    private final List<ServerListener> serverListeners = new CopyOnWriteArrayList<ServerListener>();
    private ServiceTracker<?, ?> jasyptTracker;
    private final AtomicBoolean jasyptTracking = new AtomicBoolean(false);
    private final AtomicBoolean initialConfigSet = new AtomicBoolean(false);
    private ServerModel serverModel = null;
    private ScheduledExecutorService runtimeExecutor;
    private long registrationThreadId;
    private boolean deferredConfiguration = true;

    public void start(BundleContext context) throws Exception {
        LOG.debug("Starting Pax Web Runtime");
        this.runtimeExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("paxweb-config"));
        this.registrationThreadId = ServerModel.getThreadIdFromSingleThreadPool((Executor)this.runtimeExecutor);
        this.bundleContext = context;
        this.serverListenerTracker = new ServiceTracker(this.bundleContext, ServerListener.class, (ServiceTrackerCustomizer)new ServerListenerCustomizer());
        this.serverListenerTracker.open();
        String flag = this.bundleContext.getProperty("org.ops4j.pax.web.configuration.deferred");
        boolean bl = this.deferredConfiguration = flag == null || Boolean.parseBoolean(flag);
        if (Utils.isConfigurationAdminAvailable(this.getClass())) {
            this.registerManagedService(context);
        } else {
            this.updateConfiguration(null);
        }
        if (Utils.isEventAdminAvailable(this.getClass())) {
            Filter filterEvent = context.createFilter("(objectClass=org.osgi.service.event.EventAdmin)");
            EventAdminHandler adminHandler = new EventAdminHandler(context);
            this.eventServiceTracker = new ServiceTracker(context, filterEvent, (ServiceTrackerCustomizer)adminHandler);
            this.eventServiceTracker.open();
            context.registerService(WebApplicationEventListener.class, (Object)adminHandler, null);
            LOG.info("EventAdmin support enabled, WAB events will be posted to EventAdmin topics.");
        } else {
            LOG.info("EventAdmin support is not available, no WAB events will be sent.");
        }
        LOG.info("Pax Web Runtime started");
    }

    public void stop(BundleContext context) {
        LOG.debug("Stopping Pax Web Runtime");
        if (this.serverModel != null) {
            this.serverModel.setStopping();
        }
        if (this.serverControllerFactory != null && this.serverController != null) {
            this.serverControllerFactory.releaseServerController(this.serverController, this.serverController.getConfiguration());
        }
        this.cleanUpHttpServiceRegistrations();
        if (this.jasyptTracker != null) {
            this.jasyptTracker.close();
            this.jasyptTracker = null;
        }
        if (this.serverListenerTracker != null) {
            this.serverListenerTracker.close();
            this.serverListenerTracker = null;
        }
        if (this.serverControllerFactoryTracker != null) {
            this.serverControllerFactoryTracker.close();
            this.serverControllerFactoryTracker = null;
        }
        if (this.managedServiceReg != null) {
            this.managedServiceReg.unregister();
            this.managedServiceReg = null;
        }
        if (this.eventServiceTracker != null) {
            this.eventServiceTracker.close();
            this.eventServiceTracker = null;
        }
        if (this.webElementEventDispatcher != null) {
            this.webElementEventDispatcher.destroy();
            this.webElementEventDispatcher = null;
        }
        try {
            this.runtimeExecutor.shutdown();
            LOG.debug("...entering 20 seconds grace period...");
            boolean ok = this.runtimeExecutor.awaitTermination(20L, TimeUnit.SECONDS);
            if (!ok) {
                LOG.warn("Timeout awaiting termination, shutting down the executor.");
            }
            this.runtimeExecutor.shutdownNow();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        LOG.info("Pax Web Runtime stopped");
    }

    private void registerManagedService(BundleContext context) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", "org.ops4j.pax.web");
        this.managedServiceReg = context.registerService("org.osgi.service.cm.ManagedService", (Object)new PaxWebManagedService(this), props);
    }

    private void createManagedServiceFactory(BundleContext context, ServerController serverController) {
        if (this.managedServiceFactoryReg != null) {
            this.managedServiceFactoryReg.unregister();
            this.managedServiceFactoryReg = null;
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", "org.ops4j.pax.web.context");
        this.httpContextProcessing = new HttpContextProcessing(context);
        this.managedServiceFactoryReg = context.registerService("org.osgi.service.cm.ManagedServiceFactory", (Object)this.httpContextProcessing, props);
    }

    @Override
    public void updateConfiguration(Dictionary<String, ?> configuration) {
        LOG.info("Scheduling Pax Web reconfiguration because configuration has changed");
        Future<?> future = this.runtimeExecutor.submit(() -> {
            String name = Thread.currentThread().getName();
            try {
                Thread.currentThread().setName(name + " (change config)");
                this.updateController(configuration, this.serverControllerFactory);
            }
            finally {
                Thread.currentThread().setName(name);
            }
        });
        if (!this.deferredConfiguration) {
            try {
                future.get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
    }

    private void updateServerControllerFactory(ServerControllerFactory controllerFactory) {
        if (this.serverControllerFactory != null) {
            if (controllerFactory == null) {
                LOG.info("Scheduling Pax Web reconfiguration because ServerControllerFactory has been unregistered");
            } else {
                LOG.info("Scheduling Pax Web reconfiguration because ServerControllerFactory has been re-registered");
            }
        } else if (controllerFactory != null) {
            LOG.info("Scheduling Pax Web reconfiguration because ServerControllerFactory has been registered");
        }
        Future<?> future = this.runtimeExecutor.submit(() -> {
            String name = Thread.currentThread().getName();
            try {
                Thread.currentThread().setName(name + " (change controller)");
                this.updateController(this.configuration, controllerFactory);
            }
            finally {
                Thread.currentThread().setName(name);
            }
        });
        if (controllerFactory == null || !this.deferredConfiguration) {
            try {
                future.get(20L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOG.info("Error when updating factory: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void updateController(Dictionary<String, ?> dictionary, ServerControllerFactory controllerFactory) {
        if (!this.initialConfigSet.get()) {
            LOG.debug("Initial configuration of pax-web-runtime, registration of ServerControllerFactory tracker");
            this.initialConfigSet.compareAndSet(false, true);
            this.configuration = dictionary;
            this.serverControllerFactory = controllerFactory;
            this.serverControllerFactoryTracker = new ServiceTracker(this.bundleContext, ServerControllerFactory.class, (ServiceTrackerCustomizer)new ServerControllerFactoryCustomizer());
            this.serverControllerFactoryTracker.open();
            return;
        }
        if (Utils.same(dictionary, this.configuration) && Utils.same((Object)controllerFactory, (Object)this.serverControllerFactory)) {
            LOG.debug("No change in configuration of Pax Web Runtime.");
            return;
        }
        if (this.serverModel != null) {
            this.serverModel.setStopping();
            this.serverModel = null;
        }
        this.configuration = dictionary;
        boolean hadSCF = this.serverControllerFactory != null;
        ServerControllerFactory previousServerControllerFactory = this.serverControllerFactory;
        this.serverControllerFactory = controllerFactory;
        this.cleanUpHttpServiceRegistrations();
        if (this.serverController != null) {
            LOG.info("Stopping current server controller {}", (Object)this.serverController);
            try {
                this.serverController.stop();
            }
            catch (Exception e) {
                LOG.error("Problem stopping server controller: " + e.getMessage(), (Throwable)e);
            }
            if (previousServerControllerFactory != null) {
                previousServerControllerFactory.releaseServerController(this.serverController, this.serverController.getConfiguration());
            }
            this.serverController = null;
        }
        if (this.serverControllerFactory == null) {
            if (hadSCF) {
                LOG.info("ServerControllerFactory is gone, HTTP Service is not available now.");
            }
            return;
        }
        this.performConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performConfiguration() {
        try {
            HashMap<String, String> allProperties = new HashMap<String, String>(System.getenv());
            allProperties.putAll(Utils.toMap((Dictionary)System.getProperties()));
            MetaTypePropertyResolver defaultResolver = new MetaTypePropertyResolver();
            allProperties.putAll(Utils.toMap(defaultResolver.getProperties()));
            BundleContextPropertyResolver tmpResolver = new BundleContextPropertyResolver(this.bundleContext, defaultResolver);
            PropertyResolver resolver = this.configuration != null ? new DictionaryPropertyResolver(this.configuration, tmpResolver) : tmpResolver;
            allProperties.putAll(Utils.toMap(this.configuration));
            String enabled = (String)allProperties.get("org.ops4j.pax.web.enc.enabled");
            if ("true".equalsIgnoreCase(enabled)) {
                if (!Utils.isJasyptAvailable(this.getClass())) {
                    LOG.warn("Encryption is enabled, but Jasypt bundle is not available. Decryption of configuration values won't be performed.");
                } else {
                    String password;
                    String sys;
                    String decryptor = (String)allProperties.get("org.ops4j.pax.web.enc.osgi.decryptor");
                    if (decryptor != null && !"".equals(decryptor)) {
                        LOG.info("Encryption is enabled and Jasypt encryptor with ID \"{}\" will be looked up in OSGi registry", (Object)decryptor);
                        String filter = String.format("(&(%s=%s)(decryptor=%s))", "objectClass", "org.jasypt.encryption.StringEncryptor", decryptor);
                        Class<JasyptCustomizer> clazz = JasyptCustomizer.class;
                        synchronized (JasyptCustomizer.class) {
                            block23: {
                                if (this.jasyptTracker != null) {
                                    this.jasyptTracker.close();
                                    this.jasyptTracker = null;
                                }
                                this.jasyptTracking.set(true);
                                try {
                                    this.jasyptTracker = new ServiceTracker(this.bundleContext, this.bundleContext.createFilter(filter), (ServiceTrackerCustomizer)new JasyptCustomizer());
                                    this.jasyptTracker.open();
                                    Object encryptor = this.jasyptTracker.getService();
                                    if (encryptor != null) {
                                        resolver = SecurePropertyResolver.wrap(resolver, encryptor);
                                        break block23;
                                    }
                                    LOG.info("Jasypt encryptor with ID \"{}\" is not found in OSGi registry. Pax Web configuration will be performed after it becomes available.", (Object)decryptor);
                                    // ** MonitorExit[var8_13] (shouldn't be in output)
                                    return;
                                }
                                finally {
                                    this.jasyptTracking.set(false);
                                }
                            }
                            // ** MonitorExit[var8_13] (shouldn't be in output)
                        }
                    }
                    LOG.info("Encryption is enabled and pax-web-runtime will configure Jasypt encryptor");
                    boolean foundPassword = false;
                    String env = (String)allProperties.get("org.ops4j.pax.web.enc.masterpassword.env.variable");
                    if (env != null && !"".equals(env)) {
                        LOG.debug("Environment variable \"{}\" will be used to obtain the master password", (Object)env);
                        foundPassword = true;
                    }
                    if ((sys = (String)allProperties.get("org.ops4j.pax.web.enc.masterpassword.sys.property")) != null && !"".equals(sys)) {
                        LOG.debug("System property \"{}\" will be used to obtain the master password", (Object)sys);
                        foundPassword = true;
                    }
                    if ((password = (String)allProperties.get("org.ops4j.pax.web.enc.masterpassword")) != null && !"".equals(password)) {
                        foundPassword = true;
                    }
                    if (!foundPassword) {
                        LOG.warn("No master password was provided. Decryption of configuration values won't be performed.");
                    } else {
                        resolver = SecurePropertyResolver.wrap(resolver);
                    }
                }
            }
            {
                final Configuration configuration = ConfigurationBuilder.getConfiguration(resolver, allProperties);
                this.webElementEventDispatcher = new WebElementEventDispatcher(this.bundleContext, configuration);
                this.serverModel = new ServerModel((Executor)this.runtimeExecutor, this.registrationThreadId);
                this.serverController = this.serverControllerFactory.createServerController(configuration);
                this.serverListeners.forEach(listener -> this.serverController.addListener(listener));
                LOG.info("Configuring server controller {}", (Object)this.serverController.getClass().getName());
                this.serverController.configure();
                LOG.info("Starting server controller {}", (Object)this.serverController.getClass().getName());
                this.serverController.start();
                Dictionary<String, Object> props = this.determineServiceProperties(configuration);
                StoppableHttpServiceFactory factory = new StoppableHttpServiceFactory(this.serverController, this.serverModel, this.webElementEventDispatcher){

                    @Override
                    StoppableHttpService createService(Bundle bundle, ServerController serverController, ServerModel serverModel, WebElementEventDispatcher webElementEventDispatcher) {
                        HttpServiceEnabled enabledService = new HttpServiceEnabled(bundle, serverController, serverModel, webElementEventDispatcher, configuration);
                        return new HttpServiceProxy(bundle, enabledService);
                    }
                };
                LOG.info("Registering HttpService factory");
                this.httpServiceFactoryReg = this.bundleContext.registerService(PaxWebConstants.HTTPSERVICE_REGISTRATION_NAMES, (Object)factory, props);
                LOG.info("Registering HttpServiceRuntime");
                props = new Hashtable<String, Object>();
                props.put("osgi.http.endpoint", "/");
                Long httpServiceId = (Long)this.httpServiceFactoryReg.getReference().getProperty("service.id");
                props.put("osgi.http.service.id", Collections.singletonList(httpServiceId));
                props.put("service.changecount", 0L);
                this.httpServiceRuntimeReg = this.bundleContext.registerService(HttpServiceRuntime.class, (Object)this.serverModel, props);
                ServiceReferenceDTO httpServiceRuntimeDTO = new ServiceReferenceDTO();
                httpServiceRuntimeDTO.id = (Long)this.httpServiceRuntimeReg.getReference().getProperty("service.id");
                httpServiceRuntimeDTO.bundle = this.bundleContext.getBundle().getBundleId();
                httpServiceRuntimeDTO.properties = new HashMap();
                httpServiceRuntimeDTO.properties.put("osgi.http.endpoint", "/");
                httpServiceRuntimeDTO.properties.put("osgi.http.service.id", Collections.singletonList(httpServiceId));
                httpServiceRuntimeDTO.properties.put("service.changecount", 0L);
                httpServiceRuntimeDTO.usingBundles = new long[0];
                this.serverModel.setHttpServiceRuntimeInformation(this.httpServiceRuntimeReg, httpServiceRuntimeDTO);
                this.serverController.addListener((ServerListener)new AddressConfiguration());
                if (Utils.isConfigurationAdminAvailable(this.getClass())) {
                    this.createManagedServiceFactory(this.bundleContext, this.serverController);
                }
            }
        }
        catch (Throwable t) {
            try {
                Bundle bundle = this.bundleContext.getBundle();
                if (bundle.getState() == 16 || bundle.getState() == 1) {
                    return;
                }
                LOG.error("Unable to start Pax Web server: {}", (Object)t.getMessage(), (Object)t);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private void cleanUpHttpServiceRegistrations() {
        if (this.httpServiceRuntimeReg != null) {
            LOG.info("Unregistering current HttpServiceRuntime");
            this.httpServiceRuntimeReg.unregister();
            this.httpServiceRuntimeReg = null;
        }
        if (this.httpServiceFactoryReg != null) {
            LOG.info("Unregistering current HttpService factory");
            this.httpServiceFactoryReg.unregister();
            this.httpServiceFactoryReg = null;
        }
        if (this.httpContextProcessing != null) {
            this.httpContextProcessing.destroy();
            this.httpContextProcessing = null;
        }
        if (this.managedServiceFactoryReg != null) {
            this.managedServiceFactoryReg.unregister();
            this.managedServiceFactoryReg = null;
        }
    }

    private Dictionary<String, Object> determineServiceProperties(Configuration configuration) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ServerConfiguration sc = configuration.server();
        this.setProperty(properties, "org.osgi.service.http.enabled", sc.isHttpEnabled());
        this.setProperty(properties, "org.osgi.service.http.port", sc.getHttpPort());
        this.setProperty(properties, "org.osgi.service.http.secure.enabled", sc.isHttpSecureEnabled());
        this.setProperty(properties, "org.osgi.service.http.port.secure", sc.getHttpSecurePort());
        this.setProperty(properties, "org.osgi.service.http.connector.name", sc.getHttpConnectorName());
        this.setProperty(properties, "org.osgi.service.http.secure.connector.name", sc.getHttpSecureConnectorName());
        this.setProperty(properties, "org.ops4j.pax.web.listening.addresses", sc.getListeningAddresses());
        this.setProperty(properties, "org.ops4j.pax.web.server.connector.idleTimeout", sc.getConnectorIdleTimeout());
        this.setProperty(properties, "org.ops4j.pax.web.server.idleTimeout", sc.getServerIdleTimeout());
        this.setProperty(properties, "org.ops4j.pax.web.server.maxThreads", sc.getServerMaxThreads());
        this.setProperty(properties, "org.ops4j.pax.web.server.minThreads", sc.getServerMinThreads());
        this.setProperty(properties, "org.ops4j.pax.web.server.threadNamePrefix", sc.getServerThreadNamePrefix());
        this.setProperty(properties, "org.ops4j.pax.web.server.showStacks", sc.isShowStacks());
        this.setProperty(properties, "org.ops4j.pax.web.server.eventDispatcherThreadCount", sc.getEventDispatcherThreadCount());
        this.setProperty(properties, "org.osgi.service.http.checkForwardedHeaders", sc.checkForwardedHeaders());
        this.setProperty(properties, "jakarta.servlet.context.tempdir", sc.getTemporaryDirectory());
        this.setProperty(properties, "org.osgi.service.http.checkForwardedHeaders", sc.checkForwardedHeaders());
        this.setProperty(properties, "org.ops4j.pax.web.config.files", sc.getConfigurationFiles());
        LogConfiguration lc = configuration.logging();
        this.setProperty(properties, "org.ops4j.pax.web.log.ncsa.enabled", lc.isLogNCSAFormatEnabled());
        this.setProperty(properties, "org.ops4j.pax.web.log.ncsa.directory", lc.getLogNCSADirectory());
        this.setProperty(properties, "org.ops4j.pax.web.log.ncsa.file", lc.getLogNCSAFile());
        this.setProperty(properties, "org.ops4j.pax.web.log.ncsa.append", lc.isLogNCSAAppend());
        this.setProperty(properties, "org.ops4j.pax.web.log.ncsa.file.date.format", lc.getLogNCSAFilenameDateFormat());
        this.setProperty(properties, "org.ops4j.pax.web.log.ncsa.retaindays", lc.getLogNCSARetainDays());
        this.setProperty(properties, "org.ops4j.pax.web.log.ncsa.extended", lc.isLogNCSAExtended());
        this.setProperty(properties, "org.ops4j.pax.web.log.ncsa.logtimezone", lc.getLogNCSATimeZone());
        this.setProperty(properties, "org.ops4j.pax.web.log.ncsa.buffered", lc.getLogNCSABuffered());
        SessionConfiguration sess = configuration.session();
        this.setProperty(properties, "org.ops4j.pax.web.session.timeout", sess.getSessionTimeout());
        this.setProperty(properties, "org.ops4j.pax.web.session.cookie.name", sess.getSessionCookieName());
        this.setProperty(properties, "org.ops4j.pax.web.session.cookie.domain", sess.getSessionCookieDomain());
        this.setProperty(properties, "org.ops4j.pax.web.session.cookie.path", sess.getSessionCookiePath());
        this.setProperty(properties, "org.ops4j.pax.web.session.cookie.comment", sess.getSessionCookieComment());
        this.setProperty(properties, "org.ops4j.pax.web.session.cookie.httpOnly", sess.getSessionCookieHttpOnly());
        this.setProperty(properties, "org.ops4j.pax.web.session.cookie.secure", sess.getSessionCookieSecure());
        this.setProperty(properties, "org.ops4j.pax.web.session.cookie.maxAge", sess.getSessionCookieMaxAge());
        this.setProperty(properties, "org.ops4j.pax.web.session.cookie.sameSite", sess.getSessionCookieSameSite());
        this.setProperty(properties, "org.ops4j.pax.web.session.url", sess.getSessionUrlPathParameter());
        this.setProperty(properties, "org.ops4j.pax.web.session.worker.name", sess.getSessionWorkerName());
        this.setProperty(properties, "org.ops4j.pax.web.session.storedirectory", sess.getSessionStoreDirectoryLocation());
        ResourceConfiguration res = configuration.resources();
        JspConfiguration jsp = configuration.jsp();
        this.setProperty(properties, "org.ops4j.pax.web.jsp.scratch.dir", jsp.getGloablJspScratchDir());
        SecurityConfiguration sec = configuration.security();
        this.setProperty(properties, "org.ops4j.pax.web.ssl.provider", sec.getSslProvider());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.keystore", sec.getSslKeystore());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.keystore.password", "********");
        this.setProperty(properties, "org.ops4j.pax.web.ssl.key.password", "********");
        this.setProperty(properties, "org.ops4j.pax.web.ssl.keystore.type", sec.getSslKeystoreType());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.keystore.provider", sec.getSslKeystoreProvider());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.keyManagerFactory.algorithm", sec.getSslKeyManagerFactoryAlgorithm());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.key.alias", sec.getSslKeyAlias());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.truststore", sec.getTruststore());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.truststore.password", "********");
        this.setProperty(properties, "org.ops4j.pax.web.ssl.truststore.type", sec.getTruststoreType());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.truststore.provider", sec.getTruststoreProvider());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.trustManagerFactory.algorithm", sec.getTrustManagerFactoryAlgorithm());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.clientauth.wanted", sec.isClientAuthWanted());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.clientauth.needed", sec.isClientAuthNeeded());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.protocol", sec.getSslProtocol());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.secureRandom.algorithm", sec.getSecureRandomAlgorithm());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.protocols.included", sec.getProtocolsIncluded());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.protocols.excluded", sec.getProtocolsExcluded());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.ciphersuites.included", sec.getCiphersuiteIncluded());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.ciphersuites.excluded", sec.getCiphersuiteExcluded());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.renegotiationAllowed", sec.isSslRenegotiationAllowed());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.renegotiationLimit", sec.getSslRenegotiationLimit());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.session.enabled", sec.getSslSessionsEnabled());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.session.cacheSize", sec.getSslSessionCacheSize());
        this.setProperty(properties, "org.ops4j.pax.web.ssl.session.timeout", sec.getSslSessionTimeout());
        this.setProperty(properties, "org.ops4j.pax.web.validateCerts", sec.isValidateCerts());
        this.setProperty(properties, "org.ops4j.pax.web.validatePeerCerts", sec.isValidatePeerCerts());
        this.setProperty(properties, "org.ops4j.pax.web.enableOCSP", sec.isEnableOCSP());
        this.setProperty(properties, "org.ops4j.pax.web.enableCRLDP", sec.isEnableCRLDP());
        this.setProperty(properties, "org.ops4j.pax.web.crlPath", sec.getCrlPath());
        this.setProperty(properties, "org.ops4j.pax.web.ocspResponderURL", sec.getOcspResponderURL());
        this.setProperty(properties, "org.ops4j.pax.web.maxCertPathLength", sec.getMaxCertPathLength());
        this.setProperty(properties, "org.ops4j.pax.web.digestAuth.maxNonceAge", sec.getDigestAuthMaxNonceAge());
        this.setProperty(properties, "org.ops4j.pax.web.digestAuth.maxNonceCount", sec.getDigestAuthMaxNonceCount());
        this.setProperty(properties, "org.ops4j.pax.web.formAuth.errorRedirect", sec.getFormAuthRedirect());
        this.setProperty(properties, "org.ops4j.pax.web.enc.enabled", sec.isEncEnabled());
        this.setProperty(properties, "org.ops4j.pax.web.enc.masterpassword", "********");
        this.setProperty(properties, "org.ops4j.pax.web.enc.masterpassword.env.variable", sec.getEncMasterPasswordEnvVariable());
        this.setProperty(properties, "org.ops4j.pax.web.enc.masterpassword.sys.property", sec.getEncMasterPasswordSystemProperty());
        this.setProperty(properties, "org.ops4j.pax.web.enc.provider", sec.getEncProvider());
        this.setProperty(properties, "org.ops4j.pax.web.enc.algorithm", sec.getEncAlgorithm());
        this.setProperty(properties, "org.ops4j.pax.web.enc.iterationcount", sec.getEncIterationCount());
        this.setProperty(properties, "org.ops4j.pax.web.enc.prefix", sec.getEncPrefix());
        this.setProperty(properties, "org.ops4j.pax.web.enc.suffix", sec.getEncSuffix());
        this.setProperty(properties, "org.ops4j.pax.web.enc.osgi.decryptor", sec.getEncOSGiDecryptorId());
        return properties;
    }

    private void setProperty(Hashtable<String, Object> properties, String name, Object value) {
        if (value != null) {
            if (value instanceof File) {
                properties.put(name, ((File)value).getAbsolutePath());
            } else if (value instanceof Object[]) {
                properties.put(name, Activator.join(",", (Object[])value));
            } else {
                properties.put(name, value.toString());
            }
        } else {
            properties.remove(name);
        }
    }

    private static String join(String token, Object[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < array.length - 1; ++x) {
            if (array[x] != null) {
                if (array[x] instanceof File) {
                    sb.append(((File)array[x]).getAbsolutePath());
                } else {
                    sb.append(array[x].toString());
                }
            } else {
                sb.append("null");
            }
            sb.append(token);
        }
        sb.append(array[array.length - 1]);
        return sb.toString();
    }

    private class ServerListenerCustomizer
    implements ServiceTrackerCustomizer<ServerListener, ServerListener> {
        private ServerListenerCustomizer() {
        }

        public ServerListener addingService(ServiceReference<ServerListener> reference) {
            ServerListener service = (ServerListener)Activator.this.bundleContext.getService(reference);
            ServerController sc = Activator.this.serverController;
            if (sc != null) {
                Activator.this.serverListeners.add(service);
                sc.addListener(service);
            }
            return service;
        }

        public void modifiedService(ServiceReference<ServerListener> reference, ServerListener service) {
        }

        public void removedService(ServiceReference<ServerListener> reference, ServerListener service) {
            ServerController sc = Activator.this.serverController;
            if (sc != null) {
                sc.removeListener(service);
                Activator.this.serverListeners.remove(service);
            }
            if (Activator.this.bundleContext != null) {
                Activator.this.bundleContext.ungetService(reference);
            }
        }
    }

    private class ServerControllerFactoryCustomizer
    implements ServiceTrackerCustomizer<ServerControllerFactory, ServerControllerFactory> {
        private ServerControllerFactoryCustomizer() {
        }

        public ServerControllerFactory addingService(ServiceReference<ServerControllerFactory> reference) {
            ServerControllerFactory controllerFactory = (ServerControllerFactory)Activator.this.bundleContext.getService(reference);
            Activator.this.updateServerControllerFactory(controllerFactory);
            return controllerFactory;
        }

        public void modifiedService(ServiceReference<ServerControllerFactory> reference, ServerControllerFactory service) {
        }

        public void removedService(ServiceReference<ServerControllerFactory> reference, ServerControllerFactory service) {
            if (Activator.this.bundleContext != null) {
                Activator.this.bundleContext.ungetService(reference);
            }
            Activator.this.updateServerControllerFactory(null);
        }
    }

    private class JasyptCustomizer
    implements ServiceTrackerCustomizer<Object, Object> {
        private JasyptCustomizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addingService(ServiceReference<Object> reference) {
            Class<JasyptCustomizer> clazz = JasyptCustomizer.class;
            synchronized (JasyptCustomizer.class) {
                if (!Activator.this.jasyptTracking.get() && Activator.this.serverControllerFactory != null) {
                    Activator.this.performConfiguration();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Activator.this.bundleContext.getService(reference);
            }
        }

        public void modifiedService(ServiceReference<Object> reference, Object service) {
        }

        public void removedService(ServiceReference<Object> reference, Object service) {
            if (!Activator.this.jasyptTracking.get() && Activator.this.serverControllerFactory != null) {
                Activator.this.performConfiguration();
            }
            Activator.this.bundleContext.ungetService(reference);
        }
    }

    private class AddressConfiguration
    implements ServerListener {
        private AddressConfiguration() {
        }

        public void stateChanged(ServerEvent event) {
            if (Activator.this.httpServiceRuntimeReg == null || Activator.this.httpServiceRuntimeReg.getReference() == null) {
                return;
            }
            String[] props = Activator.this.httpServiceRuntimeReg.getReference().getPropertyKeys();
            Hashtable<String, Object> newProps = new Hashtable<String, Object>();
            for (String key : props) {
                ((Dictionary)newProps).put(key, Activator.this.httpServiceRuntimeReg.getReference().getProperty(key));
            }
            if (event.getState() == ServerEvent.State.STARTED) {
                String[] addresses = (String[])Arrays.stream(event.getAddresses()).map(ia -> String.format("%s://%s:%d/", ia.isSecure() ? "https" : "http", ia.getAddress().getAddress().getHostAddress(), ia.getAddress().getPort())).toArray(String[]::new);
                ((Dictionary)newProps).put("osgi.http.endpoint", addresses);
                Activator.this.serverModel.getHttpServiceRuntimeDTO().properties.put("osgi.http.endpoint", addresses);
            } else {
                ((Dictionary)newProps).put("osgi.http.endpoint", "/");
                Activator.this.serverModel.getHttpServiceRuntimeDTO().properties.put("osgi.http.endpoint", "/");
            }
            Activator.this.httpServiceRuntimeReg.setProperties(newProps);
        }
    }
}

