/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.karaf.commands;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.Col;
import org.apache.karaf.shell.support.table.ShellTable;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@Command(scope="web", name="meta", description="Retrieve meta-information about Pax Web.")
@Service
public class MetaCommand
implements Action {
    @Option(name="--http-service-info", description="List obtained HttpService/WebContainer instances.")
    private boolean hsInfo = false;
    @Option(name="--web-usage-count", description="Get information about usage count of services for bundles using HttpService/WebContainer.")
    private boolean usageCountInfo = false;
    @Option(name="-v", aliases={"--verbose"})
    private boolean verbose = false;
    @Reference
    private BundleContext context;

    public Object execute() {
        if (this.hsInfo) {
            ServiceReference ref = this.context.getServiceReference(WebContainer.class);
            if (ref == null) {
                System.out.println(">> Can't get a reference to org.osgi.service.http.HttpService.");
                return null;
            }
            Bundle[] bundles = ref.getUsingBundles();
            TreeMap<Long, Bundle> bundlesMap = new TreeMap<Long, Bundle>();
            if (bundles != null) {
                for (Bundle b2 : bundles) {
                    bundlesMap.put(b2.getBundleId(), b2);
                }
            }
            System.out.println("Registering Bundle: " + String.valueOf(ref.getBundle()));
            System.out.println("Service ID: " + String.valueOf(ref.getProperty("service.id")));
            System.out.println("Service Scope: " + String.valueOf(ref.getProperty("service.scope")));
            System.out.println();
            System.out.println("Bundles referencing the service:");
            ShellTable table = new ShellTable();
            table.column(new Col("Bundle ID"));
            table.column(new Col("Symbolic Name"));
            table.column(new Col("Version"));
            table.column(new Col("Instance ID"));
            table.column(new Col("WebContainer"));
            bundlesMap.values().forEach(b -> {
                WebContainer wcForBundle = (WebContainer)b.getBundleContext().getService(ref);
                table.addRow().addContent(new Object[]{b.getBundleId(), b.getSymbolicName(), b.getVersion(), String.format("0x%x", System.identityHashCode(wcForBundle)), wcForBundle});
                b.getBundleContext().ungetService(ref);
            });
            table.print(System.out);
            System.out.println();
            if (this.verbose) {
                System.out.println("Service Registration Properties:");
                ShellTable table2 = new ShellTable();
                table2.column(new Col("Name"));
                table2.column(new Col("Value"));
                for (String key : ref.getPropertyKeys()) {
                    Object v = ref.getProperty(key);
                    if (v instanceof String[]) {
                        v = "[" + String.join((CharSequence)", ", (String[])v) + "]";
                    }
                    table2.addRow().addContent(new Object[]{key, v});
                }
                table2.print(System.out);
                System.out.println();
            }
        }
        if (this.usageCountInfo) {
            TreeSet<Bundle> bundles = new TreeSet<Bundle>();
            for (Bundle b3 : this.context.getBundles()) {
                if (!"org.ops4j.pax.web.pax-web-extender-war".equals(b3.getSymbolicName()) && !"org.ops4j.pax.web.pax-web-extender-whiteboard".equals(b3.getSymbolicName()) && !"org.ops4j.pax.web.pax-web-karaf".equals(b3.getSymbolicName())) continue;
                bundles.add(b3);
            }
            ServiceReference ref = this.context.getServiceReference(WebContainer.class);
            if (ref == null) {
                System.out.println(">> Can't get a reference to org.osgi.service.http.HttpService.");
                return null;
            }
            TreeMap bundlesMap = new TreeMap();
            if (ref.getUsingBundles() != null) {
                Collections.addAll(bundles, ref.getUsingBundles());
            }
            System.out.println("Registering Bundle: " + String.valueOf(ref.getBundle()));
            System.out.println("Service ID: " + String.valueOf(ref.getProperty("service.id")));
            System.out.println("Service Scope: " + String.valueOf(ref.getProperty("service.scope")));
            System.out.println();
            System.out.println("Usage Counts for bundles referencing the service:");
            ShellTable table = new ShellTable();
            table.column(new Col("Bundle ID"));
            table.column(new Col("Symbolic Name"));
            table.column(new Col("Service ID"));
            table.column(new Col("Scope"));
            table.column(new Col("Service objectClass"));
            table.column(new Col("Usage Count"));
            try {
                Field fFelix = this.context.getClass().getDeclaredField("m_felix");
                fFelix.setAccessible(true);
                Object felix = fFelix.get(this.context);
                Field fRegistry = felix.getClass().getDeclaredField("m_registry");
                fRegistry.setAccessible(true);
                Object registry = fRegistry.get(felix);
                Field fInUseMap = registry.getClass().getDeclaredField("m_inUseMap");
                fInUseMap.setAccessible(true);
                Map inUseMap = (Map)fInUseMap.get(registry);
                for (Bundle b4 : bundles) {
                    Object[] usageCountArray = (Object[])inUseMap.get(b4);
                    if (usageCountArray == null) continue;
                    for (Object uc : usageCountArray) {
                        Field fCount = uc.getClass().getDeclaredField("m_count");
                        fCount.setAccessible(true);
                        AtomicLong count = (AtomicLong)fCount.get(uc);
                        Field fRef = uc.getClass().getDeclaredField("m_ref");
                        fRef.setAccessible(true);
                        ServiceReference sr = (ServiceReference)fRef.get(uc);
                        table.addRow().addContent(new Object[]{b4.getBundleId(), b4.getSymbolicName(), sr.getProperty("service.id"), sr.getProperty("service.scope"), "[" + String.join((CharSequence)", ", Arrays.asList((String[])sr.getProperty("objectClass"))) + "]", count == null ? "-" : (count.get() < 0L ? "-" : Long.valueOf(count.get()))});
                    }
                }
                table.print(System.out);
            }
            catch (Exception e) {
                System.err.println("Can't use reflection to access usage count data: " + e.getMessage());
                return null;
            }
        }
        return null;
    }
}

