/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.jsp;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.Set;
import org.apache.jasper.servlet.TldScanner;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.SimpleInstanceManager;
import org.apache.tomcat.util.scan.StandardJarScanFilter;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.ops4j.pax.web.jsp.InstanceManager;
import org.ops4j.pax.web.jsp.PaxWebTldScanner;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JasperInitializer
extends org.apache.jasper.servlet.JasperInitializer {
    public static final Logger LOG = LoggerFactory.getLogger(JasperInitializer.class);

    @Override
    public void onStartup(Set<Class<?>> types, ServletContext context) throws ServletException {
        Bundle ownerBundle = this.getOwnerBundle(context);
        if (ownerBundle == null) {
            String contextPath = context.getContextPath();
            if ("".equals(contextPath)) {
                contextPath = "/";
            }
            LOG.warn("Can't get a bundle associated with servlet context \"{}\". Is this a valid servlet context: {}?", (Object)contextPath, (Object)context);
            return;
        }
        context.setAttribute(InstanceManager.class.getName(), (Object)new SimpleInstanceManager());
        StandardJarScanner jarScanner = new StandardJarScanner();
        jarScanner.setScanAllDirectories(false);
        jarScanner.setScanAllFiles(false);
        jarScanner.setScanClassPath(false);
        jarScanner.setScanManifest(false);
        jarScanner.setJarScanFilter((JarScanFilter)new StandardJarScanFilter());
        context.setAttribute(JarScanner.class.getName(), (Object)jarScanner);
        super.onStartup(types, context);
    }

    @Override
    protected TldScanner newTldScanner(ServletContext context, boolean namespaceAware, boolean validate, boolean blockExternal) {
        return new PaxWebTldScanner(context, this.getOwnerBundle(context));
    }

    private Bundle getOwnerBundle(ServletContext context) {
        if (context instanceof OsgiServletContext) {
            return ((OsgiServletContext)context).getOsgiContextModel().getOwnerBundle();
        }
        Object attribute = context.getAttribute("osgi-bundlecontext");
        if (attribute instanceof BundleContext) {
            return ((BundleContext)attribute).getBundle();
        }
        if (attribute != null) {
            LOG.warn("Wrong type of {} attribute. Expected {}, got {}", new Object[]{"osgi-bundlecontext", BundleContext.class.getName(), attribute.getClass().getName()});
        }
        return null;
    }
}

