/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.jsp;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.Filter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;

public class InstanceManager
implements org.apache.tomcat.InstanceManager {
    private final Map<String, Map<String, String>> injectionMap = new HashMap<String, Map<String, String>>();
    private final Properties restrictedFilters = new Properties();
    private final Properties restrictedListeners = new Properties();
    private final Map<Class<?>, List<AnnotationCacheEntry>> annotationCache = new WeakHashMap();

    public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException, NoSuchMethodException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = this.loadClassMaybePrivileged(className, classLoader);
        return this.newInstance(clazz.getConstructor(new Class[0]).newInstance(new Object[0]), clazz);
    }

    public Object newInstance(String className, ClassLoader classLoader) throws IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException, NoSuchMethodException {
        Class<?> clazz = classLoader.loadClass(className);
        return this.newInstance(clazz.getConstructor(new Class[0]).newInstance(new Object[0]), clazz);
    }

    public void newInstance(Object o) throws IllegalAccessException, InvocationTargetException {
        this.newInstance(o, o.getClass());
    }

    public Object newInstance(Class<?> clazz) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Object instance;
        try {
            instance = this.newInstance(clazz.getName());
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new InstantiationException("can't create object for class " + String.valueOf(clazz));
        }
        return this.newInstance(instance, clazz);
    }

    private Object newInstance(Object instance, Class<?> clazz) throws IllegalAccessException, InvocationTargetException {
        Map<String, String> injections = this.injectionMap.get(clazz.getName());
        this.populateAnnotationsCache(clazz, injections);
        return instance;
    }

    public void destroyInstance(Object instance) throws IllegalAccessException, InvocationTargetException {
        this.preDestroy(instance, instance.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preDestroy(Object instance, Class<?> clazz) throws IllegalAccessException, InvocationTargetException {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != Object.class) {
            this.preDestroy(instance, superClass);
        }
        List<AnnotationCacheEntry> annotations = null;
        Map<Class<?>, List<AnnotationCacheEntry>> map = this.annotationCache;
        synchronized (map) {
            annotations = this.annotationCache.get(clazz);
        }
        if (annotations == null) {
            return;
        }
        for (AnnotationCacheEntry entry : annotations) {
            Method preDestroy;
            if (entry.getType() != AnnotationCacheEntryType.PRE_DESTROY) continue;
            Method method = preDestroy = InstanceManager.getMethod(clazz, entry);
            synchronized (method) {
                boolean accessibility = preDestroy.canAccess(instance);
                preDestroy.setAccessible(true);
                preDestroy.invoke(instance, new Object[0]);
                preDestroy.setAccessible(accessibility);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateAnnotationsCache(Class<?> clazz, Map<String, String> injections) throws IllegalAccessException, InvocationTargetException {
        while (clazz != null) {
            List<AnnotationCacheEntry> annotations = null;
            Map<Class<?>, List<AnnotationCacheEntry>> map = this.annotationCache;
            synchronized (map) {
                annotations = this.annotationCache.get(clazz);
            }
            if (annotations == null) {
                annotations = new ArrayList<AnnotationCacheEntry>();
                Method[] methods = null;
                methods = clazz.getDeclaredMethods();
                Method postConstruct = null;
                Method preDestroy = null;
                for (Method method : methods) {
                    if (method.isAnnotationPresent(PostConstruct.class)) {
                        if (postConstruct != null || method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.getExceptionTypes().length > 0 || !method.getReturnType().getName().equals("void")) {
                            throw new IllegalArgumentException("Invalid PostConstruct annotation");
                        }
                        postConstruct = method;
                    }
                    if (!method.isAnnotationPresent(PreDestroy.class)) continue;
                    if (preDestroy != null || method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.getExceptionTypes().length > 0 || !method.getReturnType().getName().equals("void")) {
                        throw new IllegalArgumentException("Invalid PreDestroy annotation");
                    }
                    preDestroy = method;
                }
                if (postConstruct != null) {
                    annotations.add(new AnnotationCacheEntry(postConstruct.getName(), postConstruct.getParameterTypes(), null, AnnotationCacheEntryType.POST_CONSTRUCT));
                }
                if (preDestroy != null) {
                    annotations.add(new AnnotationCacheEntry(preDestroy.getName(), preDestroy.getParameterTypes(), null, AnnotationCacheEntryType.PRE_DESTROY));
                }
                if (annotations.size() == 0) {
                    annotations = Collections.emptyList();
                }
                Map<Class<?>, List<AnnotationCacheEntry>> object = this.annotationCache;
                synchronized (object) {
                    this.annotationCache.put(clazz, annotations);
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getAnnotationCacheSize() {
        Map<Class<?>, List<AnnotationCacheEntry>> map = this.annotationCache;
        synchronized (map) {
            return this.annotationCache.size();
        }
    }

    protected Class<?> loadClassMaybePrivileged(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz = classLoader.loadClass(className);
        this.checkAccess(clazz);
        return clazz;
    }

    private void checkAccess(Class<?> clazz) {
        if (Filter.class.isAssignableFrom(clazz)) {
            this.checkAccess(clazz, this.restrictedFilters);
        } else {
            this.checkAccess(clazz, this.restrictedListeners);
        }
    }

    private void checkAccess(Class<?> clazz, Properties restricted) {
        while (clazz != null) {
            if ("restricted".equals(restricted.getProperty(clazz.getName()))) {
                throw new SecurityException("Restricted " + String.valueOf(clazz));
            }
            clazz = clazz.getSuperclass();
        }
    }

    public static String getName(Method setter) {
        StringBuilder name = new StringBuilder(setter.getName());
        name.delete(0, 3);
        name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
        return name.toString();
    }

    private static Method getMethod(Class<?> clazz, AnnotationCacheEntry entry) {
        Method result = null;
        try {
            result = clazz.getDeclaredMethod(entry.getAccessibleObjectName(), entry.getParamTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return result;
    }

    private static final class AnnotationCacheEntry {
        private final String accessibleObjectName;
        private final Class<?>[] paramTypes;
        private final AnnotationCacheEntryType type;

        AnnotationCacheEntry(String accessibleObjectName, Class<?>[] paramTypes, String name, AnnotationCacheEntryType type) {
            this.accessibleObjectName = accessibleObjectName;
            this.paramTypes = paramTypes != null ? Arrays.copyOf(paramTypes, paramTypes.length) : null;
            this.type = type;
        }

        public String getAccessibleObjectName() {
            return this.accessibleObjectName;
        }

        public Class<?>[] getParamTypes() {
            return this.paramTypes;
        }

        public AnnotationCacheEntryType getType() {
            return this.type;
        }
    }

    private static enum AnnotationCacheEntryType {
        FIELD,
        SETTER,
        POST_CONSTRUCT,
        PRE_DESTROY;

    }
}

