/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.DefaultUserIdentity;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ServletRequestHttpWrapper;
import org.eclipse.jetty.server.ServletResponseHttpWrapper;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.MultiException;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.jetty.internal.PaxWebFilterHolder;
import org.ops4j.pax.web.service.jetty.internal.PaxWebFilterMapping;
import org.ops4j.pax.web.service.jetty.internal.PaxWebServletHolder;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.servlet.OsgiFilterChain;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiSessionAttributeListener;
import org.ops4j.pax.web.service.spi.servlet.PreprocessorFilterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxWebServletHandler
extends ServletHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PaxWebServletHandler.class);
    private final List<PreprocessorFilterConfig> preprocessors = new LinkedList<PreprocessorFilterConfig>();
    private OsgiServletContext defaultServletContext;
    private OsgiContextModel defaultOsgiContextModel;
    private WebContainerContext defaultWebContainerContext;
    private final OsgiSessionAttributeListener osgiSessionsBridge;
    private final Servlet default404Servlet;
    private final ThreadLocal<PaxWebServletHolder> currentServletHolder = new ThreadLocal();

    PaxWebServletHandler(Servlet default404Servlet, OsgiSessionAttributeListener osgiSessionsBridge) {
        this.setEnsureDefaultServlet(true);
        this.setFilterChainsCached(true);
        int cacheSize = this.getMaxFilterChainsCacheSize();
        this.setMaxFilterChainsCacheSize(2 * cacheSize);
        this.setFilters(new PaxWebFilterHolder[0]);
        this.default404Servlet = default404Servlet;
        this.osgiSessionsBridge = osgiSessionsBridge;
    }

    public void setDefaultServletContext(OsgiServletContext defaultServletContext) {
        this.defaultServletContext = defaultServletContext;
    }

    public OsgiServletContext getDefaultServletContext() {
        return this.defaultServletContext;
    }

    public void setDefaultOsgiContextModel(OsgiContextModel defaultOsgiContextModel, WebContainerContext resolvedWebContainerContext) {
        this.defaultOsgiContextModel = defaultOsgiContextModel;
        this.defaultWebContainerContext = resolvedWebContainerContext;
    }

    public OsgiContextModel getDefaultOsgiContextModel() {
        return this.defaultOsgiContextModel;
    }

    protected synchronized void doStart() throws Exception {
        if (this.getServletMapping("/") == null && this.isEnsureDefaultServlet()) {
            this.addServletWithMapping(new PaxWebServletHolder("default", this.default404Servlet, true), "/");
            this.getServletMapping("/").setDefault(true);
        }
        super.doStart();
    }

    public void initialize() throws Exception {
        for (PreprocessorFilterConfig fc : this.preprocessors) {
            fc.getInstance().init((FilterConfig)fc);
        }
        try {
            super.initialize();
        }
        catch (MultiException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    protected synchronized void doStop() throws Exception {
        ArrayList<PaxWebFilterHolder> newFilters = new ArrayList<PaxWebFilterHolder>();
        ArrayList<PaxWebFilterMapping> newFilterMappings = new ArrayList<PaxWebFilterMapping>();
        for (FilterHolder fh : this.getFilters()) {
            PaxWebFilterHolder pwfh;
            if (!(fh instanceof PaxWebFilterHolder) || (pwfh = (PaxWebFilterHolder)fh).getFilterModel() == null || pwfh.getFilterModel().isDynamic()) continue;
            newFilters.add(pwfh);
            newFilterMappings.addAll(pwfh.getMapping());
        }
        this.setFilters(newFilters.toArray(new PaxWebFilterHolder[0]));
        this.setFilterMappings(newFilterMappings.toArray(new PaxWebFilterMapping[0]));
        for (PreprocessorFilterConfig fc : this.preprocessors) {
            fc.destroy();
        }
        super.doStop();
    }

    public synchronized void setServlets(ServletHolder[] holders) {
        for (ServletHolder holder : holders) {
            if (holder instanceof PaxWebServletHolder) continue;
            throw new IllegalArgumentException("This ServletHandler should manage only PaxWebServletHolders");
        }
        super.setServlets(holders);
    }

    public void addServletWithMapping(PaxWebServletHolder holder, ServletMapping mapping) {
        holder.setMapping(mapping);
        this.addServlet(holder);
        this.addServletMapping(mapping);
    }

    public void addFilterWithMapping(FilterHolder holder, String pathSpec, EnumSet<DispatcherType> dispatches) {
        if (holder instanceof PaxWebFilterHolder) {
            super.addFilterWithMapping(holder, pathSpec, dispatches);
            return;
        }
        PaxWebFilterHolder paxWebFilterHolder = new PaxWebFilterHolder(holder, this.defaultServletContext);
        super.addFilterWithMapping((FilterHolder)paxWebFilterHolder, pathSpec, dispatches);
    }

    public void removeServletWithMapping(ServletModel model) {
        Object[] holders = this.getServlets();
        Object[] mappings = this.getServletMappings();
        if (holders != null && mappings != null) {
            PaxWebServletHolder holder = (PaxWebServletHolder)this.getServlet(model.getName());
            if (holder == null) {
                throw new IllegalArgumentException("Can't unregister servlet named \"" + model.getName() + "\" from Jetty servlet handler of " + this.defaultOsgiContextModel.getContextPath() + " context");
            }
            ServletMapping mapping = holder.getMapping();
            this.setServlets((ServletHolder[])ArrayUtil.removeFromArray((Object[])holders, (Object)((Object)holder)));
            this.setServletMappings((ServletMapping[])ArrayUtil.removeFromArray((Object[])mappings, (Object)mapping));
            LOG.debug("Stopping servlet holder {}", (Object)holder);
            try {
                holder.stop();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (this.getServletMapping("/") == null && this.isEnsureDefaultServlet()) {
            this.addServletWithMapping(new PaxWebServletHolder("default", this.default404Servlet, true), "/");
            this.getServletMapping("/").setDefault(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if ("TRACE".equals(request.getMethod())) {
            response.sendError(405);
            baseRequest.setHandled(true);
            return;
        }
        PaxWebServletHolder servletHolder = (PaxWebServletHolder)baseRequest.getUserIdentityScope();
        try {
            HttpServletResponse res;
            FilterChain chain = this.getOsgiFilterChain(baseRequest, target, servletHolder);
            HttpServletRequest req = request;
            if (req instanceof ServletRequestHttpWrapper) {
                req = ((ServletRequestHttpWrapper)req).getRequest();
            }
            if ((res = response) instanceof ServletResponseHttpWrapper) {
                res = ((ServletResponseHttpWrapper)res).getResponse();
            }
            servletHolder.prepare(baseRequest, (ServletRequest)req, (ServletResponse)res);
            if (chain != null) {
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
            } else {
                servletHolder.handle(baseRequest, (ServletRequest)req, (ServletResponse)res);
            }
        }
        finally {
            if (servletHolder != null) {
                baseRequest.setHandled(true);
            }
        }
    }

    protected FilterChain getOsgiFilterChain(Request baseRequest, String pathInContext, ServletHolder servletHolder) {
        PaxWebServletHolder holder = (PaxWebServletHolder)servletHolder;
        FilterChain chain = this.getFilterChain(baseRequest, pathInContext, servletHolder);
        if (chain == null) {
            chain = (request, response) -> holder.handle(baseRequest, request, response);
        }
        Consumer<HttpServletRequest> authListener = req -> {
            Object user = req.getAttribute("org.osgi.service.http.authentication.remote.user");
            Object authType = req.getAttribute("org.osgi.service.http.authentication.type");
            if (!(user == null && authType == null || baseRequest.getAuthentication() != null && baseRequest.getAuthentication() != Authentication.UNAUTHENTICATED)) {
                String userName = user != null ? user.toString() : null;
                String authMethod = authType != null ? authType.toString() : null;
                AbstractLoginService.UserPrincipal p = new AbstractLoginService.UserPrincipal(userName, null);
                Subject s = new Subject(true, Collections.singleton(p), Collections.emptySet(), Collections.emptySet());
                baseRequest.setAuthentication((Authentication)new UserAuthentication(authMethod, (UserIdentity)new DefaultUserIdentity(s, (Principal)p, new String[0])));
            }
        };
        List preprocessorInstances = this.preprocessors.stream().map(PreprocessorFilterConfig::getInstance).collect(Collectors.toList());
        if (!holder.is404()) {
            return new OsgiFilterChain(new ArrayList(preprocessorInstances), holder.getServletContext(), holder.getWebContainerContext(), chain, this.osgiSessionsBridge, authListener);
        }
        return new OsgiFilterChain(new ArrayList(preprocessorInstances), (ServletContext)this.defaultServletContext, this.defaultWebContainerContext, chain, this.osgiSessionsBridge, authListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FilterChain getFilterChain(Request baseRequest, String pathInContext, ServletHolder servletHolder) {
        String prefix;
        PaxWebServletHolder holder = (PaxWebServletHolder)servletHolder;
        WebContainerContext wcc = holder.getWebContainerContext();
        String string = prefix = wcc == null ? "" : wcc.getContextId() + "|";
        if (wcc != null && wcc.isShared()) {
            prefix = "~|" + prefix;
        }
        String contextlessKey = pathInContext == null ? holder.getName() : pathInContext;
        String key = prefix + contextlessKey;
        int dispatch = FilterMapping.dispatch((DispatcherType)baseRequest.getDispatcherType());
        FilterChain chain = (FilterChain)this._chainCache[dispatch].get(key);
        if (chain != null) {
            return chain;
        }
        this._chainCache[dispatch].remove(contextlessKey);
        this.currentServletHolder.set(holder);
        try {
            chain = super.getFilterChain(baseRequest, pathInContext, servletHolder);
        }
        finally {
            this.currentServletHolder.remove();
        }
        if (chain != null) {
            this._chainCache[dispatch].put(key, chain);
        }
        return chain;
    }

    protected FilterChain newFilterChain(FilterHolder filterHolder, FilterChain chain) {
        PaxWebFilterHolder fHolder;
        PaxWebServletHolder holder = this.currentServletHolder.get();
        OsgiContextModel targetContext = holder.getOsgiContextModel();
        if (targetContext == null) {
            targetContext = this.defaultOsgiContextModel;
        }
        if ((fHolder = (PaxWebFilterHolder)filterHolder).matches(targetContext)) {
            return super.newFilterChain(filterHolder, chain);
        }
        return chain;
    }

    public List<PreprocessorFilterConfig> getPreprocessors() {
        return this.preprocessors;
    }
}

