/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal.web;

import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.UnavailableException;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.ops4j.pax.web.service.jetty.internal.web.DefaultServlet;
import org.ops4j.pax.web.service.jetty.internal.web.RootBundleURLResource;
import org.ops4j.pax.web.service.spi.servlet.OsgiScopedServletContext;
import org.ops4j.pax.web.service.spi.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyResourceServlet
extends DefaultServlet {
    public static final Logger LOG = LoggerFactory.getLogger(JettyResourceServlet.class);
    private final PathResource baseUrlResource;
    private final String chroot;
    private String[] welcomeFiles;

    public JettyResourceServlet(PathResource baseUrlResource, String chroot) {
        this.baseUrlResource = baseUrlResource;
        this.chroot = chroot;
    }

    @Override
    public void init() throws UnavailableException {
        super.init();
        this._welcomes = this.welcomeFiles;
        String maxCacheSize = this.getInitParameter("maxCacheSize");
        String maxCachedFileSize = this.getInitParameter("maxCachedFileSize");
        String maxCachedFiles = this.getInitParameter("maxCachedFiles");
        if (maxCacheSize == null) {
            maxCacheSize = Integer.toString(0x400000);
        }
        if (maxCachedFileSize == null) {
            maxCachedFileSize = Integer.toString(0x200000);
        }
        if (maxCachedFiles == null) {
            maxCachedFiles = "2048";
        }
        LOG.info("Initialized Jetty Resource Servlet for base=\"{}\" with cache maxSize={}kB, maxEntrySize={}kB, maxEntries={}", new Object[]{this.baseUrlResource != null ? this.baseUrlResource.getPath() : this.chroot, Integer.parseInt(maxCacheSize) / 1024, Integer.parseInt(maxCachedFileSize) / 1024, maxCachedFiles});
    }

    public void setWelcomeFiles(String[] welcomeFiles) {
        this.welcomeFiles = welcomeFiles;
        this._welcomes = welcomeFiles;
        if (this._cache != null) {
            this._cache.flushCache();
        }
    }

    public void setWelcomeFilesRedirect(boolean welcomeFilesRedirect) {
        this._resourceService.setRedirectWelcome(welcomeFilesRedirect);
    }

    @Override
    protected ContextHandler initContextHandler(ServletContext servletContext) {
        if (servletContext instanceof ContextHandler.Context) {
            return ((ContextHandler.Context)servletContext).getContextHandler();
        }
        return ((ContextHandler.Context)((OsgiScopedServletContext)servletContext).getContainerServletContext()).getContextHandler();
    }

    @Override
    public Resource getResource(String pathInContext) {
        String childPath = Path.securePath((String)pathInContext);
        if (childPath == null) {
            return null;
        }
        if (childPath.startsWith("/")) {
            childPath = childPath.substring(1);
        }
        try {
            if (this.baseUrlResource != null) {
                if ("".equals(childPath)) {
                    return this.baseUrlResource;
                }
                return this.baseUrlResource.addPath(childPath);
            }
            URL url = this.getServletContext().getResource(this.chroot + "/" + childPath);
            if (url != null && "bundle".equals(url.getProtocol())) {
                URL fixedURL;
                Resource properDirectory;
                Resource potentialDirectory;
                if ("/".equals(url.getPath())) {
                    return new RootBundleURLResource(Resource.newResource((URL)url));
                }
                if (!url.getPath().endsWith("/") && (potentialDirectory = Resource.newResource((URL)url)).exists() && potentialDirectory.length() == 0L && (properDirectory = Resource.newResource((URL)(fixedURL = new URL(url.toExternalForm() + "/")))).exists()) {
                    return properDirectory;
                }
            }
            return Resource.newResource((URL)url);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

