/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.http.pathmap.MatchedResource;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.session.DefaultSessionIdManager;
import org.eclipse.jetty.session.SessionManager;
import org.ops4j.pax.web.service.jetty.internal.PaxWebServletHolder;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxWebSessionIdManager
extends DefaultSessionIdManager {
    public static final Logger LOG = LoggerFactory.getLogger(PaxWebSessionIdManager.class);

    public PaxWebSessionIdManager(Server server) {
        super(server);
    }

    public static String getSessionIdSuffix(Request r) {
        ServletHolder servletHolder;
        ServletContextRequest req = (ServletContextRequest)Request.as((Request)r, ServletContextRequest.class);
        MatchedResource match = req.getMatchedResource();
        if (match != null && match.getResource() != null && (servletHolder = ((ServletHandler.MappedServlet)match.getResource()).getServletHolder()) instanceof PaxWebServletHolder) {
            PaxWebServletHolder holder = (PaxWebServletHolder)servletHolder;
            OsgiContextModel ocm = holder.getOsgiContextModel();
            if (ocm == null || ocm.getTemporaryLocation() == null) {
                return "";
            }
            return "~" + ocm.getTemporaryLocation().replaceAll("/", "#").replaceAll("_", "#");
        }
        return "";
    }

    public String renewSessionId(String oldClusterId, String oldNodeId, Request request) {
        Object newClusterId = this.newSessionId(request.hashCode());
        int id1 = oldClusterId.indexOf("~");
        if (id1 > 0) {
            newClusterId = (String)newClusterId + oldClusterId.substring(id1);
        }
        for (SessionManager manager : this.getSessionManagers()) {
            try {
                manager.renewSessionId(oldClusterId, oldNodeId, (String)newClusterId, this.getExtendedId((String)newClusterId, request));
            }
            catch (Exception e) {
                LOG.warn("Problem renewing session id {} to {}", new Object[]{oldClusterId, newClusterId, e});
            }
        }
        return newClusterId;
    }

    public String newSessionId(Request request, String requestedId, long created) {
        if (request == null) {
            return this.newSessionId(created);
        }
        String suffix = PaxWebSessionIdManager.getSessionIdSuffix(request);
        if (suffix != null) {
            if (requestedId == null) {
                return super.newSessionId(request, requestedId, created) + suffix;
            }
            String sid = this.getId(requestedId);
            return sid + suffix;
        }
        return super.newSessionId(request, requestedId, created);
    }
}

