/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextRequest;
import org.eclipse.jetty.session.ManagedSession;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.resource.PathResourceFactory;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.URLResourceFactory;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.ops4j.pax.web.service.jetty.internal.PaxWebSessionHandler;
import org.ops4j.pax.web.service.jetty.internal.PaxWebSessionIdManager;
import org.ops4j.pax.web.service.jetty.internal.web.JettyResourceServlet;
import org.ops4j.pax.web.service.jetty.internal.web.RootBundleURLResource;
import org.ops4j.pax.web.service.spi.config.Configuration;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerKey;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerModel;
import org.ops4j.pax.web.service.spi.servlet.SCIWrapper;
import org.ops4j.pax.web.service.spi.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxWebServletContextHandler
extends ServletContextHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PaxWebServletContextHandler.class);
    private static final PathResourceFactory RESOURCE_FACTORY = new PathResourceFactory();
    private static final URLResourceFactory URL_RESOURCE_FACTORY = new URLResourceFactory();
    private final Collection<SCIWrapper> servletContainerInitializers = new TreeSet<SCIWrapper>();
    private ServletContext osgiServletContext;
    private final Map<EventListenerKey, EventListener> rankedListeners = new TreeMap<EventListenerKey, EventListener>();
    private final List<EventListener> orderedListeners = new ArrayList<EventListener>();
    private final ThreadLocal<Boolean> isCallingSCI = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private final Set<String> attributesToClearBeforeRestart = new HashSet<String>();

    public PaxWebServletContextHandler(String contextPath, Configuration configuration) {
        super(contextPath, true, true);
        ScheduledExecutorScheduler executorScheduler = new ScheduledExecutorScheduler(this.getSessionHandler().toString() + "Timer", true, ((Object)((Object)this)).getClass().getClassLoader());
        super.setAttribute("org.eclipse.jetty.server.session.timer", (Object)executorScheduler);
        this.setLogger(LoggerFactory.getLogger((String)(this.getDisplayName() == null ? this.getContextPath() : this.getDisplayName())));
        this.setProtectedTargets(new String[]{"/WEB-INF", "/META-INF", "/OSGI-INF", "/OSGI-OPT"});
    }

    public static Resource toJettyResource(URL url) throws MalformedURLException {
        if (url != null && ("bundle".equals(url.getProtocol()) || "bundleentry".equals(url.getProtocol()))) {
            URL fixedURL;
            Resource properDirectory;
            Resource potentialDirectory;
            if ("/".equals(url.getPath())) {
                return new RootBundleURLResource(URL_RESOURCE_FACTORY.newResource(url));
            }
            if (!url.getPath().endsWith("/") && (potentialDirectory = URL_RESOURCE_FACTORY.newResource(url)).exists() && potentialDirectory.length() == 0L && (properDirectory = URL_RESOURCE_FACTORY.newResource(fixedURL = new URL(url.toExternalForm() + "/"))).exists()) {
                return properDirectory;
            }
        }
        return url == null ? null : URL_RESOURCE_FACTORY.newResource(url);
    }

    public void setServletContainerInitializers(Collection<SCIWrapper> wrappers) {
        this.servletContainerInitializers.clear();
        this.servletContainerInitializers.addAll(wrappers);
    }

    public void setOsgiServletContext(ServletContext osgiServletContext) {
        this.osgiServletContext = osgiServletContext;
    }

    public ServletContext getOsgiServletContext() {
        return this.osgiServletContext;
    }

    public void callContextInitialized(ServletContextListener l, ServletContextEvent e) {
        super.callContextInitialized(l, new ServletContextEvent(this.osgiServletContext));
    }

    public void callContextDestroyed(ServletContextListener l, ServletContextEvent e) {
        super.callContextDestroyed(l, new ServletContextEvent(this.osgiServletContext));
    }

    public boolean addEventListener(EventListener listener) {
        return this.addEventListener(null, listener);
    }

    public boolean addEventListener(EventListenerModel model, EventListener listener) {
        if (model == null || model.isDynamic()) {
            this.orderedListeners.add(listener);
        } else {
            this.rankedListeners.put(EventListenerKey.ofModel((EventListenerModel)model), listener);
        }
        if (!ServletContextListener.class.isAssignableFrom(listener.getClass()) && this.isStarted()) {
            super.addEventListener(listener);
        }
        return true;
    }

    protected void addProgrammaticListener(EventListener listener) {
        this.orderedListeners.add(listener);
    }

    public boolean removeEventListener(EventListener listener) {
        this.removeEventListener(null, listener);
        return super.removeEventListener(listener);
    }

    public void removeEventListener(EventListenerModel model, EventListener listener) {
        if (model == null || model.isDynamic()) {
            this.orderedListeners.remove(listener);
        } else {
            this.rankedListeners.remove(EventListenerKey.ofModel((EventListenerModel)model));
        }
    }

    protected void startContext() throws Exception {
        for (String name : this.attributesToClearBeforeRestart) {
            this.removeAttribute(name);
        }
        this.attributesToClearBeforeRestart.clear();
        this.servletContainerInitializers.forEach(wrapper -> {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                this.getContext().setExtendedListenerTypes(true);
                Thread.currentThread().setContextClassLoader(this.getClassLoader());
                this.isCallingSCI.set(true);
                wrapper.onStartup();
            }
            catch (ServletException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.isCallingSCI.remove();
                Thread.currentThread().setContextClassLoader(tccl);
                this.getContext().setExtendedListenerTypes(false);
            }
        });
        for (int pos = 0; pos < this.orderedListeners.size(); ++pos) {
            EventListener el = this.orderedListeners.get(pos);
            this.rankedListeners.put(EventListenerKey.ofPosition((int)pos), el);
        }
        for (EventListener el : this.rankedListeners.values()) {
            super.addEventListener(el);
        }
        super.startContext();
    }

    public Object setAttribute(String name, Object value) {
        if (this.isCallingSCI.get().booleanValue()) {
            this.attributesToClearBeforeRestart.add(name);
        }
        return super.setAttribute(name, value);
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.setEventListeners(Collections.emptyList());
        this.getSessionHandler().getEventListeners().clear();
        this.rankedListeners.entrySet().removeIf(e -> ((EventListenerKey)e.getKey()).getRanklessPosition() >= 0);
        this.orderedListeners.clear();
    }

    protected void requestInitialized(Request baseRequest, HttpServletRequest request) {
        SessionHandler sessionHandler = this.getSessionHandler();
        if (sessionHandler instanceof PaxWebSessionHandler) {
            PaxWebSessionHandler sessionHandler2 = (PaxWebSessionHandler)sessionHandler;
            ServletContextRequest scr = (ServletContextRequest)Request.as((Request)baseRequest, ServletContextRequest.class);
            String sid = request.getRequestedSessionId();
            if (sid != null && baseRequest.getSession(false) == null) {
                Object baseSid = sessionHandler2.getSessionIdManager().getId(sid);
                baseSid = (String)baseSid + PaxWebSessionIdManager.getSessionIdSuffix(baseRequest);
                sid = sessionHandler2.getSessionIdManager().getExtendedId((String)baseSid, baseRequest);
                ManagedSession session = sessionHandler2.getManagedSession(sid);
                if (session != null && session.isValid()) {
                    scr.setManagedSession(session);
                }
            }
        }
        super.requestInitialized(baseRequest, request);
    }

    protected boolean handleByContextHandler(String pathInContext, ContextRequest request, Response response, Callback callback) {
        if ("TRACE".equals(request.getMethod())) {
            Response.writeError((Request)request, (Response)response, (Callback)callback, (int)405, null);
            return true;
        }
        return super.handleByContextHandler(pathInContext, request, response, callback);
    }

    protected void handleMovedPermanently(Request request, Response response, Callback callback) {
        String location = this.getContextPath() + "/";
        if (request.getHttpURI().getParam() != null) {
            location = location + ";" + request.getHttpURI().getParam();
        }
        if (request.getHttpURI().getQuery() != null) {
            location = location + ";" + request.getHttpURI().getQuery();
        }
        response.setStatus(302);
        response.getHeaders().add(new HttpField(HttpHeader.LOCATION, location));
        callback.succeeded();
    }

    public Resource getBaseResource() {
        Resource resource = JettyResourceServlet.BASE_RESOURCE.get();
        return resource == null ? super.getBaseResource() : resource;
    }

    public Resource getResource(String path) throws MalformedURLException {
        URL url;
        Resource resource;
        String childPath = Path.securePath((String)path);
        if (childPath == null) {
            return null;
        }
        if (childPath.startsWith("/")) {
            childPath = childPath.substring(1);
        }
        if ((resource = PaxWebServletContextHandler.toJettyResource(url = this.osgiServletContext.getResource("/" + childPath))) == null) {
            return super.getResource(path);
        }
        return resource;
    }

    protected SessionHandler newSessionHandler() {
        return new PaxWebSessionHandler();
    }
}

