/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.UnavailableException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.jetty.ee10.servlet.BaseHolder;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.ops4j.pax.web.service.jetty.internal.PaxWebFilterMapping;
import org.ops4j.pax.web.service.jetty.internal.web.PaxWebWebSocketUpgradeFilter;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.servlet.OsgiInitializedFilter;
import org.ops4j.pax.web.service.spi.servlet.OsgiScopedServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxWebFilterHolder
extends FilterHolder {
    public static final Logger LOG = LoggerFactory.getLogger(PaxWebFilterHolder.class);
    private final FilterModel filterModel;
    private ServiceReference<Filter> filterReference;
    private final OsgiServletContext osgiServletContext;
    private final OsgiScopedServletContext servletContext;
    private List<PaxWebFilterMapping> mapping;
    private ServiceObjects<Filter> serviceObjects;
    private boolean whiteboardTCCL;

    public PaxWebFilterHolder(FilterModel filterModel, OsgiServletContext osgiServletContext) {
        this.filterModel = filterModel;
        this.osgiServletContext = osgiServletContext;
        if (filterModel != null) {
            this.setName(filterModel.getName());
            if (filterModel.getFilterClass() != null) {
                this.setHeldClass(filterModel.getFilterClass());
            } else if (filterModel.getFilter() != null) {
                this.setFilter(filterModel.getFilter());
            } else {
                this.filterReference = filterModel.getElementReference();
            }
            this.setInitParameters(filterModel.getInitParams());
            this.setAsyncSupported(filterModel.getAsyncSupported() != null && filterModel.getAsyncSupported() != false);
        }
        this.servletContext = filterModel != null ? new OsgiScopedServletContext(this.osgiServletContext, filterModel.getRegisteringBundle()) : null;
    }

    public PaxWebFilterHolder(FilterHolder holder, OsgiServletContext defaultServletContext) {
        this.filterModel = null;
        this.osgiServletContext = defaultServletContext;
        this.servletContext = null;
        this.setName(holder.getName());
        this.setAsyncSupported(holder.isAsyncSupported());
        this.setInitParameters(holder.getInitParameters());
        try {
            Method getInstance = BaseHolder.class.getDeclaredMethod("getInstance", new Class[0]);
            getInstance.setAccessible(true);
            this.setFilter((Filter)getInstance.invoke((Object)holder, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("Can't manage dynamic filter: {}", (Object)e.getMessage(), (Object)e);
        }
        this.setClassName(holder.getClassName());
        this.setDisplayName(holder.getDisplayName());
        this.setHeldClass(holder.getHeldClass());
        this.setServletHandler(holder.getServletHandler());
    }

    public void doStart() throws Exception {
        if (this.filterReference != null) {
            this.setHeldClass(Filter.class);
        } else if (this.filterModel != null && this.filterModel.getElementSupplier() != null) {
            this.setHeldClass(((Filter)this.filterModel.getElementSupplier().get()).getClass());
        }
        super.doStart();
    }

    protected synchronized Filter getInstance() {
        BundleContext context;
        Filter instance = (Filter)super.getInstance();
        if (instance == null && this.filterReference != null && (context = this.filterModel.getRegisteringBundle().getBundleContext()) != null) {
            if (!this.filterModel.isPrototype()) {
                instance = (Filter)context.getService(this.filterReference);
            } else {
                this.serviceObjects = context.getServiceObjects(this.filterReference);
                instance = (Filter)this.serviceObjects.getService();
            }
        }
        if (instance == null && this.filterModel.getElementSupplier() != null) {
            instance = (Filter)this.filterModel.getElementSupplier().get();
        }
        if (instance == null && this.getHeldClass() != null) {
            Class heldClass = this.getHeldClass();
            try {
                Constructor ctr = heldClass.getConstructor(new Class[0]);
                instance = (Filter)ctr.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't instantiate Filter with class " + String.valueOf(heldClass), e);
            }
        }
        if (instance == null) {
            this.filterModel.setDtoFailureCode(5);
        }
        if (instance != null && "org.eclipse.jetty.ee10.websocket.servlet.WebSocketUpgradeFilter".equals(instance.getClass().getName())) {
            instance = new PaxWebWebSocketUpgradeFilter(instance);
        }
        return instance == null ? null : new OsgiInitializedFilter(instance, this.filterModel, (ServletContext)(this.servletContext == null ? this.osgiServletContext : this.servletContext), this.whiteboardTCCL);
    }

    public void destroyInstance(Object o) {
        super.destroyInstance(o);
        if (this.filterModel != null && this.filterReference != null) {
            if (!this.filterModel.isPrototype()) {
                BundleContext context = this.filterModel.getRegisteringBundle().getBundleContext();
                if (context != null) {
                    context.ungetService(this.filterReference);
                }
            } else {
                Filter realFilter = (Filter)o;
                if (realFilter instanceof FilterHolder.Wrapper) {
                    realFilter = ((FilterHolder.Wrapper)realFilter).getWrapped();
                }
                if (realFilter instanceof OsgiInitializedFilter) {
                    realFilter = ((OsgiInitializedFilter)realFilter).getDelegate();
                }
                this.serviceObjects.ungetService((Object)realFilter);
            }
        }
        if (this.filterModel != null && this.filterModel.getRegisteringBundle() != null) {
            this.servletContext.releaseWebContainerContext(this.filterModel.getRegisteringBundle());
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.isStarted()) {
            String name = this.getName();
            if (name == null) {
                name = this.getClassName();
            }
            if (name == null) {
                name = this.toString();
            }
            throw new UnavailableException("Filter " + name + " is unavailable");
        }
        super.doFilter(request, response, chain);
    }

    public boolean matches(OsgiContextModel targetContext) {
        return this.filterModel == null || this.filterModel.getContextModels().contains(targetContext);
    }

    public FilterModel getFilterModel() {
        return this.filterModel;
    }

    public void setMapping(List<PaxWebFilterMapping> mapping) {
        this.mapping = mapping;
    }

    public List<PaxWebFilterMapping> getMapping() {
        return this.mapping;
    }

    public void setWhiteboardTCCL(boolean whiteboardTCCL) {
        this.whiteboardTCCL = whiteboardTCCL;
    }
}

