/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.util.Enumeration;
import org.ops4j.pax.web.service.spi.servlet.OsgiHttpServletRequestWrapper;
import org.ops4j.pax.web.service.spi.servlet.OsgiScopedServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;

public class PaxWebWebSocketUpgradeFilter
implements Filter {
    private final Filter delegate;

    public PaxWebWebSocketUpgradeFilter(Filter delegate) {
        this.delegate = delegate;
    }

    public void init(final FilterConfig filterConfig) throws ServletException {
        this.delegate.init(new FilterConfig(){

            public String getFilterName() {
                return filterConfig.getFilterName();
            }

            public ServletContext getServletContext() {
                ServletContext servletContext = filterConfig.getServletContext();
                if (servletContext instanceof OsgiServletContext) {
                    OsgiServletContext osc = (OsgiServletContext)servletContext;
                    return osc.getContainerServletContext();
                }
                if (servletContext instanceof OsgiScopedServletContext) {
                    OsgiScopedServletContext osc = (OsgiScopedServletContext)servletContext;
                    return osc.getContainerServletContext();
                }
                return servletContext;
            }

            public String getInitParameter(String name) {
                return filterConfig.getInitParameter(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return filterConfig.getInitParameterNames();
            }
        });
    }

    public void doFilter(final ServletRequest externalRequest, ServletResponse externalResponse, FilterChain chain) throws IOException, ServletException {
        this.delegate.doFilter((ServletRequest)new HttpServletRequestWrapper((HttpServletRequest)externalRequest){

            public ServletContext getServletContext() {
                if (externalRequest instanceof OsgiHttpServletRequestWrapper) {
                    return ((OsgiHttpServletRequestWrapper)externalRequest).getRequest().getServletContext();
                }
                return externalRequest.getServletContext();
            }
        }, externalResponse, (request, response) -> chain.doFilter(externalRequest, externalResponse));
    }

    public void destroy() {
        this.delegate.destroy();
    }
}

