/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal.web;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.ops4j.pax.web.service.jetty.internal.PaxWebServletContextHandler;
import org.ops4j.pax.web.service.jetty.internal.web.EmptyResource;
import org.ops4j.pax.web.service.jetty.internal.web.EquinoxBundleentryDirectoryURLResource;

public class PaxWebResource
extends Resource {
    private final ServletContext servletContext;
    private final PathResource baseUrlResource;
    private final String chroot;
    private final Resource realBaseResource;
    private boolean directFileMapping = false;

    public PaxWebResource(ServletContext servletContext, PathResource baseUrlResource, String chroot) {
        this.servletContext = servletContext;
        this.baseUrlResource = baseUrlResource;
        this.chroot = chroot;
        if (this.baseUrlResource != null) {
            this.realBaseResource = this.baseUrlResource;
        } else if (this.chroot != null) {
            this.realBaseResource = new EmptyResource(){

                @Override
                public Resource resolve(String subUriPath) {
                    return PaxWebResource.this.resolve(subUriPath);
                }

                @Override
                public boolean isReadable() {
                    return true;
                }

                @Override
                public boolean isDirectory() {
                    return true;
                }
            };
            try {
                URL url = this.servletContext.getResource(chroot);
                this.directFileMapping = url != null && !url.getPath().endsWith("/");
            }
            catch (Exception exception) {}
        } else {
            throw new IllegalArgumentException("baseUrlResource and chroot can't both be null");
        }
    }

    public Path getPath() {
        return this.realBaseResource.getPath();
    }

    public boolean isDirectory() {
        return this.realBaseResource.isDirectory();
    }

    public boolean isReadable() {
        return this.realBaseResource.isReadable();
    }

    public URI getURI() {
        return this.realBaseResource.getURI();
    }

    public String getName() {
        return this.realBaseResource.getName();
    }

    public String getFileName() {
        return this.realBaseResource.getFileName();
    }

    public Resource resolve(String pathInContext) {
        String childPath = org.ops4j.pax.web.service.spi.util.Path.securePath((String)pathInContext);
        if (childPath == null) {
            return null;
        }
        if (childPath.startsWith("/")) {
            childPath = childPath.substring(1);
        }
        try {
            if (this.baseUrlResource != null) {
                if (childPath.isEmpty()) {
                    return this.baseUrlResource;
                }
                return this.baseUrlResource.resolve(childPath);
            }
            URL url = this.servletContext.getResource((String)(this.directFileMapping ? this.chroot : this.chroot + "/" + childPath));
            if (url != null && "bundleentry".equals(url.getProtocol()) && url.getPath() != null && url.getPath().endsWith("/")) {
                return new EquinoxBundleentryDirectoryURLResource(PaxWebServletContextHandler.toJettyResource(url));
            }
            return PaxWebServletContextHandler.toJettyResource(url);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

