/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.Callback;
import org.ops4j.pax.web.service.jetty.internal.JettyServerControllerFactory;
import org.ops4j.pax.web.service.jetty.internal.PriorityValue;

public class PrioritizedHandlerCollection
extends ContextHandlerCollection {
    protected final ContextHandlerCollection handlerCollectionBefore = new ContextHandlerCollection(new ContextHandler[0]);
    protected final ContextHandlerCollection handlerCollectionAfter = new ContextHandlerCollection(new ContextHandler[0]);
    private final Set<PriorityValue<Handler>> handlersBefore = new TreeSet(JettyServerControllerFactory.priorityComparator);
    private final Set<PriorityValue<Handler>> handlersAfter = new TreeSet(JettyServerControllerFactory.priorityComparator);

    public PrioritizedHandlerCollection() {
        super(new ContextHandler[0]);
    }

    public void setPriorityHandlers(Set<PriorityValue<Handler>> handlers) {
        Handler[] handlersZ;
        handlers.forEach(pv -> {
            if (pv.getPriority() > 0) {
                this.handlersBefore.add((PriorityValue<Handler>)pv);
            } else {
                this.handlersAfter.add((PriorityValue<Handler>)pv);
            }
        });
        Handler[] handlersA = (Handler[])this.handlersBefore.stream().map(PriorityValue::getValue).toArray(Handler[]::new);
        if (handlersA.length > 0) {
            this.handlerCollectionBefore.setHandlers(handlersA);
        }
        if ((handlersZ = (Handler[])this.handlersAfter.stream().map(PriorityValue::getValue).toArray(Handler[]::new)).length > 0) {
            this.handlerCollectionAfter.setHandlers(handlersZ);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.handlerCollectionBefore.setServer(this.getServer());
        this.handlerCollectionAfter.setServer(this.getServer());
        this.handlerCollectionBefore.start();
        this.handlerCollectionAfter.start();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.handlerCollectionBefore.stop();
        this.handlerCollectionAfter.stop();
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        if (this.isStarted()) {
            try {
                boolean handled = this.handlerCollectionBefore.handle(request, response, callback);
                if (!handled) {
                    String target = Request.getPathInContext((Request)request);
                    if ("OPTIONS".equals(request.getMethod()) && "*".equals(target)) {
                        response.setStatus(200);
                        response.getHeaders().add("Allow", "GET, HEAD, POST, PUT, DELETE, OPTIONS");
                        callback.succeeded();
                        return true;
                    }
                    handled = super.handle(request, response, callback);
                }
                return handled |= this.handlerCollectionAfter.handle(request, response, callback);
            }
            catch (IOException | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        return true;
    }
}

