/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.util.Hashtable;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.ops4j.pax.web.service.jetty.internal.JettyServerControllerFactory;
import org.ops4j.pax.web.service.spi.ServerControllerFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    public static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private BundleContext bundleContext;
    private ServiceRegistration<ServerControllerFactory> registration;
    private ServiceTracker<Handler, Handler> handlerTracker;
    private ServiceTracker<HttpConfiguration.Customizer, HttpConfiguration.Customizer> customizerTracker;
    private JettyServerControllerFactory serverControllerFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        for (Bundle b : bundleContext.getBundles()) {
            if (!"org.eclipse.jetty.util".equals(b.getSymbolicName())) continue;
            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader cl = ((BundleWiring)b.adapt(BundleWiring.class)).getClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                ShutdownThread.getInstance().setContextClassLoader(((BundleWiring)b.adapt(BundleWiring.class)).getClassLoader());
            }
            finally {
                Thread.currentThread().setContextClassLoader(tcl);
            }
        }
        this.handlerTracker = new ServiceTracker(bundleContext, Handler.class, (ServiceTrackerCustomizer)new HandlerCustomizer());
        this.handlerTracker.open();
        this.customizerTracker = new ServiceTracker(bundleContext, HttpConfiguration.Customizer.class, (ServiceTrackerCustomizer)new CustomizerCustomizer());
        this.customizerTracker.open();
        Bundle paxWebJettyBundle = bundleContext.getBundle();
        ClassLoader loader = ((BundleWiring)paxWebJettyBundle.adapt(BundleWiring.class)).getClassLoader();
        this.serverControllerFactory = new JettyServerControllerFactory(paxWebJettyBundle, loader);
        this.registration = bundleContext.registerService(ServerControllerFactory.class, (Object)this.serverControllerFactory, new Hashtable());
    }

    public void stop(BundleContext bundleContext) throws Exception {
        try {
            this.registration.unregister();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.handlerTracker.close();
        this.customizerTracker.close();
    }

    private class HandlerCustomizer
    implements ServiceTrackerCustomizer<Handler, Handler> {
        private HandlerCustomizer() {
        }

        public Handler addingService(ServiceReference<Handler> reference) {
            Handler handler = (Handler)Activator.this.bundleContext.getService(reference);
            Integer ranking = 0;
            Object rankObject = reference.getProperty("service.ranking");
            if (rankObject instanceof Integer) {
                ranking = (Integer)rankObject;
            }
            LOG.debug("Registered Jetty Handler: {}", (Object)handler);
            if (Activator.this.registration != null) {
                try {
                    Activator.this.registration.unregister();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            LOG.debug("Adding {} Handler to Jetty server", (Object)handler);
            Activator.this.serverControllerFactory.addHandler(handler, ranking == null ? 0 : ranking);
            Activator.this.registration = Activator.this.bundleContext.registerService(ServerControllerFactory.class, (Object)Activator.this.serverControllerFactory, new Hashtable());
            return handler;
        }

        public void modifiedService(ServiceReference<Handler> reference, Handler service) {
        }

        public void removedService(ServiceReference<Handler> reference, Handler handler) {
            Activator.this.bundleContext.ungetService(reference);
            LOG.debug("Unegistered Jetty Handler: {}", (Object)handler);
            if (Activator.this.registration != null) {
                try {
                    Activator.this.registration.unregister();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            LOG.debug("Removing {} Handler from Jetty server", (Object)handler);
            Activator.this.serverControllerFactory.removeHandler(handler);
            Activator.this.registration = Activator.this.bundleContext.registerService(ServerControllerFactory.class, (Object)Activator.this.serverControllerFactory, new Hashtable());
        }
    }

    private class CustomizerCustomizer
    implements ServiceTrackerCustomizer<HttpConfiguration.Customizer, HttpConfiguration.Customizer> {
        private CustomizerCustomizer() {
        }

        public HttpConfiguration.Customizer addingService(ServiceReference<HttpConfiguration.Customizer> reference) {
            HttpConfiguration.Customizer customizer = (HttpConfiguration.Customizer)Activator.this.bundleContext.getService(reference);
            Integer ranking = (Integer)reference.getProperty("service.ranking");
            Object rankObject = reference.getProperty("service.ranking");
            if (rankObject instanceof Integer) {
                ranking = (Integer)rankObject;
            }
            LOG.debug("Registered Jetty Customizer: {}", (Object)customizer);
            LOG.debug("Adding {} Customizer to Jetty server", (Object)customizer);
            Activator.this.serverControllerFactory.addCustomizer(customizer, ranking == null ? 0 : ranking);
            return customizer;
        }

        public void modifiedService(ServiceReference<HttpConfiguration.Customizer> reference, HttpConfiguration.Customizer service) {
        }

        public void removedService(ServiceReference<HttpConfiguration.Customizer> reference, HttpConfiguration.Customizer customizer) {
            Activator.this.bundleContext.ungetService(reference);
            LOG.debug("Unegistered Jetty Customizer: {}", (Object)customizer);
            LOG.debug("Removing {} Customizer from Jetty server", (Object)customizer);
            Activator.this.serverControllerFactory.removeCustomizer(customizer);
        }
    }
}

