/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.osgi.jetty94;

import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.util.security.Constraint;
import org.jboss.logging.Logger;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.spi.model.SecurityConstraintMappingModel;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class PaxWebIntegrationService {
    protected static final Logger log = Logger.getLogger(PaxWebIntegrationService.class);
    private BundleContext bundleContext;
    private String jettyWebXmlLocation;
    private List<Object> constraintMappings;
    private ServiceTracker webContainerTracker;
    private HttpContext httpContext;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getJettyWebXmlLocation() {
        return this.jettyWebXmlLocation;
    }

    public void setJettyWebXmlLocation(String jettyWebXmlLocation) {
        this.jettyWebXmlLocation = jettyWebXmlLocation;
    }

    public List<Object> getConstraintMappings() {
        return this.constraintMappings;
    }

    public void setConstraintMappings(List<Object> constraintMappings) {
        this.constraintMappings = constraintMappings;
    }

    protected ServiceTracker getWebContainerTracker() {
        return this.webContainerTracker;
    }

    protected HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public void start() {
        ServiceTrackerCustomizer trackerCustomizer = new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                return PaxWebIntegrationService.this.addingWebContainerCallback(reference);
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                PaxWebIntegrationService.this.removingWebContainerCallback(reference);
            }
        };
        this.webContainerTracker = new ServiceTracker(this.bundleContext, WebContainer.class.getName(), trackerCustomizer);
        this.webContainerTracker.open();
    }

    public void stop() {
        this.webContainerTracker.remove(this.webContainerTracker.getServiceReference());
    }

    protected WebContainer addingWebContainerCallback(ServiceReference webContainerServiceReference) {
        WebContainer service = (WebContainer)this.bundleContext.getService(webContainerServiceReference);
        if (this.httpContext == null) {
            this.httpContext = service.createDefaultHttpContext();
        }
        this.addJettyWebXml(service);
        if (this.constraintMappings == null) {
            throw new IllegalStateException("constraintMappings was null!");
        }
        ArrayList<ConstraintHandler> handlers = new ArrayList<ConstraintHandler>();
        try {
            handlers.add(new JettyConstraintHandler());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            handlers.add(new PaxWebConstraintHandler());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Object constraintMapping : this.constraintMappings) {
            boolean handled = false;
            for (ConstraintHandler handler : handlers) {
                handled |= handler.addConstraintMapping(this.httpContext, service, constraintMapping);
            }
            if (handled) continue;
            log.warnv("Unable to add constraint mapping for constraint of type " + constraintMapping.getClass().toString(), new Object[0]);
        }
        service.registerLoginConfig("BASIC", "does-not-matter", null, null, this.httpContext);
        return service;
    }

    protected void addJettyWebXml(WebContainer service) {
        String jettyWebXmlLoc = this.jettyWebXmlLocation == null ? "/WEB-INF/jetty-web.xml" : this.jettyWebXmlLocation;
        URL jettyWebXml = this.bundleContext.getBundle().getResource(jettyWebXmlLoc);
        if (jettyWebXml != null) {
            log.debug((Object)("Found jetty-web XML configuration on bundle classpath on " + jettyWebXmlLoc));
            service.registerJettyWebXml(jettyWebXml, this.httpContext);
        } else {
            log.debug((Object)("Not found jetty-web XML configuration on bundle classpath on " + jettyWebXmlLoc));
        }
    }

    protected void addConstraintMapping(WebContainer service, SecurityConstraintMappingModel constraintMapping) {
        String name = constraintMapping.getConstraintName();
        if (name == null) {
            name = "Constraint-" + new SecureRandom().nextInt(Integer.MAX_VALUE);
        }
        log.debug((Object)("Adding security constraint name=" + name + ", url=" + constraintMapping.getUrl() + ", dataConstraint=" + constraintMapping.getDataConstraint() + ", canAuthenticate=" + constraintMapping.isAuthentication() + ", roles=" + constraintMapping.getRoles()));
        service.registerConstraintMapping(name, constraintMapping.getMapping(), constraintMapping.getUrl(), constraintMapping.getDataConstraint(), constraintMapping.isAuthentication(), constraintMapping.getRoles(), this.httpContext);
    }

    protected void addConstraintMapping(WebContainer service, ConstraintMapping constraintMapping) {
        String dataConstraintStr;
        Constraint constraint = constraintMapping.getConstraint();
        String[] roles = constraint.getRoles();
        String name = "Constraint-" + new SecureRandom().nextInt(Integer.MAX_VALUE);
        int dataConstraint = constraint.getDataConstraint();
        switch (dataConstraint) {
            case -1: {
                dataConstraintStr = null;
                break;
            }
            case 0: {
                dataConstraintStr = "NONE";
                break;
            }
            case 2: {
                dataConstraintStr = "CONFIDENTIAL";
                break;
            }
            case 1: {
                dataConstraintStr = "INTEGRAL";
                break;
            }
            default: {
                log.warnv("Unknown data constraint: " + dataConstraint, new Object[0]);
                dataConstraintStr = "CONFIDENTIAL";
            }
        }
        List<String> rolesList = Arrays.asList(roles);
        log.debug((Object)("Adding security constraint name=" + name + ", url=" + constraintMapping.getPathSpec() + ", dataConstraint=" + dataConstraintStr + ", canAuthenticate=" + constraint.getAuthenticate() + ", roles=" + rolesList));
        service.registerConstraintMapping(name, null, constraintMapping.getPathSpec(), dataConstraintStr, constraint.getAuthenticate(), rolesList, this.httpContext);
    }

    protected void removingWebContainerCallback(ServiceReference serviceReference) {
        WebContainer service = (WebContainer)this.bundleContext.getService(serviceReference);
        if (service != null) {
            service.unregisterLoginConfig(this.httpContext);
            service.unregisterConstraintMapping(this.httpContext);
        }
    }

    private static class JettyConstraintHandler
    implements ConstraintHandler {
        private JettyConstraintHandler() {
        }

        @Override
        public boolean addConstraintMapping(HttpContext httpContext, WebContainer service, Object cm) {
            if (cm instanceof ConstraintMapping) {
                String dataConstraintStr;
                ConstraintMapping constraintMapping = (ConstraintMapping)cm;
                Constraint constraint = constraintMapping.getConstraint();
                String[] roles = constraint.getRoles();
                String name = "Constraint-" + new SecureRandom().nextInt(Integer.MAX_VALUE);
                int dataConstraint = constraint.getDataConstraint();
                switch (dataConstraint) {
                    case -1: {
                        dataConstraintStr = null;
                        break;
                    }
                    case 0: {
                        dataConstraintStr = "NONE";
                        break;
                    }
                    case 2: {
                        dataConstraintStr = "CONFIDENTIAL";
                        break;
                    }
                    case 1: {
                        dataConstraintStr = "INTEGRAL";
                        break;
                    }
                    default: {
                        log.warnv("Unknown data constraint: " + dataConstraint, new Object[0]);
                        dataConstraintStr = "CONFIDENTIAL";
                    }
                }
                List<String> rolesList = Arrays.asList(roles);
                log.debug((Object)("Adding security constraint name=" + name + ", url=" + constraintMapping.getPathSpec() + ", dataConstraint=" + dataConstraintStr + ", canAuthenticate=" + constraint.getAuthenticate() + ", roles=" + rolesList));
                service.registerConstraintMapping(name, null, constraintMapping.getPathSpec(), dataConstraintStr, constraint.getAuthenticate(), rolesList, httpContext);
                return true;
            }
            return false;
        }
    }

    private static class PaxWebConstraintHandler
    implements ConstraintHandler {
        private PaxWebConstraintHandler() {
        }

        @Override
        public boolean addConstraintMapping(HttpContext httpContext, WebContainer service, Object cm) {
            if (cm instanceof SecurityConstraintMappingModel) {
                SecurityConstraintMappingModel constraintMapping = (SecurityConstraintMappingModel)cm;
                String name = constraintMapping.getConstraintName();
                if (name == null) {
                    name = "Constraint-" + new SecureRandom().nextInt(Integer.MAX_VALUE);
                }
                log.debug((Object)("Adding security constraint name=" + name + ", url=" + constraintMapping.getUrl() + ", dataConstraint=" + constraintMapping.getDataConstraint() + ", canAuthenticate=" + constraintMapping.isAuthentication() + ", roles=" + constraintMapping.getRoles()));
                service.registerConstraintMapping(name, constraintMapping.getMapping(), constraintMapping.getUrl(), constraintMapping.getDataConstraint(), constraintMapping.isAuthentication(), constraintMapping.getRoles(), httpContext);
                return true;
            }
            return false;
        }
    }

    private static interface ConstraintHandler {
        public boolean addConstraintMapping(HttpContext var1, WebContainer var2, Object var3);
    }
}

