/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.ops4j.pax.web.service.jetty.internal.PaxWebServletHolder;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;

public class PaxWebSessionIdManager
extends DefaultSessionIdManager {
    public PaxWebSessionIdManager(Server server) {
        super(server);
    }

    public static String getSessionIdSuffix(HttpServletRequest request) {
        Request r;
        UserIdentity.Scope uis;
        if (request instanceof Request && (uis = (r = (Request)request).getUserIdentityScope()) instanceof PaxWebServletHolder) {
            PaxWebServletHolder holder = (PaxWebServletHolder)uis;
            OsgiContextModel ocm = holder.getOsgiContextModel();
            if (ocm == null || ocm.getTemporaryLocation() == null) {
                return "";
            }
            return "~" + ocm.getTemporaryLocation().replaceAll("/", "#").replaceAll("_", "#");
        }
        return "";
    }

    @Override
    public String renewSessionId(String oldClusterId, String oldNodeId, HttpServletRequest request) {
        String newClusterId = this.newSessionId(request.hashCode());
        int id1 = oldClusterId.indexOf("~");
        if (id1 > 0) {
            newClusterId = newClusterId + oldClusterId.substring(id1);
        }
        for (SessionHandler manager : this.getSessionHandlers()) {
            manager.renewSessionId(oldClusterId, oldNodeId, newClusterId, this.getExtendedId(newClusterId, request));
        }
        return newClusterId;
    }

    @Override
    public String newSessionId(HttpServletRequest request, long created) {
        if (request == null) {
            return this.newSessionId(created);
        }
        String suffix = PaxWebSessionIdManager.getSessionIdSuffix(request);
        if (suffix != null) {
            String rsid = request.getRequestedSessionId();
            if (rsid == null) {
                return super.newSessionId(request, created) + suffix;
            }
            String sid = this.getId(rsid);
            return sid + suffix;
        }
        return super.newSessionId(request, created);
    }
}

