/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Extension;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.eclipse.jetty.websocket.jsr356.server.ContainerDefaultConfigurator;

public class BasicServerEndpointConfig
implements ServerEndpointConfig {
    private final List<Class<? extends Decoder>> decoders;
    private final List<Class<? extends Encoder>> encoders;
    private final List<Extension> extensions;
    private final List<String> subprotocols;
    private final ServerEndpointConfig.Configurator configurator;
    private final Class<?> endpointClass;
    private final String path;
    private Map<String, Object> userProperties;

    public BasicServerEndpointConfig(WebSocketContainerScope containerScope, Class<?> endpointClass, String path) {
        this.endpointClass = endpointClass;
        this.path = path;
        this.decoders = new ArrayList<Class<? extends Decoder>>();
        this.encoders = new ArrayList<Class<? extends Encoder>>();
        this.subprotocols = new ArrayList<String>();
        this.extensions = new ArrayList<Extension>();
        this.userProperties = new HashMap<String, Object>();
        this.configurator = new ContainerDefaultConfigurator();
    }

    public BasicServerEndpointConfig(WebSocketContainerScope containerScope, ServerEndpointConfig copy) {
        this.endpointClass = copy.getEndpointClass();
        this.path = copy.getPath();
        this.decoders = copy.getDecoders();
        this.encoders = copy.getEncoders();
        this.subprotocols = copy.getSubprotocols();
        this.extensions = copy.getExtensions();
        Object cfgr = copy.getConfigurator() != null ? copy.getConfigurator() : new ContainerDefaultConfigurator();
        this.configurator = containerScope.getObjectFactory().decorate(cfgr);
        this.userProperties = new HashMap<String, Object>(copy.getUserProperties());
    }

    public List<Class<? extends Encoder>> getEncoders() {
        return this.encoders;
    }

    public List<Class<? extends Decoder>> getDecoders() {
        return this.decoders;
    }

    public Map<String, Object> getUserProperties() {
        return this.userProperties;
    }

    public Class<?> getEndpointClass() {
        return this.endpointClass;
    }

    public String getPath() {
        return this.path;
    }

    public List<String> getSubprotocols() {
        return this.subprotocols;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public ServerEndpointConfig.Configurator getConfigurator() {
        return this.configurator;
    }
}

