/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import javax.websocket.EncodeException;
import javax.websocket.Encoder;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.common.WebSocketRemoteEndpoint;
import org.eclipse.jetty.websocket.common.io.FutureWriteCallback;
import org.eclipse.jetty.websocket.common.message.MessageOutputStream;
import org.eclipse.jetty.websocket.common.message.MessageWriter;
import org.eclipse.jetty.websocket.jsr356.EncoderFactory;
import org.eclipse.jetty.websocket.jsr356.JsrSession;
import org.eclipse.jetty.websocket.jsr356.encoders.EncodeFailedFuture;

public abstract class AbstractJsrRemote
implements RemoteEndpoint {
    private static final Logger LOG = Log.getLogger(AbstractJsrRemote.class);
    protected final JsrSession session;
    protected final WebSocketRemoteEndpoint jettyRemote;
    protected final EncoderFactory encoders;

    protected AbstractJsrRemote(JsrSession session) {
        this.session = session;
        if (!(session.getRemote() instanceof WebSocketRemoteEndpoint)) {
            StringBuilder err = new StringBuilder();
            err.append("Unexpected implementation [");
            if (session.getRemote() == null) {
                err.append("<null>");
            } else {
                err.append(session.getRemote().getClass().getName());
            }
            err.append("].  Expected an instanceof [");
            err.append(WebSocketRemoteEndpoint.class.getName());
            err.append("]");
            throw new IllegalStateException(err.toString());
        }
        this.jettyRemote = (WebSocketRemoteEndpoint)session.getRemote();
        this.encoders = session.getEncoderFactory();
    }

    protected void assertMessageNotNull(Object data) {
        if (data == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
    }

    protected void assertSendHandlerNotNull(SendHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("SendHandler cannot be null");
        }
    }

    public void flushBatch() throws IOException {
        this.jettyRemote.flush();
    }

    public boolean getBatchingAllowed() {
        return this.jettyRemote.getBatchMode() == BatchMode.ON;
    }

    public void setBatchingAllowed(boolean allowed) throws IOException {
        if (this.jettyRemote.getBatchMode() == BatchMode.ON && !allowed) {
            this.jettyRemote.flush();
        }
        this.jettyRemote.setBatchMode(allowed ? BatchMode.ON : BatchMode.OFF);
    }

    public Future<Void> sendObjectViaFuture(Object data) {
        Encoder encoder;
        this.assertMessageNotNull(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendObject({})", data);
        }
        if ((encoder = this.encoders.getEncoderFor(data.getClass())) == null) {
            throw new IllegalArgumentException("No encoder for type: " + data.getClass());
        }
        if (encoder instanceof Encoder.Text) {
            Encoder.Text text = (Encoder.Text)encoder;
            try {
                String msg = text.encode(data);
                return this.jettyRemote.sendStringByFuture(msg);
            }
            catch (EncodeException e) {
                return new EncodeFailedFuture(data, (Encoder)text, Encoder.Text.class, e);
            }
        }
        if (encoder instanceof Encoder.TextStream) {
            FutureWriteCallback futureWriteCallback;
            Encoder.TextStream etxt = (Encoder.TextStream)encoder;
            FutureWriteCallback callback = new FutureWriteCallback();
            MessageWriter writer = new MessageWriter(this.session);
            try {
                writer.setCallback(callback);
                etxt.encode(data, (Writer)writer);
                futureWriteCallback = callback;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | EncodeException e) {
                    return new EncodeFailedFuture(data, (Encoder)etxt, Encoder.Text.class, e);
                }
            }
            writer.close();
            return futureWriteCallback;
        }
        if (encoder instanceof Encoder.Binary) {
            Encoder.Binary ebin = (Encoder.Binary)encoder;
            try {
                ByteBuffer buf = ebin.encode(data);
                return this.jettyRemote.sendBytesByFuture(buf);
            }
            catch (EncodeException e) {
                return new EncodeFailedFuture(data, (Encoder)ebin, Encoder.Binary.class, e);
            }
        }
        if (encoder instanceof Encoder.BinaryStream) {
            FutureWriteCallback futureWriteCallback;
            Encoder.BinaryStream ebin = (Encoder.BinaryStream)encoder;
            FutureWriteCallback callback = new FutureWriteCallback();
            MessageOutputStream out = new MessageOutputStream(this.session);
            try {
                out.setCallback(callback);
                ebin.encode(data, (OutputStream)out);
                futureWriteCallback = callback;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                catch (IOException | EncodeException e) {
                    return new EncodeFailedFuture(data, (Encoder)ebin, Encoder.Binary.class, e);
                }
            }
            out.close();
            return futureWriteCallback;
        }
        throw new IllegalArgumentException("Unknown encoder type: " + encoder);
    }

    public void sendPing(ByteBuffer data) throws IOException, IllegalArgumentException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendPing({})", BufferUtil.toDetailString(data));
        }
        this.jettyRemote.sendPing(data);
    }

    public void sendPong(ByteBuffer data) throws IOException, IllegalArgumentException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendPong({})", BufferUtil.toDetailString(data));
        }
        this.jettyRemote.sendPong(data);
    }
}

