/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.jetty.internal.HttpServiceContext;
import org.ops4j.pax.web.service.jetty.internal.JettyServerWrapper;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JettyServerHandlerCollection
extends HandlerCollection {
    private static final Logger LOG = LoggerFactory.getLogger(JettyServerHandlerCollection.class);
    private final ServerModel serverModel;

    JettyServerHandlerCollection(ServerModel serverModel) {
        super(true);
        NullArgumentException.validateNotNull(serverModel, "Server model");
        this.serverModel = serverModel;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!this.isStarted()) {
            return;
        }
        ContextModel matched = this.serverModel.matchPathToContext(target);
        if (matched != null) {
            NullArgumentException.validateNotNull(matched.getHttpContext(), "The http Context of " + matched.getContextName() + " is null");
            NullArgumentException.validateNotNull(this.getServer(), "The server is null!");
            HttpServiceContext context = ((JettyServerWrapper)this.getServer()).getContext(matched.getHttpContext());
            try {
                NullArgumentException.validateNotNull(context, "Found context is Null");
                context.handle(target, baseRequest, request, response);
            }
            catch (EofException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException(e);
            }
        }
        for (Handler handler : this.getHandlers()) {
            if (matched != null && (handler instanceof ContextHandler || this.matchedContextEqualsHandler(matched, handler))) continue;
            handler.handle(target, baseRequest, request, response);
        }
    }

    private boolean matchedContextEqualsHandler(ContextModel matched, Handler handler) {
        return handler == ((JettyServerWrapper)this.getServer()).getContext(matched.getHttpContext());
    }

    @Override
    public boolean addBean(Object o) {
        LOG.debug("Adding bean: {}", o);
        if (!(o instanceof HttpServiceContext)) {
            LOG.debug("calling supper add bean ...");
            return super.addBean(o);
        }
        return this.addBean(o, false);
    }
}

