/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.JDBCSessionIdManager;
import org.eclipse.jetty.server.session.JDBCSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.ops4j.pax.swissbox.core.ContextClassLoaderUtils;
import org.ops4j.pax.web.jsp.JspServletWrapper;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.jetty.internal.HttpServiceServletHandler;
import org.ops4j.pax.web.service.jetty.internal.LateInvalidatingHashSessionManager;
import org.ops4j.pax.web.service.jetty.internal.util.DOMJettyWebXmlParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpServiceContext
extends ServletContextHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServiceContext.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Map<String, Object> attributes;
    private final HttpContext httpContext;
    private final AccessControlContext accessControllerContext;
    private final Map<ServletContainerInitializer, Set<Class<?>>> servletContainerInitializers;
    private final URL jettyWebXmlURL;
    private final List<String> virtualHosts;
    private final AtomicReference<ServiceRegistration<ServletContext>> registration = new AtomicReference();

    HttpServiceContext(HandlerContainer parent, Map<String, String> initParams, Map<String, Object> attributes, String contextName, HttpContext httpContext, AccessControlContext accessControllerContext, Map<ServletContainerInitializer, Set<Class<?>>> containerInitializers, URL jettyWebXmlUrl, List<String> virtualHosts) {
        super(parent, "/" + contextName, 3);
        LOG.info("registering context {}, with context-name: {}", (Object)httpContext, (Object)contextName);
        this.getInitParams().putAll(initParams);
        this.attributes = attributes;
        this.httpContext = httpContext;
        this.accessControllerContext = accessControllerContext;
        this.setDisplayName(httpContext.toString());
        this.servletContainerInitializers = containerInitializers != null ? containerInitializers : new HashMap();
        this.virtualHosts = new ArrayList<String>(virtualHosts);
        this.jettyWebXmlURL = jettyWebXmlUrl;
        this._scontext = new SContext();
        AbstractSessionManager sessionManager = (AbstractSessionManager)this.getSessionHandler().getSessionManager();
        ScheduledExecutorScheduler executorScheduler = new ScheduledExecutorScheduler(sessionManager.toString() + "Timer", true, this.getClass().getClassLoader());
        sessionManager.addBean((Object)executorScheduler, true);
        this._scontext.setAttribute("org.eclipse.jetty.server.session.timer", executorScheduler);
        this.setServletHandler(new HttpServiceServletHandler(httpContext));
        this.setErrorHandler(new ErrorPageErrorHandler());
    }

    public void registerService(BundleContext bundleContext, Dictionary<String, String> properties) {
        if (this.registration.get() == null) {
            ServiceRegistration reg = bundleContext.registerService(ServletContext.class, (Object)this.getServletContext(), properties);
            if (!this.registration.compareAndSet(null, (ServiceRegistration<ServletContext>)reg)) {
                reg.unregister();
            }
            LOG.debug("ServletContext registered as service.");
        }
    }

    public void unregisterService() {
        ServiceRegistration reg = this.registration.getAndSet(null);
        if (reg != null) {
            LOG.debug("ServletContext unregistered as service.");
            try {
                reg.unregister();
            }
            catch (IllegalStateException e) {
                LOG.info("ServletContext service already removed");
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.setLogger(Log.getLogger(this.getDisplayName() == null ? this.getContextPath() : this.getDisplayName()));
        if (this.isJspAvailable()) {
            LOG.info("registering JasperInitializer");
            Class<?> loadClass = this.loadClass("org.ops4j.pax.web.jsp.JasperInitializer");
            this.servletContainerInitializers.put((ServletContainerInitializer)loadClass.newInstance(), Collections.emptySet());
        }
        if (this.servletContainerInitializers != null) {
            for (final Map.Entry entry : this.servletContainerInitializers.entrySet()) {
                try {
                    ContextClassLoaderUtils.doWithClassLoader(this.getClassLoader(), new Callable<Void>(){

                        @Override
                        public Void call() throws IOException, ServletException {
                            ((ServletContainerInitializer)entry.getKey()).onStartup((Set)entry.getValue(), HttpServiceContext.this._scontext);
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    LOG.error("Ignored exception during listener registration", (Throwable)e);
                }
            }
        }
        this.setVirtualHosts(this.virtualHosts.toArray(EMPTY_STRING_ARRAY));
        if (this.jettyWebXmlURL != null) {
            try {
                ContextClassLoaderUtils.doWithClassLoader(this.getClassLoader(), new Callable<Void>(){

                    @Override
                    public Void call() throws IOException {
                        DOMJettyWebXmlParser jettyWebXmlParser = new DOMJettyWebXmlParser();
                        jettyWebXmlParser.parse(HttpServiceContext.this, HttpServiceContext.this.jettyWebXmlURL.openStream());
                        return null;
                    }
                });
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                LOG.error("Ignored exception during listener registration", (Throwable)e);
            }
        }
        if (this.attributes != null) {
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                this._scontext.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        super.doStart();
        LOG.debug("Started servlet context for http context [" + this.httpContext + "]");
    }

    private boolean isJspAvailable() {
        try {
            return JspServletWrapper.class != null;
        }
        catch (NoClassDefFoundError ignore) {
            return false;
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.unregisterService();
        super.doStop();
        LOG.debug("Stopped servlet context for http context [" + this.httpContext + "]");
    }

    @Override
    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LOG.debug("Handling request for [" + target + "] using http context [" + this.httpContext + "]");
        super.doHandle(target, baseRequest, request, response);
    }

    @Override
    public void setEventListeners(EventListener[] eventListeners) {
        if (this._sessionHandler != null) {
            this._sessionHandler.clearEventListeners();
        }
        super.setEventListeners(eventListeners);
        if (this._sessionHandler != null) {
            for (int i = 0; eventListeners != null && i < eventListeners.length; ++i) {
                EventListener listener = eventListeners[i];
                if (!(listener instanceof HttpSessionActivationListener) && !(listener instanceof HttpSessionAttributeListener) && !(listener instanceof HttpSessionBindingListener) && !(listener instanceof HttpSessionListener)) continue;
                this._sessionHandler.addEventListener(listener);
            }
        }
    }

    @Override
    public void addEventListener(EventListener listener) {
        super.addEventListener(listener);
        if ((listener instanceof HttpSessionActivationListener || listener instanceof HttpSessionAttributeListener || listener instanceof HttpSessionBindingListener || listener instanceof HttpSessionListener) && this._sessionHandler != null) {
            this._sessionHandler.addEventListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callContextInitialized(final ServletContextListener l, final ServletContextEvent e) {
        try {
            if (this.isProgrammaticListener(l)) {
                this.getServletContext().setEnabled(false);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("contextInitialized: {}->{}", (Object)e, (Object)l);
            }
            try {
                ContextClassLoaderUtils.doWithClassLoader(this.getClassLoader(), new Callable<Void>(){

                    @Override
                    public Void call() {
                        l.contextInitialized(e);
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                LOG.error("Ignored exception during listener registration", (Object)e);
            }
        }
        finally {
            this.getServletContext().setEnabled(true);
        }
    }

    @Override
    public boolean isProtectedTarget(String target) {
        while (target.startsWith("//")) {
            target = URIUtil.compactPath(target);
        }
        return StringUtil.startsWithIgnoreCase(target, "/web-inf") || StringUtil.startsWithIgnoreCase(target, "/meta-inf") || StringUtil.startsWithIgnoreCase(target, "/osgi-inf") || StringUtil.startsWithIgnoreCase(target, "/osgi-opt");
    }

    @Override
    protected SessionHandler newSessionHandler() {
        Server server = this.getServer();
        SessionIdManager sessionIdManager = null;
        if (server != null) {
            sessionIdManager = server.getSessionIdManager();
        }
        if (sessionIdManager instanceof JDBCSessionIdManager) {
            LOG.debug("Creating JDBCSessionManager for SessionIdManager {} and Server {}", (Object)sessionIdManager.getClass().getName(), (Object)server.getClass().getName());
            JDBCSessionManager sessionManager = new JDBCSessionManager();
            sessionManager.setSessionIdManager(sessionIdManager);
            SessionHandler sessionHandler = new SessionHandler(sessionManager);
            sessionHandler.setServer(server);
            sessionManager.setSessionHandler(sessionHandler);
            return sessionHandler;
        }
        LateInvalidatingHashSessionManager sessionManager = new LateInvalidatingHashSessionManager();
        if (sessionIdManager != null) {
            LOG.debug("Creating LateInvalidatingHashSessionManager for SessionIdManager {}", (Object)sessionIdManager.getClass().getName());
            sessionManager.setSessionIdManager(sessionIdManager);
        } else {
            LOG.debug("Creating default LateInvalidatingHashSessionManager, no SessionIdManager currently set");
        }
        return new SessionHandler(sessionManager);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "httpContext=" + this.httpContext + "}";
    }

    @Override
    public boolean addBean(Object o) {
        return super.addBean(o);
    }

    @Override
    protected void startContext() throws Exception {
        String webContextPath;
        super.startContext();
        LOG.debug("Registering ServletContext as service. ");
        BundleContext bundleContext = (BundleContext)this.attributes.get("osgi-bundlecontext");
        Bundle bundle = bundleContext.getBundle();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("osgi.web.symbolicname", bundle.getSymbolicName());
        Dictionary headers = bundle.getHeaders();
        String version = (String)headers.get("Bundle-Version");
        if (version != null && version.length() > 0) {
            ((Dictionary)properties).put("osgi.web.version", version);
        }
        if ((webContextPath = this.getContextPath()) != null && !webContextPath.startsWith("/")) {
            webContextPath = "/" + webContextPath;
        } else if (webContextPath == null) {
            LOG.warn("osgi.web.contextpath couldn't be set, it's not configured. Assuming '/'");
            webContextPath = "/";
        }
        ((Dictionary)properties).put("osgi.web.contextpath", webContextPath);
        this.registerService(bundleContext, properties);
        LOG.debug("ServletContext registered as service. ");
    }

    public class SContext
    extends ServletContextHandler.Context {
        @Override
        public String getRealPath(String path) {
            File file;
            String fileName;
            String protocol;
            URL resource;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getting real path: [{}]", (Object)path);
            }
            if ((resource = this.getResource(path)) != null && (protocol = resource.getProtocol()).equals("file") && (fileName = resource.getFile()) != null && (file = new File(fileName)).exists()) {
                String realPath = file.getAbsolutePath();
                LOG.debug("found real path: [{}]", (Object)realPath);
                return realPath;
            }
            return null;
        }

        @Override
        public URL getResource(String path) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getting resource: [" + path + "]");
            }
            URL resource = null;
            try {
                resource = new URL(path);
                LOG.debug("resource: [" + path + "] is already a URL, returning");
                return resource;
            }
            catch (MalformedURLException e) {
                LOG.debug("not a URL or invalid URL: [" + path + "], treating as a file path");
                final String p = path != null && path.endsWith("/") && path.length() > 1 ? path.substring(0, path.length() - 1) : path;
                try {
                    resource = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                        @Override
                        public URL run() throws Exception {
                            return HttpServiceContext.this.httpContext.getResource(p);
                        }
                    }, HttpServiceContext.this.accessControllerContext);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("found resource: " + resource);
                    }
                }
                catch (PrivilegedActionException e2) {
                    LOG.warn("Unauthorized access: " + e2.getMessage());
                }
                return resource;
            }
        }

        @Override
        public InputStream getResourceAsStream(String path) {
            final URL url = this.getResource(path);
            if (url != null) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public InputStream run() throws Exception {
                            try {
                                return url.openStream();
                            }
                            catch (IOException e) {
                                LOG.warn("URL canot be accessed: " + e.getMessage());
                                return null;
                            }
                        }
                    }, HttpServiceContext.this.accessControllerContext);
                }
                catch (PrivilegedActionException e) {
                    LOG.warn("Unauthorized access: " + e.getMessage());
                }
            }
            return null;
        }

        @Override
        public Set<String> getResourcePaths(final String path) {
            if (HttpServiceContext.this.httpContext instanceof WebContainerContext) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getting resource paths for : [" + path + "]");
                }
                try {
                    Set<String> paths = AccessController.doPrivileged(new PrivilegedExceptionAction<Set<String>>(){

                        @Override
                        public Set<String> run() throws Exception {
                            return ((WebContainerContext)HttpServiceContext.this.httpContext).getResourcePaths(path);
                        }
                    }, HttpServiceContext.this.accessControllerContext);
                    if (paths == null) {
                        return null;
                    }
                    HashSet<String> slashedPaths = new HashSet<String>();
                    for (String foundPath : paths) {
                        if (foundPath == null) continue;
                        if (foundPath.trim().startsWith("/")) {
                            slashedPaths.add(foundPath.trim());
                            continue;
                        }
                        slashedPaths.add("/" + foundPath.trim());
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("found resource paths: " + paths);
                    }
                    return slashedPaths;
                }
                catch (PrivilegedActionException e) {
                    LOG.warn("Unauthorized access: " + e.getMessage());
                    return null;
                }
            }
            return super.getResourcePaths(path);
        }

        @Override
        public String getMimeType(String name) {
            String mime;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getting mime type for: [" + name + "]");
            }
            if ((mime = HttpServiceContext.this.httpContext.getMimeType(name)) != null) {
                return mime;
            }
            return super.getMimeType(name);
        }
    }
}

