/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker.legacy;

import java.util.Collection;
import org.ops4j.pax.web.extender.whiteboard.internal.WhiteboardExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.legacy.AbstractMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.runtime.DefaultSecurityConfigurationMapping;
import org.ops4j.pax.web.extender.whiteboard.runtime.DefaultSecurityConstraintMapping;
import org.ops4j.pax.web.service.spi.model.elements.LoginConfigModel;
import org.ops4j.pax.web.service.spi.model.elements.SecurityConfigurationModel;
import org.ops4j.pax.web.service.spi.model.elements.SecurityConstraintModel;
import org.ops4j.pax.web.service.spi.model.events.SecurityConfigurationEventData;
import org.ops4j.pax.web.service.whiteboard.SecurityConfigurationMapping;
import org.ops4j.pax.web.service.whiteboard.SecurityConstraintMapping;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class SecurityConfigurationMappingTracker
extends AbstractMappingTracker<SecurityConfigurationMapping, SecurityConfigurationMapping, SecurityConfigurationEventData, SecurityConfigurationModel> {
    protected SecurityConfigurationMappingTracker(WhiteboardExtenderContext whiteboardExtenderContext, BundleContext bundleContext) {
        super(whiteboardExtenderContext, bundleContext);
    }

    public static ServiceTracker<SecurityConfigurationMapping, SecurityConfigurationModel> createTracker(WhiteboardExtenderContext whiteboardExtenderContext, BundleContext bundleContext) {
        return new SecurityConfigurationMappingTracker(whiteboardExtenderContext, bundleContext).create(SecurityConfigurationMapping.class);
    }

    @Override
    protected SecurityConfigurationModel doCreateElementModel(Bundle bundle, SecurityConfigurationMapping service, Integer rank, Long serviceId) {
        SecurityConfigurationModel model = new SecurityConfigurationModel();
        model.setRegisteringBundle(bundle);
        model.setServiceRank(rank.intValue());
        model.setServiceId(serviceId.longValue());
        if (service instanceof DefaultSecurityConfigurationMapping) {
            model.setLoginConfig(((DefaultSecurityConfigurationMapping)service).getLoginConfig());
        } else {
            LoginConfigModel lcm = new LoginConfigModel();
            lcm.setAuthMethod(service.getAuthMethod());
            lcm.setRealmName(service.getRealmName());
            lcm.setFormLoginPage(service.getFormLoginPage());
            lcm.setFormErrorPage(service.getFormErrorPage());
            model.setLoginConfig(lcm);
        }
        Collection securityConstraints = service.getSecurityConstraints();
        if (securityConstraints != null) {
            for (SecurityConstraintMapping constraint : securityConstraints) {
                SecurityConstraintModel scm;
                if (constraint instanceof DefaultSecurityConstraintMapping) {
                    scm = ((DefaultSecurityConstraintMapping)constraint).getSecurityConstraint();
                } else {
                    scm = new SecurityConstraintModel();
                    scm.setName(constraint.getName());
                    if (constraint.getAuthRoles() != null) {
                        scm.getAuthRoles().addAll(constraint.getAuthRoles());
                    }
                    scm.setAuthRolesSet(constraint.isAuthRolesSet());
                    scm.setTransportGuarantee(constraint.getTransportGuarantee());
                }
                model.getSecurityConstraints().add(scm);
                Collection webResourceCollections = constraint.getWebResourceCollections();
                if (webResourceCollections == null) continue;
                for (SecurityConstraintMapping.WebResourceCollectionMapping wrcm : webResourceCollections) {
                    SecurityConstraintModel.WebResourceCollection wrc;
                    if (wrcm instanceof DefaultSecurityConstraintMapping.DefaultWebResourceCollectionMapping) {
                        wrc = ((DefaultSecurityConstraintMapping.DefaultWebResourceCollectionMapping)wrcm).getWebResourceCollection();
                    } else {
                        wrc = new SecurityConstraintModel.WebResourceCollection();
                        wrc.setName(wrcm.getName());
                        if (wrcm.getUrlPatterns() != null) {
                            wrc.getPatterns().addAll(wrcm.getUrlPatterns());
                        }
                        if (wrcm.getHttpMethods() != null) {
                            wrc.getMethods().addAll(wrcm.getHttpMethods());
                        }
                        if (wrcm.getHttpMethodOmissions() != null) {
                            wrc.getOmittedMethods().addAll(wrcm.getHttpMethodOmissions());
                        }
                    }
                    scm.getWebResourceCollections().add(wrc);
                }
            }
        }
        if (service.getSecurityRoles() != null) {
            model.getSecurityRoles().addAll(service.getSecurityRoles());
        }
        return model;
    }
}

