/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import jakarta.servlet.GenericServlet;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServlet;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.ops4j.pax.web.extender.whiteboard.internal.WhiteboardExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractElementTracker;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.model.events.ServletEventData;
import org.ops4j.pax.web.service.spi.util.ServletAnnotationScanner;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ServletTracker
extends AbstractElementTracker<Servlet, Servlet, ServletEventData, ServletModel> {
    private ServletTracker(WhiteboardExtenderContext whiteboardExtenderContext, BundleContext bundleContext) {
        super(whiteboardExtenderContext, bundleContext);
    }

    public static ServiceTracker<Servlet, ServletModel> createTracker(WhiteboardExtenderContext whiteboardExtenderContext, BundleContext bundleContext) {
        return new ServletTracker(whiteboardExtenderContext, bundleContext).create(Servlet.class, GenericServlet.class, HttpServlet.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ServletModel createElementModel(ServiceReference<Servlet> serviceReference, Integer rank, Long serviceId) {
        String name;
        this.log.debug("Creating servlet model from R7 whiteboard service {} (id={})", serviceReference, (Object)serviceId);
        String alias = Utils.getStringProperty(serviceReference, (String)"alias");
        if (alias != null) {
            this.log.warn("Legacy {} property specified, alias should be used only for HttpService registrations", (Object)"alias");
        }
        boolean propertiesInvalid = false;
        String[] urlPatterns = (String[])Utils.getPaxWebProperty(serviceReference, (String)"urlPatterns", (String)"osgi.http.whiteboard.servlet.pattern", Utils::asStringArray);
        Object v = serviceReference.getProperty("osgi.http.whiteboard.servlet.pattern");
        if (!(v == null || v instanceof String || v instanceof String[] || v instanceof Collection)) {
            propertiesInvalid = true;
        }
        if ((name = (String)Utils.getPaxWebProperty(serviceReference, (String)"servlet-name", (String)"osgi.http.whiteboard.servlet.name", Utils::asString)) == null && serviceReference.getProperty("osgi.http.whiteboard.servlet.name") != null) {
            propertiesInvalid = true;
        }
        LinkedHashMap<String, String> initParams = new LinkedHashMap<String, String>();
        String legacyInitPrefix = Utils.getStringProperty(serviceReference, (String)"init-prefix");
        if (legacyInitPrefix != null) {
            this.log.warn("Legacy {} property found, servlet init parameters should be prefixed with {} instead", (Object)"init-prefix", (Object)"servlet.init.");
        }
        String[] prefix = new String[]{legacyInitPrefix == null ? "init." : legacyInitPrefix};
        boolean hasLegacyInitProperty = Arrays.stream(serviceReference.getPropertyKeys()).anyMatch(p -> p.startsWith(prefix[0]));
        if (hasLegacyInitProperty) {
            this.log.warn("Legacy servlet init parameters found (with prefix: {}), init parameters should be prefixed with {} instead", (Object)prefix[0], (Object)"servlet.init.");
        } else {
            prefix[0] = "servlet.init.";
        }
        for (String key : serviceReference.getPropertyKeys()) {
            String value;
            if (!key.startsWith(prefix[0]) || (value = Utils.getStringProperty(serviceReference, (String)key)) == null) continue;
            initParams.put(key.substring(prefix[0].length()), value);
        }
        Boolean asyncSupported = (Boolean)Utils.getPaxWebProperty(serviceReference, (String)"async-supported", (String)"osgi.http.whiteboard.servlet.asyncSupported", Utils::asBoolean);
        Integer loadOnStartup = Utils.getIntegerProperty(serviceReference, (String)"load-on-startup");
        MultipartConfigElement multiPartConfig = null;
        Boolean multiPartEnabled = Utils.getBooleanProperty(serviceReference, (String)"osgi.http.whiteboard.servlet.multipart.enabled");
        if (multiPartEnabled != null && multiPartEnabled.booleanValue()) {
            String location = Utils.getStringProperty(serviceReference, (String)"osgi.http.whiteboard.servlet.multipart.location");
            Long maxFileSize = Utils.getLongProperty(serviceReference, (String)"osgi.http.whiteboard.servlet.multipart.maxFileSize");
            Long maxRequestSize = Utils.getLongProperty(serviceReference, (String)"osgi.http.whiteboard.servlet.multipart.maxRequestSize");
            Integer fileSizeThreshold = Utils.getIntegerProperty(serviceReference, (String)"osgi.http.whiteboard.servlet.multipart.fileSizeThreshold");
            multiPartConfig = new MultipartConfigElement(null, maxFileSize == null ? -1L : maxFileSize, maxRequestSize == null ? -1L : maxRequestSize, fileSizeThreshold == null ? 0 : fileSizeThreshold);
        }
        String[] errorDeclarations = (String[])Utils.getPaxWebProperty(serviceReference, null, (String)"osgi.http.whiteboard.servlet.errorPage", Utils::asStringArray);
        Servlet service = null;
        try {
            service = (Servlet)serviceReference.getBundle().getBundleContext().getService(serviceReference);
            if (service != null) {
                ServletAnnotationScanner scanner = new ServletAnnotationScanner(service.getClass());
                if (scanner.scanned.booleanValue()) {
                    if (scanner.urlPatterns != null && scanner.urlPatterns.length > 0) {
                        if (urlPatterns != null && urlPatterns.length > 0) {
                            this.log.warn("Servlet URL patterns specified using both service property ({}) and annotation ({}). Choosing {}.", new Object[]{Arrays.asList(urlPatterns), Arrays.asList(scanner.urlPatterns), Arrays.asList(urlPatterns)});
                        } else {
                            urlPatterns = scanner.urlPatterns;
                        }
                    }
                    if (scanner.servletName != null) {
                        if (name != null) {
                            this.log.warn("Servlet name specified using both service property ({}) and annotation ({}). Choosing {}.", new Object[]{name, scanner.servletName, name});
                        } else {
                            name = scanner.servletName;
                        }
                    }
                    if (scanner.webInitParams != null) {
                        if (!initParams.isEmpty()) {
                            this.log.warn("Servlet init parameters specified using both service property ({}) and annotation ({}). Choosing {}.", new Object[]{initParams, scanner.webInitParams, initParams});
                        } else {
                            initParams.putAll(scanner.webInitParams);
                        }
                    }
                    if (scanner.asyncSupported != null) {
                        if (asyncSupported != null && asyncSupported != scanner.asyncSupported) {
                            this.log.warn("Servlet async flag specified using both service property ({}) and annotation ({}). Choosing {}.", new Object[]{asyncSupported, scanner.asyncSupported, asyncSupported});
                        } else {
                            asyncSupported = scanner.asyncSupported;
                        }
                    }
                    if (scanner.loadOnStartup != null) {
                        if (loadOnStartup != null) {
                            this.log.warn("Load-on-startup value specified using both service property ({}) and annotation ({}). Choosing {}.", new Object[]{loadOnStartup, scanner.loadOnStartup, loadOnStartup});
                        } else {
                            loadOnStartup = scanner.loadOnStartup;
                        }
                    }
                    if (scanner.multiPartConfigAnnotation != null) {
                        if (multiPartConfig != null) {
                            this.log.warn("Multipart configuration specified using both service property ({}) and annotation ({}). Choosing {}.", new Object[]{multiPartConfig, scanner.multiPartConfigAnnotation, multiPartConfig});
                        } else {
                            multiPartConfig = new MultipartConfigElement(scanner.multiPartConfigAnnotation);
                        }
                    }
                }
            }
        }
        finally {
            if (service != null) {
                serviceReference.getBundle().getBundleContext().ungetService(serviceReference);
            }
        }
        ServletModel.Builder builder = new ServletModel.Builder().withServiceRankAndId(rank.intValue(), serviceId.longValue()).withServletReference(serviceReference.getBundle(), serviceReference).withAlias(alias).withUrlPatterns(urlPatterns).withServletName(name).withInitParams(initParams).withAsyncSupported(asyncSupported).withLoadOnStartup(loadOnStartup).withMultipartConfigElement(multiPartConfig).withErrorDeclarations(errorDeclarations);
        ServletModel model = builder.build();
        if (propertiesInvalid) {
            model.setDtoFailureCode(6);
        }
        return model;
    }
}

