/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import java.util.EventListener;
import org.ops4j.pax.web.extender.whiteboard.internal.WhiteboardExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractElementTracker;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.events.EventListenerEventData;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerTracker
extends AbstractElementTracker<EventListener, EventListener, EventListenerEventData, EventListenerModel> {
    public static final Logger LOG = LoggerFactory.getLogger(ListenerTracker.class);

    private ListenerTracker(WhiteboardExtenderContext whiteboardExtenderContext, BundleContext bundleContext) {
        super(whiteboardExtenderContext, bundleContext);
    }

    public static ServiceTracker<EventListener, EventListenerModel> createTracker(WhiteboardExtenderContext whiteboardExtenderContext, BundleContext bundleContext) {
        StringBuilder classes = new StringBuilder();
        for (Class c : EventListenerModel.SUPPORTED_LISTENER_CLASSES) {
            classes.append("(objectClass=").append(c.getName()).append(")");
        }
        String filter = String.format("(&(|%s)(%s=*))", classes.toString(), "osgi.http.whiteboard.listener");
        return new ListenerTracker(whiteboardExtenderContext, bundleContext).create(filter);
    }

    @Override
    protected EventListenerModel createElementModel(ServiceReference<EventListener> serviceReference, Integer rank, Long serviceId) {
        Boolean isListener = Utils.getBooleanProperty(serviceReference, (String)"osgi.http.whiteboard.listener");
        Integer dtoFailureCode = null;
        if (isListener == null || !isListener.booleanValue()) {
            LOG.debug("Listener service reference doesn't have a property {}=true", (Object)"osgi.http.whiteboard.listener");
            dtoFailureCode = 6;
        }
        EventListenerModel model = new EventListenerModel();
        model.setRegisteringBundle(serviceReference.getBundle());
        model.setElementReference(serviceReference);
        model.setServiceRank(rank.intValue());
        model.setServiceId(serviceId.longValue());
        if (dtoFailureCode != null) {
            model.setDtoFailureCode(dtoFailureCode.intValue());
        }
        return model;
    }
}

