/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import java.util.Hashtable;
import org.ops4j.pax.web.extender.whiteboard.internal.WhiteboardExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractElementTracker;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.ops4j.pax.web.service.whiteboard.ContextMapping;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContextTracker<S>
implements ServiceTrackerCustomizer<S, OsgiContextModel> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractElementTracker.class);
    protected final BundleContext bundleContext;
    protected boolean whiteboardSynchronous = false;
    private final WhiteboardExtenderContext whiteboardExtenderContext;

    protected AbstractContextTracker(WhiteboardExtenderContext whiteboardExtenderContext, BundleContext bundleContext) {
        this.whiteboardExtenderContext = whiteboardExtenderContext;
        this.bundleContext = bundleContext;
        String flag = bundleContext.getProperty("org.ops4j.pax.web.extender.whiteboard.synchronous");
        this.whiteboardSynchronous = Boolean.parseBoolean(flag);
    }

    protected final ServiceTracker<S, OsgiContextModel> create(Class<? extends S> trackedClass) {
        return new ServiceTracker(this.bundleContext, Utils.createFilter((BundleContext)this.bundleContext, (Class[])new Class[]{trackedClass}), (ServiceTrackerCustomizer)this);
    }

    protected abstract void configureContextModel(ServiceReference<S> var1, OsgiContextModel var2);

    protected void cleanupContextModel(ServiceReference<S> serviceReference, OsgiContextModel unpublished) {
    }

    public OsgiContextModel addingService(ServiceReference<S> serviceReference) {
        Long serviceId;
        if (this.skipInternalService(serviceReference)) {
            return null;
        }
        LOG.debug("Processing new Whiteboard context reference: {}", serviceReference);
        Integer rank = 0;
        Object rankObject = serviceReference.getProperty("service.ranking");
        if (rankObject instanceof Integer) {
            rank = (Integer)rankObject;
        }
        if ((serviceId = (Long)serviceReference.getProperty("service.id")) == null) {
            serviceId = 0L;
        }
        OsgiContextModel model = new OsgiContextModel(serviceReference.getBundle(), rank, serviceId, true);
        model.setAsynchronusRegistration(!this.whiteboardSynchronous);
        LOG.debug("Configuring OSGi context model from Whiteboard service {} (id={})", serviceReference, (Object)serviceId);
        this.configureContextModel(serviceReference, model);
        if (model.isValid()) {
            this.whiteboardExtenderContext.addWebContext(serviceReference.getBundle(), model);
            return model;
        }
        this.whiteboardExtenderContext.configureFailedDTOs(model);
        return model;
    }

    public void modifiedService(ServiceReference<S> reference, OsgiContextModel model) {
        if (this.skipInternalService(reference)) {
            return;
        }
        LOG.debug("Processing Whiteboard context reference change: {}", reference);
        this.removedService(reference, model);
        int rank = 0;
        Object rankObject = reference.getProperty("service.ranking");
        if (rankObject instanceof Integer) {
            rank = (Integer)rankObject;
        }
        model.setServiceRank(rank);
        this.configureContextModel(reference, model);
        if (model.isValid()) {
            this.whiteboardExtenderContext.addWebContext(reference.getBundle(), model);
        } else {
            this.whiteboardExtenderContext.configureFailedDTOs(model);
        }
    }

    public void removedService(ServiceReference<S> serviceReference, OsgiContextModel unpublished) {
        if (this.skipInternalService(serviceReference)) {
            return;
        }
        LOG.debug("Whiteboard context removed: {}", serviceReference);
        this.whiteboardExtenderContext.removeWebContext(serviceReference.getBundle(), unpublished);
        this.cleanupContextModel(serviceReference, unpublished);
    }

    private boolean skipInternalService(ServiceReference<S> serviceReference) {
        return Utils.getBooleanProperty(serviceReference, (String)"org.ops4j.pax.web.internal");
    }

    protected void setupArtificialServiceRegistrationProperties(OsgiContextModel model, ContextMapping mapping, boolean whiteboard) {
        String contextPath;
        Hashtable registration = model.getContextRegistrationProperties();
        String contextId = mapping.getContextId();
        if (contextId == null) {
            contextId = "default";
        }
        if ((contextPath = mapping.getContextPath()) == null) {
            contextPath = "/";
        }
        if (whiteboard) {
            registration.put("osgi.http.whiteboard.context.name", contextId);
            registration.put("osgi.http.whiteboard.context.path", contextPath);
        } else {
            registration.put("httpContext.id", contextId);
            registration.put("httpContext.path", contextPath);
        }
        if (mapping.getInitParameters() != null) {
            mapping.getInitParameters().forEach((k, v) -> registration.put("context.init." + k, v));
        }
    }

    protected String setupName(OsgiContextModel model, ContextMapping mapping) {
        String name = mapping.getContextId();
        if (name == null || "".equals(name.trim())) {
            name = "default";
        }
        model.setName(name);
        return name;
    }

    protected String setupContextPath(OsgiContextModel model, ContextMapping mapping) {
        String contextPath = mapping.getContextPath();
        if (contextPath == null || "".equals(contextPath.trim())) {
            contextPath = "/";
        }
        model.setContextPath(contextPath);
        return contextPath;
    }
}

